/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.properties;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.gui.properties.PropertyKeyCellEditor;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeParameterValue;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;

public class ParameterValueKeyCellEditor
extends AbstractCellEditor
implements PropertyKeyCellEditor {
    private static final long serialVersionUID = -2559892872774108384L;
    private JPanel panel = new JPanel();
    private JComboBox operatorCombo = new JComboBox();
    private JComboBox parameterCombo = new JComboBox();
    private transient OperatorChain parentOperator;
    private transient Experiment experiment;

    public ParameterValueKeyCellEditor(ParameterTypeParameterValue type) {
    }

    public Object readResolve() {
        this.experiment = this.parentOperator.getExperiment();
        return this;
    }

    public void setOperator(Operator operator) {
        this.parentOperator = (OperatorChain)operator;
        this.experiment = this.parentOperator.getExperiment();
        this.operatorCombo = this.createOperatorCombo();
        this.fillParameterCombo();
        this.panel.setLayout(new GridLayout(1, 2));
        this.panel.add(this.operatorCombo);
        this.panel.add(this.parameterCombo);
    }

    private JComboBox createOperatorCombo() {
        List<Operator> allInnerOps = this.parentOperator.getAllInnerOperators();
        Vector<String> allOpNames = new Vector<String>();
        Iterator<Operator> i = allInnerOps.iterator();
        while (i.hasNext()) {
            allOpNames.add(i.next().getName());
        }
        Collections.sort(allOpNames);
        JComboBox<String> combo = new JComboBox<String>(allOpNames);
        combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ParameterValueKeyCellEditor.this.fillParameterCombo();
                ParameterValueKeyCellEditor.this.fireEditingStopped();
            }
        });
        if (combo.getItemCount() == 0) {
            combo.addItem("add inner operators");
        } else {
            combo.setSelectedIndex(0);
        }
        return combo;
    }

    private void fillParameterCombo() {
        this.parameterCombo.removeAllItems();
        Operator operator = this.experiment.getOperator((String)this.operatorCombo.getSelectedItem());
        if (operator != null) {
            Iterator<ParameterType> i = operator.getParameterTypes().iterator();
            while (i.hasNext()) {
                this.parameterCombo.addItem(i.next().getKey());
            }
        }
        if (this.parameterCombo.getItemCount() == 0) {
            this.parameterCombo.addItem("no parameters");
        }
        this.parameterCombo.setSelectedIndex(0);
        this.parameterCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ParameterValueKeyCellEditor.this.fireEditingStopped();
            }
        });
    }

    public Object getCellEditorValue() {
        String result = this.operatorCombo.getSelectedItem() + "." + this.parameterCombo.getSelectedItem();
        return result;
    }

    public void setValue(String valueName) {
        if (valueName != null) {
            String[] components = valueName.split("\\.");
            if (components.length == 2) {
                String operator = components[0];
                String parameterName = components[1];
                this.operatorCombo.setSelectedItem(operator);
                this.parameterCombo.setSelectedItem(parameterName);
            } else {
                this.operatorCombo.setSelectedIndex(0);
                this.parameterCombo.setSelectedIndex(0);
            }
        } else {
            this.operatorCombo.setSelectedIndex(0);
            this.parameterCombo.setSelectedIndex(0);
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.setValue((String)value);
        return this.panel;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }
}

