/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.properties;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.gui.properties.PropertyValueCellEditor;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeValue;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;

public class OperatorValueValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = 2332956173516489926L;
    private JPanel panel = new JPanel();
    private JComboBox operatorCombo;
    private JComboBox typeCombo = new JComboBox<String>(new String[]{"value", "parameter"});
    private JComboBox valueCombo = new JComboBox();
    private transient Experiment experiment;

    public OperatorValueValueCellEditor(ParameterTypeValue type) {
    }

    public void setOperator(Operator operator) {
        this.experiment = operator.getExperiment();
        this.operatorCombo = this.createOperatorCombo();
        this.typeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                OperatorValueValueCellEditor.this.fillValueCombo();
                OperatorValueValueCellEditor.this.fireEditingStopped();
            }
        });
        this.valueCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                OperatorValueValueCellEditor.this.fireEditingStopped();
            }
        });
        this.fillValueCombo();
        this.panel.setLayout(new GridLayout(1, 3));
        this.panel.add(this.operatorCombo);
        this.panel.add(this.typeCombo);
        this.panel.add(this.valueCombo);
    }

    private JComboBox createOperatorCombo() {
        Vector<String> allOps = new Vector<String>(this.experiment.getAllOperatorNames());
        Collections.sort(allOps);
        JComboBox<String> combo = new JComboBox<String>(allOps);
        combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                OperatorValueValueCellEditor.this.fillValueCombo();
                OperatorValueValueCellEditor.this.fireEditingStopped();
            }
        });
        return combo;
    }

    private void fillValueCombo() {
        this.valueCombo.removeAllItems();
        Operator operator = this.experiment.getOperator((String)this.operatorCombo.getSelectedItem());
        switch (this.typeCombo.getSelectedIndex()) {
            case 0: {
                Iterator<Value> i = operator.getValues().iterator();
                while (i.hasNext()) {
                    this.valueCombo.addItem(i.next().getKey());
                }
                if (this.valueCombo.getItemCount() != 0) break;
                this.valueCombo.addItem("no values");
                break;
            }
            case 1: {
                Iterator<ParameterType> i = operator.getParameterTypes().iterator();
                while (i.hasNext()) {
                    this.valueCombo.addItem(i.next().getKey());
                }
                if (this.valueCombo.getItemCount() != 0) break;
                this.valueCombo.addItem("no params");
            }
        }
        this.valueCombo.setSelectedIndex(0);
    }

    public Object getCellEditorValue() {
        return "operator." + this.operatorCombo.getSelectedItem() + "." + (this.typeCombo.getSelectedIndex() == 0 ? "value" : "parameter") + "." + this.valueCombo.getSelectedItem();
    }

    public void setValue(String valueName) {
        if (valueName != null) {
            String[] components = valueName.split("\\.");
            if (components.length == 4) {
                String operator = components[1];
                int type = components[2].equals("parameter") ? 1 : 0;
                String name = components[3];
                this.operatorCombo.setSelectedItem(operator);
                this.typeCombo.setSelectedIndex(type);
                this.valueCombo.setSelectedItem(name);
            } else {
                this.operatorCombo.setSelectedIndex(0);
                this.typeCombo.setSelectedIndex(0);
                this.valueCombo.setSelectedIndex(0);
            }
        } else {
            this.operatorCombo.setSelectedIndex(0);
            this.typeCombo.setSelectedIndex(0);
            this.valueCombo.setSelectedIndex(0);
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.setValue((String)value);
        return this.panel;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }
}

