/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.properties;

import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.properties.SimplePropertyTable;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class OperatorPropertyTable
extends SimplePropertyTable {
    private static final long serialVersionUID = -4129852766426437419L;
    private MainFrame mainFrame;
    private transient Operator operator;
    private transient ParameterType[] parameterTypes;
    private boolean expertMode = false;

    public OperatorPropertyTable(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.setOperator(null);
    }

    public void toggleExpertMode() {
        this.expertMode = !this.expertMode;
        this.setOperator(this.operator);
    }

    public void setExpertMode(boolean expertMode) {
        this.expertMode = expertMode;
    }

    public boolean isExpertMode() {
        return this.expertMode;
    }

    public void refresh() {
        this.setOperator(this.operator);
    }

    public void stopCurrentEditing() {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
    }

    public void setOperator(Operator operator) {
        this.stopCurrentEditing();
        this.operator = operator;
        if (operator != null) {
            List<ParameterType> parameters = operator.getParameterTypes();
            LinkedList<ParameterType> viewableParameters = new LinkedList<ParameterType>();
            for (ParameterType type : parameters) {
                if (!this.expertMode && type.isExpert()) continue;
                viewableParameters.add(type);
            }
            this.parameterTypes = new ParameterType[viewableParameters.size()];
            viewableParameters.toArray(this.parameterTypes);
        } else {
            this.parameterTypes = new ParameterType[0];
        }
        this.updateTableData(this.parameterTypes.length);
        int i = 0;
        while (i < this.parameterTypes.length) {
            this.getModel().setValueAt(this.parameterTypes[i].getKey(), i, 0);
            Object value = this.parameterTypes[i].getDefaultValue();
            try {
                value = operator.getParameters().getParameter(this.parameterTypes[i].getKey());
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
            this.getModel().setValueAt(value, i, 1);
            ++i;
        }
        this.updateEditorsAndRenderers();
        this.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                OperatorPropertyTable.this.setValue(e.getFirstRow(), OperatorPropertyTable.this.getModel().getValueAt(e.getFirstRow(), 1));
                OperatorPropertyTable.this.mainFrame.experimentChanged();
            }
        });
    }

    public ParameterType getParameterType(int row) {
        return this.parameterTypes[row];
    }

    public Operator getOperator(int row) {
        return this.operator;
    }
}

