/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.properties;

import edu.udo.cs.yale.gui.properties.PropertyTable;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPropertyTable
extends PropertyTable {
    private static final long serialVersionUID = -4547732551646588939L;
    private transient ParameterTypeList type;
    private transient Operator operator;

    public ListPropertyTable(ParameterTypeList type, List<Object[]> parameterList, Operator operator) {
        super(new String[]{type.getKey(), type.getValueType().getKey()});
        this.type = type;
        this.operator = operator;
        this.updateTableData(parameterList.size());
        Iterator<Object[]> i = parameterList.iterator();
        int j = 0;
        while (i.hasNext()) {
            Object[] keyValue = i.next();
            this.getModel().setValueAt(keyValue[0], j, 0);
            this.getModel().setValueAt(keyValue[1], j, 1);
            ++j;
        }
        this.updateEditorsAndRenderers();
    }

    public void addRow() {
        this.getDefaultModel().addRow(new Object[]{"", this.type.getValueType().getDefaultValue()});
        this.updateEditorsAndRenderers();
    }

    public void removeSelected() {
        int[] selectedRow = this.getSelectedRows();
        int i = selectedRow.length - 1;
        while (i >= 0) {
            this.getDefaultModel().removeRow(selectedRow[i]);
            --i;
        }
        this.getDefaultModel().fireTableStructureChanged();
    }

    public void getParameterList(List<Object[]> list) {
        list.clear();
        int i = 0;
        while (i < this.getModel().getRowCount()) {
            list.add(new Object[]{this.getModel().getValueAt(i, 0), this.getModel().getValueAt(i, 1)});
            ++i;
        }
    }

    @Override
    public Operator getOperator(int row) {
        return this.operator;
    }

    @Override
    public ParameterType getParameterType(int row) {
        return this.type.getValueType();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }
}

