/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.properties;

import edu.udo.cs.yale.gui.properties.PropertyValueCellEditor;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypePassword;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class DefaultPropertyValueCellEditor
extends DefaultCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = 3594466409311826645L;
    private boolean useEditorAsRenderer = false;

    public DefaultPropertyValueCellEditor(ParameterTypeCategory type) {
        super(new JComboBox<String>(type.getValues()));
        this.editorComponent.setBackground(UIManager.getColor("Table.cellBackground"));
        this.useEditorAsRenderer = true;
        ((JComboBox)this.editorComponent).removeItemListener(this.delegate);
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            private static final long serialVersionUID = -2104662561680969750L;

            public void setValue(Object x) {
                super.setValue(x);
                ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelectedIndex((Integer)x);
            }

            public Object getCellEditorValue() {
                return ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).getSelectedIndex();
            }
        };
        ((JComboBox)this.editorComponent).addItemListener(this.delegate);
    }

    public DefaultPropertyValueCellEditor(ParameterTypeStringCategory type) {
        super(new JComboBox<String>(type.getValues()));
        this.editorComponent.setBackground(UIManager.getColor("Table.cellBackground"));
        this.useEditorAsRenderer = true;
        ((JComboBox)this.editorComponent).removeItemListener(this.delegate);
        ((JComboBox)this.editorComponent).setEditable(true);
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            private static final long serialVersionUID = -5592150438626222295L;

            public void setValue(Object x) {
                super.setValue(x);
                ((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).setSelectedItem(x);
            }

            public Object getCellEditorValue() {
                String selected = (String)((JComboBox)DefaultPropertyValueCellEditor.this.editorComponent).getSelectedItem();
                if (selected != null && selected.trim().length() == 0) {
                    selected = null;
                }
                return selected;
            }
        };
    }

    public DefaultPropertyValueCellEditor(ParameterTypeBoolean type) {
        super(new JCheckBox());
        ((JCheckBox)this.editorComponent).setHorizontalAlignment(0);
        this.editorComponent.setBackground(UIManager.getColor("Table.cellBackground"));
        this.useEditorAsRenderer = true;
    }

    public DefaultPropertyValueCellEditor(final ParameterTypeInt type) {
        super(new JTextField());
        ((JTextField)this.editorComponent).setHorizontalAlignment(2);
        ((JTextField)this.editorComponent).setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            private static final long serialVersionUID = 152467444047540403L;

            public void setValue(Object x) {
                super.setValue(x);
                if (x != null) {
                    if (x instanceof Integer || x instanceof String) {
                        ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(x.toString());
                    } else {
                        throw new IllegalArgumentException("Illegal value class for integer parameter: " + x.getClass().getName());
                    }
                }
            }

            public Object getCellEditorValue() {
                try {
                    int i = Integer.parseInt(((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).getText());
                    if ((double)i < type.getMinValue()) {
                        i = (int)type.getMinValue();
                    }
                    if ((double)i > type.getMaxValue()) {
                        i = (int)type.getMaxValue();
                    }
                    return i;
                }
                catch (NumberFormatException e) {
                    return type.getDefaultValue();
                }
            }
        };
        this.editorComponent.setToolTipText(String.valueOf(type.getDescription()) + " (" + type.getRange() + ")");
        this.useEditorAsRenderer = true;
    }

    public DefaultPropertyValueCellEditor(final ParameterTypeDouble type) {
        super(new JTextField());
        ((JTextField)this.editorComponent).setHorizontalAlignment(2);
        ((JTextField)this.editorComponent).setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            private static final long serialVersionUID = 5764937097891322370L;

            public void setValue(Object x) {
                super.setValue(x);
                if (x != null) {
                    if (x instanceof Double || x instanceof String) {
                        ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(x.toString());
                    } else {
                        throw new IllegalArgumentException("Illegal value class for double parameter: " + x.getClass().getName());
                    }
                }
            }

            public Object getCellEditorValue() {
                try {
                    double d = Double.parseDouble(((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).getText());
                    if (d < type.getMinValue()) {
                        d = type.getMinValue();
                    }
                    if (d > type.getMaxValue()) {
                        d = type.getMaxValue();
                    }
                    return new Double(d);
                }
                catch (NumberFormatException e) {
                    return type.getDefaultValue();
                }
            }
        };
        this.editorComponent.setToolTipText(String.valueOf(type.getDescription()) + " (" + type.getRange() + ")");
        this.useEditorAsRenderer = true;
    }

    public DefaultPropertyValueCellEditor(ParameterTypePassword type) {
        super(new JPasswordField());
        ((JPasswordField)this.editorComponent).setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.useEditorAsRenderer = true;
    }

    public DefaultPropertyValueCellEditor(final ParameterType type) {
        super(new JTextField());
        ((JTextField)this.editorComponent).setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.delegate = new DefaultCellEditor.EditorDelegate(this){
            private static final long serialVersionUID = -2868203350553070093L;

            public void setValue(Object x) {
                super.setValue(x);
                if (x != null) {
                    ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).setText(x.toString());
                }
            }

            public Object getCellEditorValue() {
                String text = ((JTextField)DefaultPropertyValueCellEditor.this.editorComponent).getText();
                if (text == null || text.length() == 0) {
                    return type.getDefaultValue();
                }
                return text;
            }
        };
        this.useEditorAsRenderer = true;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (isSelected) {
            c.setBackground(SwingTools.LIGHTEST_BLUE);
        } else {
            c.setBackground(Color.WHITE);
        }
        return c;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = this.getTableCellEditorComponent(table, value, isSelected, row, column);
        if (isSelected) {
            c.setBackground(SwingTools.LIGHTEST_BLUE);
        } else {
            c.setBackground(Color.WHITE);
        }
        return c;
    }

    public boolean useEditorAsRenderer() {
        return this.useEditorAsRenderer;
    }

    public void setOperator(Operator operator) {
    }
}

