/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.properties;

import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.properties.PropertyValueCellEditor;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.parameter.ParameterTypeColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JTable;

public class ColorValueCellEditor
extends AbstractCellEditor
implements PropertyValueCellEditor {
    private static final long serialVersionUID = -7069543356398085334L;
    private transient ParameterTypeColor type;
    private JButton button;

    public ColorValueCellEditor(final ParameterTypeColor type) {
        this.type = type;
        this.button = new JButton("Choose Color...");
        this.button.setToolTipText(type.getDescription());
        this.button.setIconTextGap(6);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(YaleGUI.getMainFrame(), "Choose Color for " + type.getKey(), ColorValueCellEditor.this.button.getBackground());
                if (newColor != null) {
                    ColorValueCellEditor.this.setEditorColor(newColor);
                }
                ColorValueCellEditor.this.fireEditingStopped();
            }
        });
    }

    public void setOperator(Operator operator) {
    }

    public void setEditorColor(Color color) {
        this.button.setIcon(new ColorIcon(color));
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        if (value == null) {
            this.setEditorColor(this.transformString2Color((String)this.type.getDefaultValue()));
        } else {
            this.setEditorColor(this.transformString2Color((String)value));
        }
        return this.button;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public Object getCellEditorValue() {
        Color color = ((ColorIcon)this.button.getIcon()).getColor();
        return String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue();
    }

    public boolean useEditorAsRenderer() {
        return true;
    }

    private Color transformString2Color(String value) {
        String[] colors = value.split(",");
        Color color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
        return color;
    }

    private static class ColorIcon
    implements Icon {
        private Color color;

        private ColorIcon(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public int getIconWidth() {
            return 20;
        }

        public int getIconHeight() {
            return 8;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRoundRect(x, y, this.getIconWidth(), this.getIconHeight(), 2, 2);
            g.setColor(Color.black);
            g.drawRoundRect(x, y, this.getIconWidth(), this.getIconHeight(), 2, 2);
        }
    }
}

