/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter.mathplot;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.gui.plotter.conditions.PlotterCondition;
import edu.udo.cs.yale.gui.plotter.conditions.RowsPlotterCondition;
import edu.udo.cs.yale.gui.plotter.mathplot.JMathPlotter3D;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.math.plot.Plot3DPanel;

public class SurfacePlot3D
extends JMathPlotter3D {
    private static final long serialVersionUID = -8086776011628491876L;
    private static final int MAX_NUMBER_OF_ROWS = 50;

    public SurfacePlot3D() {
    }

    public SurfacePlot3D(DataTable dataTable) {
        super(dataTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.getAxis(0) != -1 && this.getAxis(1) != -1) {
            this.getPlotPanel().removeAllPlots();
            int totalNumberOfColumns = this.countColumns();
            int currentVariable = 0;
            while (currentVariable < totalNumberOfColumns) {
                if (this.getPlotColumn(currentVariable)) {
                    DataTable table;
                    TreeSet<Double> xSet = new TreeSet<Double>();
                    TreeSet<Double> ySet = new TreeSet<Double>();
                    HashMap<String, Double> zMap = new HashMap<String, Double>();
                    DataTable dataTable = table = this.getDataTable();
                    synchronized (dataTable) {
                        for (DataTableRow row : table) {
                            double x = row.getValue(this.getAxis(0));
                            double y = row.getValue(this.getAxis(1));
                            xSet.add(x);
                            ySet.add(y);
                            zMap.put(String.valueOf(x) + "+" + y, row.getValue(currentVariable));
                        }
                        int size = Math.max(xSet.size(), ySet.size());
                        double[] xArray = new double[size];
                        double[] yArray = new double[size];
                        double[][] zArray = new double[size][size];
                        int xCounter = 0;
                        Iterator x = xSet.iterator();
                        double last = 0.0;
                        while (x.hasNext()) {
                            xArray[xCounter] = (Double)x.next();
                            Iterator y = ySet.iterator();
                            int yCounter = 0;
                            while (y.hasNext()) {
                                yArray[yCounter] = (Double)y.next();
                                Double value = (Double)zMap.get(String.valueOf(xArray[xCounter]) + "+" + yArray[yCounter]);
                                if (value != null) {
                                    zArray[xCounter][yCounter] = value;
                                    last = value;
                                } else {
                                    zArray[xCounter][yCounter] = last;
                                }
                                ++yCounter;
                            }
                            ++xCounter;
                        }
                        if (xArray.length > 0 && yArray.length > 0 && zArray.length > 0) {
                            Color color = SurfacePlot3D.getPointColor((double)currentVariable / (double)totalNumberOfColumns);
                            ((Plot3DPanel)this.getPlotPanel()).addGridPlot(this.getDataTable().getColumnName(currentVariable), color, xArray, yArray, zArray);
                        }
                    }
                }
                ++currentVariable;
            }
        }
    }

    public PlotterCondition getPlotterCondition() {
        return new RowsPlotterCondition(50);
    }

    public int getValuePlotSelectionType() {
        return 1;
    }

    public String getPlotName() {
        return "z-Axis";
    }
}

