/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter.mathplot;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.gui.plotter.mathplot.JMathPlotter3D;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import org.math.plot.Plot3DPanel;

public class SticksPlot3D
extends JMathPlotter3D {
    private static final long serialVersionUID = -2241823488299009239L;

    public SticksPlot3D() {
    }

    public SticksPlot3D(DataTable dataTable) {
        super(dataTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.getAxis(0) != -1 && this.getAxis(1) != -1) {
            this.getPlotPanel().removeAllPlots();
            int totalNumberOfColumns = this.countColumns();
            int currentVariable = 0;
            while (currentVariable < totalNumberOfColumns) {
                if (this.getPlotColumn(currentVariable)) {
                    DataTable table;
                    DataTable dataTable = table = this.getDataTable();
                    synchronized (dataTable) {
                        Iterator<DataTableRow> iterator = table.iterator();
                        int i = 0;
                        double[][] data = new double[this.getDataTable().getNumberOfRows()][3];
                        while (iterator.hasNext()) {
                            DataTableRow row = iterator.next();
                            data[i][0] = row.getValue(this.getAxis(0));
                            data[i][1] = row.getValue(this.getAxis(1));
                            data[i][2] = row.getValue(currentVariable);
                            ++i;
                        }
                        Color color = SticksPlot3D.getPointColor((double)currentVariable / (double)totalNumberOfColumns);
                        ((Plot3DPanel)this.getPlotPanel()).addBarPlot(this.getDataTable().getColumnName(currentVariable), color, data);
                    }
                }
                ++currentVariable;
            }
        }
    }

    public int getValuePlotSelectionType() {
        return 1;
    }

    public String getPlotName() {
        return "z-Axis";
    }
}

