/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter.mathplot;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.gui.plotter.PlotterAdapter;
import edu.udo.cs.yale.gui.plotter.PlotterLegend;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.math.plot.PlotPanel;

public abstract class JMathPlotter
extends PlotterAdapter {
    private static final String LEGEND_POSITION = "NORTH";
    private DataTable dataTable;
    private PlotPanel plotpanel = this.createPlotPanel();
    private PlotterLegend legend;
    private boolean[] columns;
    private int[] axis;

    public JMathPlotter() {
        this.plotpanel.plotToolBar.remove(5);
        this.plotpanel.removePlotToolBar();
        if (this.hasLegend()) {
            this.plotpanel.addLegend(LEGEND_POSITION);
        }
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        if (this.hasYaleValueLegend()) {
            this.legend = new PlotterLegend(this);
            c.weighty = 0.0;
            JPanel legendPanel = new JPanel(new FlowLayout(1));
            legendPanel.setBackground(Color.white);
            legendPanel.add(this.legend);
            layout.setConstraints(legendPanel, c);
            this.add(legendPanel);
        }
        c.weighty = 1.0;
        layout.setConstraints((Component)this.plotpanel, c);
        this.add((Component)this.plotpanel);
        this.axis = new int[this.getNumberOfAxes()];
        int i = 0;
        while (i < this.axis.length) {
            this.axis[i] = -1;
            ++i;
        }
    }

    public JMathPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    protected abstract PlotPanel createPlotPanel();

    protected PlotterLegend getLegendComponent() {
        return this.legend;
    }

    protected boolean hasLegend() {
        return true;
    }

    protected boolean hasYaleValueLegend() {
        return false;
    }

    protected DataTable getDataTable() {
        return this.dataTable;
    }

    protected int countColumns() {
        return this.columns.length;
    }

    protected PlotPanel getPlotPanel() {
        return this.plotpanel;
    }

    public void setAxis(int index, int dimension) {
        if (index >= 0 && index < this.getNumberOfAxes() && this.axis[index] != dimension) {
            this.axis[index] = dimension;
        }
        this.repaint();
    }

    public int getAxis(int index) {
        if (index >= 0 && index < this.getNumberOfAxes()) {
            return this.axis[index];
        }
        return -1;
    }

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.columns = new boolean[dataTable.getNumberOfColumns()];
    }

    public Icon getIcon(int index) {
        return null;
    }

    public int getNumberOfAxes() {
        return 2;
    }

    public String getAxisName(int index) {
        switch (index) {
            case 0: {
                return "x-Axis";
            }
            case 1: {
                return "y-Axis";
            }
        }
        return "none";
    }

    public void setPlotColumn(int index, boolean plot) {
        if (this.getValuePlotSelectionType() == 1) {
            if (this.columns[index] != plot && index != -1) {
                this.columns[index] = plot;
            }
        } else {
            this.columns = new boolean[this.columns.length];
            if (index != -1) {
                this.columns[index] = plot;
            }
        }
        this.repaint();
    }

    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.plotpanel.plotToolBar;
        }
        return null;
    }

    public boolean hasSaveImageButton() {
        return true;
    }
}

