/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter.conditions;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.gui.plotter.conditions.PlotterCondition;

public class RowsPlotterCondition
implements PlotterCondition {
    private int minRows;
    private int maxRows;

    public RowsPlotterCondition(int maxRows) {
        this(0, maxRows);
    }

    public RowsPlotterCondition(int minRows, int maxRows) {
        this.minRows = minRows;
        this.maxRows = maxRows;
    }

    public boolean acceptDataTable(DataTable dataTable) {
        int numberOfRows = dataTable.getNumberOfRows();
        return numberOfRows >= this.minRows && numberOfRows <= this.maxRows;
    }

    public String getRejectionReason(DataTable dataTable) {
        return "Data table must have between " + this.minRows + " and " + this.maxRows + " rows, was " + dataTable.getNumberOfRows() + ".";
    }
}

