/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter.conditions;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.gui.plotter.conditions.PlotterCondition;

public class ColumnsPlotterCondition
implements PlotterCondition {
    private int minColumns;
    private int maxColumns;

    public ColumnsPlotterCondition(int maxColumns) {
        this(0, maxColumns);
    }

    public ColumnsPlotterCondition(int minColumns, int maxColumns) {
        this.minColumns = minColumns;
        this.maxColumns = maxColumns;
    }

    public boolean acceptDataTable(DataTable dataTable) {
        int numberOfColumns = dataTable.getNumberOfColumns();
        return numberOfColumns >= this.minColumns && numberOfColumns <= this.maxColumns;
    }

    public String getRejectionReason(DataTable dataTable) {
        return "Data table must have between " + this.minColumns + " and " + this.maxColumns + " columns, was " + dataTable.getNumberOfColumns() + ".";
    }
}

