/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter.charts;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.gui.plotter.PlotterAdapter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BubbleChartPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = 4568273282283350833L;
    private static final String[] axisNames = new String[]{"x-Axis", "y-Axis", "Bubble Size"};
    private static final int X_AXIS = 0;
    private static final int Y_AXIS = 1;
    private static final int BUBBLE_SIZE_AXIS = 2;
    private DataTable dataTable;
    private DefaultXYZDataset xyzDataSet = new DefaultXYZDataset();
    private int[] axis = new int[]{-1, -1, -1};
    private int colorColumn = -1;
    private double bubbleSizeMin = 0.0;
    private double bubbleSizeMax = 1.0;
    private double xAxisMin = 0.0;
    private double xAxisMax = 1.0;
    private double yAxisMin = 0.0;
    private double yAxisMax = 1.0;

    public BubbleChartPlotter() {
        this.setBackground(Color.white);
    }

    public BubbleChartPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.repaint();
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.colorColumn = plot ? index : -1;
        this.repaint();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.colorColumn == index;
    }

    @Override
    public String getPlotName() {
        return "Color Column";
    }

    @Override
    public int getNumberOfAxes() {
        return 3;
    }

    @Override
    public void setAxis(int index, int dimension) {
        this.axis[index] = dimension;
        this.repaint();
    }

    @Override
    public int getAxis(int index) {
        return this.axis[index];
    }

    @Override
    public String getAxisName(int index) {
        return axisNames[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareData() {
        this.xyzDataSet = new DefaultXYZDataset();
        this.bubbleSizeMin = Double.POSITIVE_INFINITY;
        this.bubbleSizeMax = Double.NEGATIVE_INFINITY;
        this.xAxisMin = Double.POSITIVE_INFINITY;
        this.xAxisMax = Double.NEGATIVE_INFINITY;
        this.yAxisMin = Double.POSITIVE_INFINITY;
        this.yAxisMax = Double.NEGATIVE_INFINITY;
        LinkedHashMap<String, List<double[]>> dataCollection = new LinkedHashMap<String, List<double[]>>();
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            for (DataTableRow row : this.dataTable) {
                double xValue = Double.NaN;
                if (this.axis[0] >= 0) {
                    xValue = row.getValue(this.axis[0]);
                }
                double yValue = Double.NaN;
                if (this.axis[1] >= 0) {
                    yValue = row.getValue(this.axis[1]);
                }
                double bubbleSizeValue = Double.NaN;
                if (this.axis[2] >= 0) {
                    bubbleSizeValue = row.getValue(this.axis[2]);
                }
                double colorValue = Double.NaN;
                if (this.colorColumn >= 0) {
                    colorValue = row.getValue(this.colorColumn);
                }
                if (Double.isNaN(xValue) || Double.isNaN(yValue) || Double.isNaN(bubbleSizeValue)) continue;
                this.addPoint(dataCollection, xValue, yValue, bubbleSizeValue, colorValue);
            }
        }
        Iterator i = dataCollection.keySet().iterator();
        double scaleFactor = Math.min(this.xAxisMax - this.xAxisMin, this.yAxisMax - this.yAxisMin) / 4.0;
        while (i.hasNext()) {
            String seriesName = (String)i.next();
            List dataList = (List)dataCollection.get(seriesName);
            double[][] data = new double[3][dataList.size()];
            int listCounter = 0;
            for (double[] current : dataList) {
                data[0][listCounter] = current[0];
                data[1][listCounter] = current[1];
                data[2][listCounter] = ((current[2] - this.bubbleSizeMin) / (this.bubbleSizeMax - this.bubbleSizeMin) + 0.1) * scaleFactor;
                ++listCounter;
            }
            this.xyzDataSet.addSeries((Comparable)((Object)seriesName), data);
        }
    }

    private void addPoint(Map<String, List<double[]>> dataCollection, double x, double y, double z, double color) {
        List<double[]> dataList = null;
        if (Double.isNaN(color)) {
            dataList = dataCollection.get("All");
            if (dataList == null) {
                dataList = new LinkedList<double[]>();
                dataCollection.put("All", dataList);
            }
        } else {
            String name = String.valueOf(color);
            if (this.dataTable.isNominal(this.colorColumn)) {
                name = this.dataTable.mapIndex(this.colorColumn, (int)color);
            }
            if ((dataList = dataCollection.get(name)) == null) {
                dataList = new LinkedList<double[]>();
                dataCollection.put(name, dataList);
            }
        }
        this.bubbleSizeMin = Math.min(this.bubbleSizeMin, z);
        this.bubbleSizeMax = Math.max(this.bubbleSizeMax, z);
        this.xAxisMin = Math.min(this.xAxisMin, x);
        this.yAxisMin = Math.min(this.yAxisMin, y);
        this.xAxisMax = Math.max(this.xAxisMax, x);
        this.yAxisMax = Math.max(this.yAxisMax, y);
        dataList.add(new double[]{x, y, z});
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBubbleChart(g);
    }

    public void paintBubbleChart(Graphics graphics) {
        this.prepareData();
        JFreeChart chart = ChartFactory.createBubbleChart(null, null, null, (XYZDataset)this.xyzDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = chart.getLegend();
        if (legend != null) {
            legend.setPosition(RectangleEdge.TOP);
            legend.setFrame((BlockFrame)BlockBorder.NONE);
            legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
        }
        Rectangle2D.Double drawRect = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        chart.draw((Graphics2D)graphics, (Rectangle2D)drawRect);
    }
}

