/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter.charts;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.gui.plotter.PlotterAdapter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public abstract class AbstractBarChartPlotter
extends PlotterAdapter {
    private DataTable dataTable;
    private DefaultCategoryDataset categoryDataSet = new DefaultCategoryDataset();
    private int groupByColumn = -1;
    private int valueColumn = -1;

    public AbstractBarChartPlotter() {
        this.setBackground(Color.white);
    }

    public AbstractBarChartPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    public abstract JFreeChart createChart(CategoryDataset var1, String var2, String var3);

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.repaint();
    }

    public void setPlotColumn(int index, boolean plot) {
        this.valueColumn = plot ? index : -1;
        this.repaint();
    }

    public boolean getPlotColumn(int index) {
        return this.valueColumn == index;
    }

    public String getPlotName() {
        return "Value Column";
    }

    public int getNumberOfAxes() {
        return 1;
    }

    public void setAxis(int index, int dimension) {
        this.groupByColumn = dimension;
        this.repaint();
    }

    public int getAxis(int index) {
        return this.groupByColumn;
    }

    public String getAxisName(int index) {
        return "Group-By Column";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareData() {
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            Iterator<DataTableRow> i = this.dataTable.iterator();
            LinkedHashMap<String, Double> categoryValues = new LinkedHashMap<String, Double>();
            LinkedHashMap<String, AtomicInteger> categoryCounters = new LinkedHashMap<String, AtomicInteger>();
            while (i.hasNext()) {
                AtomicInteger categoryCounter;
                DataTableRow row = i.next();
                double value = Double.NaN;
                if (this.valueColumn >= 0) {
                    value = row.getValue(this.valueColumn);
                }
                if (Double.isNaN(value)) continue;
                String name = String.valueOf(value);
                if (this.groupByColumn >= 0) {
                    double nameValue = row.getValue(this.groupByColumn);
                    name = this.dataTable.isNominal(this.groupByColumn) ? this.dataTable.mapIndex(this.groupByColumn, (int)nameValue) : String.valueOf(nameValue);
                }
                if ((categoryCounter = (AtomicInteger)categoryCounters.get(name)) == null) {
                    categoryCounters.put(name, new AtomicInteger(1));
                } else {
                    categoryCounter.incrementAndGet();
                }
                Double oldValue = (Double)categoryValues.get(name);
                if (oldValue == null) {
                    categoryValues.put(name, value);
                    continue;
                }
                categoryValues.remove(name);
                categoryValues.put(name, oldValue + value);
            }
            this.categoryDataSet.clear();
            if (this.valueColumn >= 0) {
                for (String name : categoryCounters.keySet()) {
                    int counter = ((AtomicInteger)categoryCounters.get(name)).intValue();
                    double oldValue = (Double)categoryValues.get(name);
                    if (this.groupByColumn < 0) {
                        this.categoryDataSet.setValue(oldValue / (double)counter, (Comparable)((Object)this.dataTable.getColumnName(this.valueColumn)), (Comparable)((Object)name));
                        continue;
                    }
                    this.categoryDataSet.setValue(oldValue / (double)counter, (Comparable)((Object)name), (Comparable)((Object)this.dataTable.getColumnName(this.valueColumn)));
                }
            }
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBarChart(g);
    }

    public void paintBarChart(Graphics graphics) {
        this.prepareData();
        String groupByName = this.groupByColumn >= 0 ? this.dataTable.getColumnName(this.groupByColumn) : null;
        String valueName = this.valueColumn >= 0 ? this.dataTable.getColumnName(this.valueColumn) : null;
        JFreeChart chart = this.createChart((CategoryDataset)this.categoryDataSet, groupByName, valueName);
        chart.setBackgroundPaint((Paint)Color.white);
        LegendTitle legend = chart.getLegend();
        if (legend != null) {
            legend.setPosition(RectangleEdge.TOP);
            legend.setFrame((BlockFrame)BlockBorder.NONE);
            legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
        }
        Rectangle2D.Double drawRect = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        chart.draw((Graphics2D)graphics, (Rectangle2D)drawRect);
    }
}

