/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.ObjectVisualizer;
import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.plotter.ScatterPlotter;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SimplePlotterDialog
extends JDialog
implements MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = 3024071214549165747L;
    private ScatterPlotter plotter;
    private List<ObjectVisualizer> visualizers = new LinkedList<ObjectVisualizer>();

    public SimplePlotterDialog(DataTable dataTable) {
        this(dataTable, true);
    }

    public SimplePlotterDialog(DataTable dataTable, boolean modal) {
        this(YaleGUI.getMainFrame(), dataTable, -1, -1, modal);
    }

    public SimplePlotterDialog(Frame owner, DataTable dataTable, int width, int height, boolean modal) {
        super(owner, dataTable.getName(), modal);
        this.setDefaultCloseOperation(2);
        this.plotter = new ScatterPlotter(dataTable);
        this.plotter.addMouseMotionListener(this);
        this.plotter.addMouseListener(this);
        JComponent plotterComponent = this.plotter.getPlotter();
        plotterComponent.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)plotterComponent, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        if (this.plotter.isSaveable()) {
            JButton saveButton = new JButton("Save...");
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SimplePlotterDialog.this.plotter.save();
                }
            });
            buttonPanel.add(saveButton);
        }
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimplePlotterDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        if (width < 0 || height < 0) {
            this.setSize(600, 400);
        } else {
            this.setSize(width, height);
        }
        this.setLocationRelativeTo(owner);
    }

    public void setDrawRange(double minX, double maxX, double minY, double maxY) {
        this.plotter.setDrawRange(minX, maxX, minY, maxY);
    }

    public void setXAxis(int index) {
        this.plotter.setAxis(0, index);
    }

    public void setYAxis(int index) {
        this.plotter.setAxis(1, index);
    }

    public void plotColumn(int index, boolean plot) {
        this.plotter.setPlotColumn(index, plot);
    }

    public void setDraw2DLines(boolean v) {
        this.plotter.setDraw2DLines(v);
    }

    public void setKey(String key) {
        this.plotter.setKey(key);
    }

    private void ok() {
        this.dispose();
    }

    public void addObjectVisualizer(ObjectVisualizer visualizer) {
        this.visualizers.add(visualizer);
    }

    public void removeObjectVisualizer(ObjectVisualizer visualizer) {
        this.visualizers.remove(visualizer);
    }

    private void fireVisualizationEvent(String id) {
        for (ObjectVisualizer visualizer : this.visualizers) {
            if (!visualizer.isCapableToVisualize(id)) continue;
            visualizer.startVisualization(id);
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.plotter.setMousePosInDataSpace(e.getX(), e.getY());
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        String id;
        if (e.getButton() == 1 && e.getClickCount() > 1 && (id = this.plotter.getIdForPos(e.getX(), e.getY())) != null) {
            this.fireVisualizationEvent(id);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

