/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.gui.plotter.AxisTransformation;
import edu.udo.cs.yale.gui.plotter.AxisTransformationId;
import edu.udo.cs.yale.gui.plotter.AxisTransformationLog;
import edu.udo.cs.yale.gui.plotter.ColorPlotterPoint;
import edu.udo.cs.yale.gui.plotter.Plot;
import edu.udo.cs.yale.gui.plotter.PlotterAdapter;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.tools.LogService;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ScatterPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = -6640810053422867017L;
    public static final String[] POINT_TYPES = new String[]{"lines", "points"};
    private static final Font SCALED_LABEL_FONT = LABEL_FONT.deriveFont(AffineTransform.getScaleInstance(1.0, -1.0));
    public static final int LINES = 0;
    public static final int POINTS = 1;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private static final int LABEL_MARGIN_X = 15;
    private static final int LABEL_MARGIN_Y = 50;
    private transient DataTable dataTable;
    protected List<Plot> plots = new LinkedList<Plot>();
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double minColor;
    private double maxColor;
    private double xTicSize;
    private double yTicSize;
    private int colorColumn = -1;
    private double drawMinX = Double.NEGATIVE_INFINITY;
    private double drawMaxX = Double.POSITIVE_INFINITY;
    private double drawMinY = Double.NEGATIVE_INFINITY;
    private double drawMaxY = Double.POSITIVE_INFINITY;
    private int[] axis = new int[]{-1, -1};
    private int currentPlotterXAxis = -1;
    private int currentPlotterYAxis = -1;
    private boolean[] columns;
    private String currentToolTip = null;
    private double toolTipX = 0.0;
    private double toolTipY = 0.0;
    private int dragX;
    private int dragY;
    private int dragWidth;
    private int dragHeight;
    private boolean drawAxes = true;
    private boolean drawLabel = true;
    private boolean draw2DLines = true;
    private boolean drawLegend = true;
    private String key = null;
    private JComboBox pointTypeSelection;
    private int pointType = 0;
    private int jitterAmount = 0;
    AffineTransform transform;
    AxisTransformation xTransformation = new AxisTransformationId();
    AxisTransformation yTransformation = new AxisTransformationId();

    public ScatterPlotter() {
        this.setBackground(Color.white);
        this.pointTypeSelection = new JComboBox<String>(POINT_TYPES);
        this.pointTypeSelection.setToolTipText("Indicates which type of points should be used for plotting.");
        this.pointTypeSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScatterPlotter.this.setPointType(ScatterPlotter.this.pointTypeSelection.getSelectedIndex());
            }
        });
    }

    public ScatterPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.columns = new boolean[dataTable.getNumberOfColumns()];
    }

    private void setPointType(int pointType) {
        this.pointType = pointType;
        this.repaint();
    }

    public String getAxisName(int index) {
        switch (index) {
            case 0: {
                return "x-Axis";
            }
            case 1: {
                return "y-Axis";
            }
        }
        return "none";
    }

    public int getValuePlotSelectionType() {
        return 1;
    }

    public boolean isSaveable() {
        return true;
    }

    public void save() {
        JFileChooser chooser = SwingTools.createFileChooser(null, false, new FileFilter[0]);
        if (chooser.showSaveDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            try {
                PrintWriter out = new PrintWriter(new FileWriter(file));
                this.dataTable.write(out);
                out.close();
            }
            catch (Exception ex) {
                SwingTools.showErrorMessage("Cannot write to file '" + file + "'", ex);
            }
        }
    }

    public int getNumberOfAxes() {
        return this.axis.length;
    }

    public void setAxis(int index, int dimension) {
        if (this.axis[index] != dimension) {
            this.axis[index] = dimension;
            this.repaint();
        }
    }

    public int getAxis(int index) {
        return this.axis[index];
    }

    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.pointTypeSelection;
        }
        return null;
    }

    public boolean canHandleJitter() {
        return true;
    }

    public void setJitter(int jitter) {
        this.jitterAmount = jitter;
        this.repaint();
    }

    protected void clearPlotColumns() {
        int i = 0;
        while (i < this.columns.length) {
            this.columns[i] = false;
            ++i;
        }
    }

    public void setPlotColumn(int index, boolean plot) {
        if (this.columns[index] != plot) {
            this.columns[index] = plot;
        }
        this.repaint();
    }

    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    public void setDrawLegend(boolean drawLegend) {
        this.drawLegend = drawLegend;
    }

    public boolean getDrawLegend() {
        return this.drawLegend;
    }

    public Point2D getPositionInDataSpace(Point point) {
        Point2D p = null;
        if (this.transform != null) {
            try {
                p = this.transform.inverseTransform(point, null);
                p = new Point2D.Double(this.xTransformation.inverseTransform(p.getX()), this.yTransformation.inverseTransform(p.getY()));
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        return p;
    }

    public void setDrawRange(double drawMinX, double drawMaxX, double drawMinY, double drawMaxY) {
        if (drawMinX == -1.0 || drawMaxX == -1.0 || drawMinY == -1.0 || drawMaxY == -1.0) {
            this.drawMinX = Double.NEGATIVE_INFINITY;
            this.drawMaxX = Double.POSITIVE_INFINITY;
            this.drawMinY = Double.NEGATIVE_INFINITY;
            this.drawMaxY = Double.POSITIVE_INFINITY;
        } else {
            this.drawMinX = drawMinX;
            this.drawMaxX = drawMaxX;
            this.drawMinY = drawMinY;
            this.drawMaxY = drawMaxY;
        }
        this.repaint();
    }

    private int getNumberOfCurrentlySelectedPlots() {
        int counter = 0;
        int column = 0;
        while (column < this.columns.length) {
            if (this.columns[column]) {
                ++counter;
            }
            ++column;
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareData() {
        this.plots.clear();
        this.maxColor = Double.NEGATIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        this.minColor = Double.POSITIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.minX = Double.POSITIVE_INFINITY;
        if (this.axis[0] < 0) {
            return;
        }
        this.currentPlotterXAxis = this.axis[0];
        this.currentPlotterYAxis = -1;
        int column = 0;
        while (column < this.columns.length) {
            if (this.columns[column]) {
                Plot points = new Plot(column);
                DataTable dataTable = this.dataTable;
                synchronized (dataTable) {
                    DataTableRow row;
                    Iterator<DataTableRow> i = this.dataTable.iterator();
                    if (this.axis[1] != -1 && this.getNumberOfCurrentlySelectedPlots() == 1) {
                        this.colorColumn = column;
                        while (i.hasNext()) {
                            row = i.next();
                            double color = row.getValue(this.colorColumn);
                            this.minColor = Math.min(this.minColor, color);
                            this.maxColor = Math.max(this.maxColor, color);
                        }
                        i = this.dataTable.iterator();
                    }
                    while (i.hasNext()) {
                        row = i.next();
                        try {
                            ColorPlotterPoint currentPoint;
                            double x = row.getValue(this.currentPlotterXAxis);
                            double y = Double.NaN;
                            double color = Double.NaN;
                            Color borderColor = Color.BLACK;
                            if (this.axis[1] != -1) {
                                this.currentPlotterYAxis = this.axis[1];
                                y = row.getValue(this.currentPlotterYAxis);
                                if (this.getNumberOfCurrentlySelectedPlots() == 1) {
                                    color = this.getPointColorValue(this.dataTable, row, this.colorColumn, this.minColor, this.maxColor);
                                    borderColor = this.getPointBorderColor(this.dataTable, row, this.colorColumn);
                                }
                            } else {
                                this.currentPlotterYAxis = column;
                                y = row.getValue(column);
                            }
                            if (!(currentPoint = new ColorPlotterPoint(this, row.getId(), x, y, color, borderColor)).isIn(this.drawMinX, this.drawMaxX, this.drawMinY, this.drawMaxY)) continue;
                            points.add(currentPoint);
                            this.minX = Math.min(x, this.minX);
                            this.maxX = Math.max(x, this.maxX);
                            this.minY = Math.min(y, this.minY);
                            this.maxY = Math.max(y, this.maxY);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Not a numerical data column: " + column);
                        }
                    }
                    if (this.jitterAmount > 0) {
                        Random jitterRandom = new Random(2001L);
                        double oldXRange = this.maxX - this.minX;
                        double oldYRange = this.maxY - this.minY;
                        for (ColorPlotterPoint point : points) {
                            if (Double.isInfinite(oldXRange) || Double.isNaN(oldXRange)) {
                                oldXRange = 0.0;
                            }
                            if (Double.isInfinite(oldYRange) || Double.isNaN(oldYRange)) {
                                oldYRange = 0.0;
                            }
                            double pertX = oldXRange * ((double)this.jitterAmount / 200.0) * jitterRandom.nextGaussian();
                            double pertY = oldYRange * ((double)this.jitterAmount / 200.0) * jitterRandom.nextGaussian();
                            double x = point.getX() + pertX;
                            double y = point.getY() + pertY;
                            this.minX = Math.min(x, this.minX);
                            this.maxX = Math.max(x, this.maxX);
                            this.minY = Math.min(y, this.minY);
                            this.maxY = Math.max(y, this.maxY);
                            point.setX(x);
                            point.setY(y);
                        }
                    }
                    this.plots.add(points);
                }
            }
            ++column;
        }
        if (!Double.isInfinite(this.drawMinX)) {
            this.minX = this.drawMinX;
        }
        if (!Double.isInfinite(this.drawMaxX)) {
            this.maxX = this.drawMaxX;
        }
        if (!Double.isInfinite(this.drawMinY)) {
            this.minY = this.drawMinY;
        }
        if (!Double.isInfinite(this.drawMaxY)) {
            this.maxY = this.drawMaxY;
        }
        if (this.dataTable.getNumberOfRows() == 0) {
            this.minY = 0.0;
            this.minX = 0.0;
            this.maxY = 1.0;
            this.maxX = 1.0;
        }
        if (this.minX == this.maxX) {
            this.minX -= 0.5;
            this.maxX += 0.5;
        }
        if (this.minY == this.maxY) {
            this.minY -= 0.5;
            this.maxY += 0.5;
        }
        this.xTicSize = this.getTicSize(this.dataTable, this.currentPlotterXAxis, this.minX, this.maxX);
        this.yTicSize = this.getTicSize(this.dataTable, this.currentPlotterYAxis, this.minY, this.maxY);
        this.minX = this.xTransformation.adaptTicsMin(this.minX, this.xTicSize);
        this.maxX = this.xTransformation.adaptTicsMax(this.maxX, this.xTicSize);
        this.minY = this.yTransformation.adaptTicsMin(this.minY, this.yTicSize);
        this.maxY = this.yTransformation.adaptTicsMax(this.maxY, this.yTicSize);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setDrawAxes(boolean drawAxes) {
        this.drawAxes = drawAxes;
        this.repaint();
    }

    public void setDrawLabel(boolean drawLabel) {
        this.drawLabel = drawLabel;
        this.repaint();
    }

    public void setMousePosInDataSpace(int x, int y) {
        ColorPlotterPoint point = this.getPlotterPointForPos(x, y);
        if (point != null) {
            String id = point.getId();
            if (id != null) {
                this.setToolTip(id, this.xTransformation.transform(point.getX()), this.yTransformation.transform(point.getY()));
            } else {
                this.setToolTip(null, 0.0, 0.0);
            }
        } else {
            this.setToolTip(null, 0.0, 0.0);
        }
    }

    public String getIdForPos(int x, int y) {
        ColorPlotterPoint point = this.getPlotterPointForPos(x, y);
        if (point != null) {
            return point.getId();
        }
        return null;
    }

    private ColorPlotterPoint getPlotterPointForPos(int x, int y) {
        for (Collection collection : this.plots) {
            for (ColorPlotterPoint current : collection) {
                try {
                    if (!current.contains(x, y)) continue;
                    return current;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public void setDragBounds(int dragX, int dragY, int dragWidth, int dragHeight) {
        this.dragX = dragX;
        this.dragY = dragY;
        this.dragWidth = dragWidth;
        this.dragHeight = dragHeight;
        this.repaint();
    }

    private void setToolTip(String toolTip, double x, double y) {
        this.currentToolTip = toolTip;
        this.toolTipX = x;
        this.toolTipY = y;
        this.repaint();
    }

    protected void drawPoints(Graphics2D g, double dx, double dy, double sx, double sy) {
        if (this.plots.size() == 0) {
            return;
        }
        int c = 0;
        for (Plot plot : this.plots) {
            float gSpaceY;
            if (plot.size() <= 0) continue;
            Iterator i = plot.iterator();
            if (this.pointType != 1 && this.axis[1] < 0 && this.draw2DLines) {
                GeneralPath path = new GeneralPath();
                boolean first = true;
                while (i.hasNext()) {
                    ColorPlotterPoint plotterPoint = (ColorPlotterPoint)i.next();
                    float gSpaceX = (float)((this.xTransformation.transform(plotterPoint.getX()) + dx) * sx);
                    gSpaceY = (float)((this.yTransformation.transform(plotterPoint.getY()) + dy) * sy);
                    if (first) {
                        path.moveTo(gSpaceX, gSpaceY);
                    } else {
                        path.lineTo(gSpaceX, gSpaceY);
                    }
                    first = false;
                }
                plot.getLineStyle().set(g);
                g.draw(path);
            }
            for (ColorPlotterPoint plotterPoint : plot) {
                Color pointColor = plot.getLineStyle().getColor();
                if (this.axis[1] >= 0) {
                    pointColor = ScatterPlotter.getPointColor(plotterPoint.getColor());
                }
                Color pointBorderColor = plotterPoint.getBorderColor();
                try {
                    float gSpaceX = (float)((this.xTransformation.transform(plotterPoint.getX()) + dx) * sx);
                    gSpaceY = (float)((this.yTransformation.transform(plotterPoint.getY()) + dy) * sy);
                    this.drawPoint(g, gSpaceX, gSpaceY, pointColor, pointBorderColor);
                }
                catch (IllegalArgumentException e) {
                    LogService.logMessage("Cannot apply axis scale transformation to point (" + plotterPoint.getX() + "," + plotterPoint.getY() + "), skipping...", 4);
                }
            }
            c = (c + 1) % LINE_STYLES.length;
        }
    }

    private void drawToolTip(Graphics2D g, double dx, double dy, double sx, double sy) {
        if (this.currentToolTip != null) {
            g.setFont(SCALED_LABEL_FONT);
            Rectangle2D stringBounds = SCALED_LABEL_FONT.getStringBounds(this.currentToolTip, g.getFontRenderContext());
            g.setColor(TOOLTIP_COLOR);
            Rectangle2D.Double bg = new Rectangle2D.Double((this.toolTipX + dx) * sx - stringBounds.getWidth() / 2.0 - 4.0, (this.toolTipY + dy) * sy + 3.0, stringBounds.getWidth() + 5.0, Math.abs(stringBounds.getHeight()) + 3.0);
            g.fill(bg);
            g.setColor(Color.black);
            g.draw(bg);
            g.drawString(this.currentToolTip, (float)((this.toolTipX + dx) * sx - stringBounds.getWidth() / 2.0) - 2.0f, (float)((this.toolTipY + dy) * sy) + 6.0f);
        }
    }

    protected void drawGrid(Graphics2D g, double dx, double dy, double sx, double sy) {
        g.setFont(SCALED_LABEL_FONT);
        int numberOfXTics = (int)Math.ceil((this.maxX - this.minX) / this.xTicSize) + 1;
        int i = 0;
        while (i < numberOfXTics) {
            this.drawVerticalTic(g, i, dx, dy, sx, sy);
            ++i;
        }
        int numberOfYTics = (int)Math.ceil((this.maxY - this.minY) / this.yTicSize) + 1;
        int i2 = 0;
        while (i2 < numberOfYTics) {
            this.drawHorizontalTic(g, i2, dx, dy, sx, sy);
            ++i2;
        }
    }

    private void drawVerticalTic(Graphics2D g, int ticNumber, double dx, double dy, double sx, double sy) {
        double xValue = (double)ticNumber * this.xTicSize + this.minX;
        double x = this.xTransformation.transform(xValue);
        g.setColor(GRID_COLOR);
        g.draw(new Line2D.Double((x + dx) * sx, (this.yTransformation.transform(this.minY) + dy) * sy, (x + dx) * sx, (this.yTransformation.transform(this.maxY) + dy) * sy));
        g.setColor(Color.black);
        if (this.drawAxes) {
            String label = null;
            if (this.getNumberOfPlots(this.dataTable) == 1 && this.dataTable.isNominal(this.currentPlotterXAxis)) {
                int index = (int)Math.round(xValue);
                if (index >= 0 && index < this.dataTable.getNumberOfValues(this.currentPlotterXAxis)) {
                    label = this.dataTable.mapIndex(this.currentPlotterXAxis, index);
                }
            } else {
                label = this.xTransformation.format(xValue, ticNumber);
            }
            if (label != null) {
                Rectangle2D stringBounds = SCALED_LABEL_FONT.getStringBounds(label, g.getFontRenderContext());
                g.drawString(label, (float)((x + dx) * sx - stringBounds.getWidth() / 2.0), (float)((this.yTransformation.transform(this.minY) + dy) * sy + stringBounds.getHeight()));
            }
        }
    }

    private void drawHorizontalTic(Graphics2D g, int ticNumber, double dx, double dy, double sx, double sy) {
        double yValue = (double)ticNumber * this.yTicSize + this.minY;
        double y = this.yTransformation.transform(yValue);
        g.setColor(GRID_COLOR);
        g.draw(new Line2D.Double((this.xTransformation.transform(this.minX) + dx) * sx, (y + dy) * sy, (this.xTransformation.transform(this.maxX) + dx) * sx, (y + dy) * sy));
        g.setColor(Color.black);
        if (this.drawAxes) {
            String label = null;
            if (this.getNumberOfPlots(this.dataTable) == 1 && this.dataTable.isNominal(this.currentPlotterYAxis)) {
                int index = (int)Math.round(yValue);
                if (index >= 0 && index < this.dataTable.getNumberOfValues(this.currentPlotterYAxis)) {
                    label = this.dataTable.mapIndex(this.currentPlotterYAxis, index);
                }
            } else {
                String formattedValue = this.yTransformation.format(yValue, ticNumber);
                if (formattedValue != null) {
                    label = String.valueOf(formattedValue) + " ";
                }
            }
            if (label != null) {
                Rectangle2D stringBounds = SCALED_LABEL_FONT.getStringBounds(label, g.getFontRenderContext());
                g.drawString(label, (float)((this.xTransformation.transform(this.minX) + dx) * sx - stringBounds.getWidth()), (float)((y + dy) * sy - stringBounds.getHeight() / 2.0 - stringBounds.getY()));
            }
        }
    }

    private void draw(Graphics2D g, int pixWidth, int pixHeight) {
        double sx = 0.0;
        double sy = 0.0;
        try {
            if (this.drawAxes) {
                sx = ((double)pixWidth - 50.0) / (this.xTransformation.transform(this.maxX) - this.xTransformation.transform(this.minX));
                sy = ((double)pixHeight - 15.0) / (this.yTransformation.transform(this.maxY) - this.yTransformation.transform(this.minY));
            } else {
                sx = (double)pixWidth / (this.xTransformation.transform(this.maxX) - this.xTransformation.transform(this.minX));
                sy = (double)pixHeight / (this.yTransformation.transform(this.maxY) - this.yTransformation.transform(this.minY));
            }
        }
        catch (IllegalArgumentException e) {
            g.scale(1.0, -1.0);
            g.drawString("Cannot apply axis transformation. Please make sure that the value range", 0, -60);
            g.drawString("can be transformed by the selected axis transformation, for example", 0, -40);
            g.drawString("negative values or zero cannot be transformed by a log scale transformation", 0, -20);
            g.drawString("(applying a normalization operator to the desired range might help). ", 0, 0);
            return;
        }
        Graphics2D coordinateSpace = (Graphics2D)g.create();
        if (this.drawAxes) {
            coordinateSpace.translate(50, 15);
        }
        if (Double.isNaN(sx) || Double.isNaN(sy)) {
            coordinateSpace.scale(1.0, -1.0);
            coordinateSpace.drawString("No data points available (yet).", 0, -20);
            coordinateSpace.drawString("Zooming out with a right click might help.", 0, 0);
        } else {
            if (this.drawAxes) {
                this.transform.translate(50.0, 15.0);
            }
            this.transform.scale(sx, sy);
            this.transform.translate(-this.xTransformation.transform(this.minX), -this.yTransformation.transform(this.minY));
            this.drawGrid(coordinateSpace, -this.xTransformation.transform(this.minX), -this.yTransformation.transform(this.minY), sx, sy);
            this.drawPoints(coordinateSpace, -this.xTransformation.transform(this.minX), -this.yTransformation.transform(this.minY), sx, sy);
            this.drawToolTip(coordinateSpace, -this.xTransformation.transform(this.minX), -this.yTransformation.transform(this.minY), sx, sy);
        }
        coordinateSpace.dispose();
    }

    private void drawDragRectangle(Graphics2D g) {
        if (this.dragX != -1 && this.dragY != -1 && this.dragWidth != -1 && this.dragHeight != -1) {
            g.setColor(Color.gray);
            Rectangle2D.Double dragBounds = new Rectangle2D.Double(this.dragX, this.dragY, this.dragWidth, this.dragHeight);
            g.draw(dragBounds);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paint2DPlots((Graphics2D)graphics);
    }

    public void paint2DPlots(Graphics2D g) {
        Rectangle2D stringBounds;
        int pixWidth = this.getWidth() - 40;
        int pixHeight = this.getHeight() - 40;
        Graphics2D scaled = (Graphics2D)g.create();
        scaled.translate(20, 20);
        scaled.translate(0, pixHeight + 1);
        this.prepareData();
        if (this.plots.size() == 0) {
            scaled.drawString("No plots selected.", 0, 0);
        } else {
            scaled.scale(1.0, -1.0);
            g.setColor(Color.black);
            this.transform = new AffineTransform();
            this.transform.translate(20.0, 20.0);
            this.transform.translate(0.0, pixHeight + 1);
            this.transform.scale(1.0, -1.0);
            this.draw(scaled, pixWidth, pixHeight);
        }
        scaled.dispose();
        if (this.drawLabel && this.axis[0] >= 0) {
            String xAxisLabel = this.dataTable.getColumnName(this.axis[0]);
            stringBounds = SCALED_LABEL_FONT.getStringBounds(xAxisLabel, g.getFontRenderContext());
            g.drawString(xAxisLabel, 20 + (int)((double)pixWidth / 2.0 - stringBounds.getWidth() / 2.0), 20 + (int)((double)pixHeight + stringBounds.getY()) + 3);
        }
        int xOffset = 0;
        if (this.drawLabel) {
            String yAxisLabel = "";
            if (this.axis[1] >= 0) {
                yAxisLabel = this.dataTable.getColumnName(this.axis[1]);
            } else {
                boolean first = true;
                int column = 0;
                while (column < this.columns.length) {
                    if (this.columns[column]) {
                        if (!first) {
                            yAxisLabel = String.valueOf(yAxisLabel) + ", ";
                        }
                        yAxisLabel = String.valueOf(yAxisLabel) + this.dataTable.getColumnName(column);
                        first = false;
                    }
                    ++column;
                }
            }
            if (yAxisLabel.length() == 0) {
                yAxisLabel = "unknown";
            }
            Rectangle2D stringBounds2 = LABEL_FONT.getStringBounds(yAxisLabel, g.getFontRenderContext());
            xOffset = (int)((double)xOffset + (stringBounds2.getWidth() + 20.0));
            g.drawString(yAxisLabel, 14, 14);
        }
        if (this.drawLegend && this.axis[1] != -1 && this.plots.size() == 1) {
            this.drawLegend(g, this.dataTable, this.colorColumn, xOffset, 255);
        }
        if (this.key != null) {
            stringBounds = SCALED_LABEL_FONT.getStringBounds(this.key, g.getFontRenderContext());
            int keyX = 20 + (int)((double)pixWidth / 2.0 - stringBounds.getWidth() / 2.0);
            int keyY = (int)(10.0 - stringBounds.getHeight() / 2.0) + 25;
            Rectangle2D.Double bg = new Rectangle2D.Double(keyX - 2, (double)(keyY - 2) - Math.abs(stringBounds.getHeight()), stringBounds.getWidth() + 11.0, Math.abs(stringBounds.getHeight()) + 9.0);
            g.setColor(TOOLTIP_COLOR);
            g.fill(bg);
            g.setColor(Color.black);
            g.draw(bg);
            g.drawString(this.key, keyX, keyY);
        }
        this.drawDragRectangle(g);
    }

    public void setDraw2DLines(boolean v) {
        this.draw2DLines = v;
    }

    public boolean getDraw2DLines() {
        return this.draw2DLines;
    }

    public boolean isProvidingCoordinates() {
        return true;
    }

    public boolean isSupportingLogScale(int axis) {
        if (axis == 0 || axis == 1) {
            return true;
        }
        return super.isSupportingLogScale(axis);
    }

    public void setLogScale(int axis, boolean logScale) {
        if (axis == 0) {
            this.xTransformation = logScale ? new AxisTransformationLog() : new AxisTransformationId();
        } else if (axis == 1) {
            this.yTransformation = logScale ? new AxisTransformationLog() : new AxisTransformationId();
        }
        this.repaint();
    }
}

