/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.gui.plotter.PlotterAdapter;
import edu.udo.cs.yale.gui.plotter.ScatterPlotter;
import edu.udo.cs.yale.gui.plotter.conditions.ColumnsPlotterCondition;
import edu.udo.cs.yale.gui.plotter.conditions.PlotterCondition;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.tools.LogService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ScatterMatrixPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = 9049081889010883621L;
    static final int MAX_NUMBER_OF_COLUMNS = 11;
    private ScatterPlotter[][] plotters = new ScatterPlotter[0][0];
    private int plotDimension = -1;
    private transient DataTable dataTable;
    private int plotterSize;

    public ScatterMatrixPlotter() {
        this.setBackground(Color.white);
        String sizeProperty = System.getProperty("yale.gui.plotter.matrixplot.size");
        this.plotterSize = 200;
        try {
            if (sizeProperty != null) {
                this.plotterSize = Integer.parseInt(sizeProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.logMessage("Scatter matrix: cannot parse plotter size (was '" + sizeProperty + "'), using default size (200).", 4);
        }
    }

    public ScatterMatrixPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.plotters = new ScatterPlotter[dataTable.getNumberOfColumns() - 1][dataTable.getNumberOfColumns() - 1];
        int x = 0;
        while (x < this.plotters.length) {
            int y = 0;
            while (y < this.plotters[x].length) {
                this.plotters[x][y] = new ScatterPlotter(dataTable);
                this.plotters[x][y].setDrawLegend(false);
                this.plotters[x][y].setDrawAxes(false);
                this.plotters[x][y].getPlotter().setSize(new Dimension(this.plotterSize, this.plotterSize));
                ++y;
            }
            ++x;
        }
    }

    public PlotterCondition getPlotterCondition() {
        return new ColumnsPlotterCondition(11);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int x = 0;
        while (x < this.plotters.length) {
            int y = 0;
            while (y < this.plotters[x].length) {
                Graphics2D newSpace = (Graphics2D)graphics.create();
                newSpace.translate(x * this.plotterSize, y * this.plotterSize + 20);
                this.plotters[x][y].paint2DPlots(newSpace);
                ++y;
            }
            ++x;
        }
        if (this.plotDimension != -1) {
            this.drawLegend(graphics, this.dataTable, this.plotDimension);
        }
    }

    private void updatePlotters() {
        if (this.plotDimension >= 0) {
            int firstIndex = 0;
            int x = 0;
            while (x < this.dataTable.getNumberOfColumns()) {
                if (x != this.plotDimension) {
                    int secondIndex = 0;
                    int y = 0;
                    while (y < this.dataTable.getNumberOfColumns()) {
                        if (y != this.plotDimension) {
                            if (firstIndex == secondIndex) {
                                this.plotters[firstIndex][secondIndex].setAxis(0, -1);
                                this.plotters[firstIndex][secondIndex].setAxis(1, -1);
                                this.plotters[firstIndex][secondIndex].clearPlotColumns();
                            } else {
                                this.plotters[firstIndex][secondIndex].setAxis(0, x);
                                this.plotters[firstIndex][secondIndex].setAxis(1, y);
                                this.plotters[firstIndex][secondIndex].clearPlotColumns();
                                this.plotters[firstIndex][secondIndex].setPlotColumn(this.plotDimension, true);
                            }
                            ++secondIndex;
                        }
                        ++y;
                    }
                    ++firstIndex;
                }
                ++x;
            }
        } else {
            int x = 0;
            while (x < this.plotters.length) {
                int y = 0;
                while (y < this.plotters[x].length) {
                    this.plotters[x][y].setAxis(0, -1);
                    this.plotters[x][y].setAxis(1, -1);
                    this.plotters[x][y].clearPlotColumns();
                    ++y;
                }
                ++x;
            }
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.plotters.length * this.plotterSize + 40, this.plotters.length * this.plotterSize + 40);
    }

    public String getAxisName(int index) {
        return "none";
    }

    public Icon getIcon(int index) {
        return null;
    }

    public boolean isSaveable() {
        return true;
    }

    public void save() {
        JFileChooser chooser = SwingTools.createFileChooser(null, false, new FileFilter[0]);
        if (chooser.showSaveDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            try {
                PrintWriter out = new PrintWriter(new FileWriter(file));
                this.dataTable.write(out);
                out.close();
            }
            catch (Exception ex) {
                SwingTools.showErrorMessage("Cannot write to file '" + file + "'", ex);
            }
        }
    }

    public boolean canHandleJitter() {
        return true;
    }

    public void setJitter(int jitter) {
        int x = 0;
        while (x < this.plotters.length) {
            int y = 0;
            while (y < this.plotters[x].length) {
                this.plotters[x][y].setJitter(jitter);
                ++y;
            }
            ++x;
        }
        this.updatePlotters();
    }

    public void setPlotColumn(int index, boolean plot) {
        if (plot) {
            this.plotDimension = index;
        }
        this.updatePlotters();
    }

    public boolean getPlotColumn(int index) {
        return this.plotDimension == index;
    }
}

