/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.gui.plotter.PlotterAdapter;
import edu.udo.cs.yale.gui.plotter.PlotterPoint;
import edu.udo.cs.yale.gui.plotter.WeightIndex;
import edu.udo.cs.yale.gui.plotter.conditions.ColumnsPlotterCondition;
import edu.udo.cs.yale.gui.plotter.conditions.PlotterCondition;
import edu.udo.cs.yale.tools.LogService;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RadVizPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = 199188198448229742L;
    private static final int MAX_NUMBER_OF_COLUMNS = 1000;
    private static final int ZOOM_FACTOR = 50;
    private static final String[] COLUMN_MAPPING_TYPES = new String[]{"ordered", "weights", "random"};
    private static final int ORDERED = 0;
    private static final int WEIGHTS = 1;
    private static final int RANDOM = 2;
    protected List<PlotterPoint> plotterPoints = new LinkedList<PlotterPoint>();
    protected transient DataTable dataTable;
    protected int[] columnMapping;
    protected double maxWeight = Double.NaN;
    protected double[] anchorVectorX;
    protected double[] anchorVectorY;
    private double[] angles;
    protected int colorColumn = -1;
    private double minColor;
    private double maxColor;
    private JComboBox columnMappingSelection;
    protected JList ignoreList;
    private int columnMappingType = 0;
    protected double scale = 1.0;
    private long orderRandomSeed = 2001L;

    public RadVizPlotter() {
        this.setBackground(Color.white);
        this.columnMappingSelection = new JComboBox<String>(COLUMN_MAPPING_TYPES);
        this.columnMappingSelection.setToolTipText("Indicates the type of column mapping (reordering).");
        this.columnMappingSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RadVizPlotter.this.setColumnMapping(RadVizPlotter.this.columnMappingSelection.getSelectedIndex());
            }
        });
        this.ignoreList = new JList(new DefaultListModel());
        this.ignoreList.setToolTipText("The selected columns will not be used as dimension anchors.");
        this.ignoreList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RadVizPlotter.this.repaint();
            }
        });
    }

    public RadVizPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    public PlotterCondition getPlotterCondition() {
        return new ColumnsPlotterCondition(1000);
    }

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        DefaultListModel ignoreModel = (DefaultListModel)this.ignoreList.getModel();
        ignoreModel.clear();
        int i = 0;
        while (i < this.dataTable.getNumberOfColumns()) {
            if (i != this.colorColumn) {
                ignoreModel.addElement(this.dataTable.getColumnName(i));
            }
            ++i;
        }
        this.maxWeight = this.getMaxWeight(dataTable);
        this.repaint();
    }

    public void setPlotColumn(int index, boolean plot) {
        this.colorColumn = plot ? index : -1;
        DefaultListModel ignoreModel = (DefaultListModel)this.ignoreList.getModel();
        ignoreModel.clear();
        int i = 0;
        while (i < this.dataTable.getNumberOfColumns()) {
            if (i != this.colorColumn) {
                ignoreModel.addElement(this.dataTable.getColumnName(i));
            }
            ++i;
        }
        this.repaint();
    }

    public boolean getPlotColumn(int index) {
        return this.colorColumn == index;
    }

    public String getPlotName() {
        return "Color";
    }

    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            JLabel label = new JLabel("Column mapping:");
            label.setToolTipText("Indicates the type of column mapping (reordering).");
            return label;
        }
        if (index == 1) {
            return this.columnMappingSelection;
        }
        if (index == 2) {
            JLabel label = new JLabel("Ignore columns:");
            label.setToolTipText("The selected columns will not be used as dimension anchors.");
            return label;
        }
        if (index == 3) {
            return new JScrollPane(this.ignoreList);
        }
        return null;
    }

    public boolean canHandleZooming() {
        return true;
    }

    public void setZooming(int zooming) {
        this.scale = (double)zooming / 50.0;
        this.repaint();
    }

    public int getInitialZoomFactor() {
        return 50;
    }

    private void setColumnMapping(int mapping) {
        this.columnMappingType = mapping;
        if (mapping == 2) {
            this.orderRandomSeed = new Random().nextLong();
        }
        this.repaint();
    }

    protected boolean shouldIgnoreColumn(int column) {
        return this.shouldIgnoreColumn(this.dataTable.getColumnName(this.columnMapping[column]));
    }

    protected boolean shouldIgnoreColumn(String column) {
        Object[] ignoredColumns = this.ignoreList.getSelectedValues();
        int i = 0;
        while (i < ignoredColumns.length) {
            if (ignoredColumns[i].equals(column)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void calculateColumnMapping() {
        this.columnMapping = new int[this.dataTable.getNumberOfColumns()];
        int i = 0;
        while (i < this.columnMapping.length) {
            this.columnMapping[i] = i;
            ++i;
        }
        switch (this.columnMappingType) {
            case 0: {
                break;
            }
            case 1: {
                if (this.dataTable.isSupportingColumnWeights()) {
                    this.columnMapping = new int[this.dataTable.getNumberOfColumns()];
                    LinkedList<WeightIndex> indices = new LinkedList<WeightIndex>();
                    int i2 = 0;
                    while (i2 < this.dataTable.getNumberOfColumns()) {
                        if (this.colorColumn != i2 && !this.shouldIgnoreColumn(i2)) {
                            indices.add(new WeightIndex(i2, Math.abs(this.dataTable.getColumnWeight(i2))));
                        } else {
                            indices.add(new WeightIndex(i2, 0.0));
                        }
                        ++i2;
                    }
                    Collections.sort(indices);
                    Iterator w = indices.iterator();
                    int counter = 0;
                    while (w.hasNext()) {
                        this.columnMapping[counter++] = ((WeightIndex)w.next()).getIndex();
                    }
                    break;
                }
                LogService.logMessage("Cannot use weight based ordering since no column weights are given.", 4);
                break;
            }
            case 2: {
                this.columnMapping = new int[this.dataTable.getNumberOfColumns()];
                ArrayList<Integer> indices = new ArrayList<Integer>();
                int i3 = 0;
                while (i3 < this.columnMapping.length) {
                    this.columnMapping[i3] = i3;
                    if (this.colorColumn != i3 && !this.shouldIgnoreColumn(i3)) {
                        indices.add(i3);
                    }
                    ++i3;
                }
                Random random = new Random(this.orderRandomSeed);
                int i4 = 0;
                while (i4 < this.columnMapping.length) {
                    if (this.colorColumn != i4 && !this.shouldIgnoreColumn(i4)) {
                        int other = (Integer)indices.get(random.nextInt(indices.size()));
                        int dummy = this.columnMapping[i4];
                        this.columnMapping[i4] = this.columnMapping[other];
                        this.columnMapping[other] = dummy;
                    }
                    ++i4;
                }
                break;
            }
        }
    }

    protected void calculateSamplePoints() {
        this.plotterPoints.clear();
        this.minColor = Double.POSITIVE_INFINITY;
        this.maxColor = Double.NEGATIVE_INFINITY;
        if (this.colorColumn >= 0) {
            for (DataTableRow row : this.dataTable) {
                double color = row.getValue(this.colorColumn);
                this.minColor = Math.min(this.minColor, color);
                this.maxColor = Math.max(this.maxColor, color);
            }
        }
        for (DataTableRow row : this.dataTable) {
            double xPos = 0.0;
            double yPos = 0.0;
            double sum = 0.0;
            int d = 0;
            while (d < this.dataTable.getNumberOfColumns()) {
                if (d != this.colorColumn && !this.shouldIgnoreColumn(d)) {
                    sum += row.getValue(this.columnMapping[d]);
                }
                ++d;
            }
            double[] w = new double[this.dataTable.getNumberOfColumns()];
            int d2 = 0;
            while (d2 < this.dataTable.getNumberOfColumns()) {
                if (d2 != this.colorColumn && !this.shouldIgnoreColumn(d2)) {
                    w[d2] = row.getValue(this.columnMapping[d2]) / sum;
                }
                ++d2;
            }
            d2 = 0;
            while (d2 < this.dataTable.getNumberOfColumns()) {
                if (d2 != this.colorColumn && !this.shouldIgnoreColumn(d2)) {
                    xPos += w[d2] * this.anchorVectorX[d2];
                    yPos += w[d2] * this.anchorVectorY[d2];
                }
                ++d2;
            }
            double color = 1.0;
            Color borderColor = Color.BLACK;
            if (this.colorColumn >= 0) {
                color = this.getPointColorValue(this.dataTable, row, this.colorColumn, this.minColor, this.maxColor);
                borderColor = this.getPointBorderColor(this.dataTable, row, this.colorColumn);
            }
            this.plotterPoints.add(new PlotterPoint(xPos, yPos, color, borderColor));
        }
    }

    protected void calculateAttributeVectors() {
        this.anchorVectorX = new double[this.dataTable.getNumberOfColumns()];
        this.anchorVectorY = new double[this.dataTable.getNumberOfColumns()];
        int i = 0;
        while (i < this.dataTable.getNumberOfColumns()) {
            if (i != this.colorColumn && !this.shouldIgnoreColumn(i)) {
                double angle = this.angles[i];
                double x = 0.0;
                double y = 0.0;
                if ((int)angle / 90 == 0) {
                    x = this.sin(angle);
                    y = this.sin(90.0 - angle);
                } else if ((int)angle / 90 == 1) {
                    x = this.sin(90.0 - (angle -= 90.0));
                    y = this.sin(angle);
                    y = -y;
                } else if ((int)angle / 90 == 2) {
                    x = this.sin(angle -= 180.0);
                    y = this.sin(90.0 - angle);
                    x = -x;
                    y = -y;
                } else if ((int)angle / 90 == 3) {
                    x = this.sin(90.0 - (angle -= 270.0));
                    y = this.sin(angle);
                    x = -x;
                }
                this.anchorVectorX[i] = x;
                this.anchorVectorY[i] = y;
            }
            ++i;
        }
    }

    private void calculateAngles() {
        int numberOfColumns = this.dataTable.getNumberOfColumns();
        if (this.colorColumn >= 0) {
            --numberOfColumns;
        }
        int[] ignoredColumns = this.ignoreList.getSelectedIndices();
        double totalAngle = 360.0;
        double delta = totalAngle / (double)(numberOfColumns -= ignoredColumns.length);
        double angle = 0.0;
        this.angles = new double[this.dataTable.getNumberOfColumns()];
        int i = 0;
        while (i < this.angles.length) {
            if (i != this.colorColumn && !this.shouldIgnoreColumn(i)) {
                this.angles[i] = angle;
                angle += delta;
            }
            ++i;
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.calculateColumnMapping();
        this.paintPlotter(g);
    }

    protected void paintPlotter(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics.create();
        this.calculateAngles();
        this.calculateAttributeVectors();
        this.calculateSamplePoints();
        int width = this.getWidth();
        int height = this.getHeight();
        int midX = width / 2;
        int midY = height / 2;
        double radius = (double)(Math.min(width, height) - 80) / 2.0;
        g.setColor(GRID_COLOR);
        g.drawOval((int)((double)midX - radius), (int)((double)midY - radius), (int)(2.0 * radius), (int)(2.0 * radius));
        int i = 0;
        while (i < this.dataTable.getNumberOfColumns()) {
            if (i != this.colorColumn && !this.shouldIgnoreColumn(i)) {
                int endX = (int)((double)midX + this.anchorVectorX[i] * radius);
                int endY = (int)((double)midY - this.anchorVectorY[i] * radius);
                g.drawLine(midX, midY, endX, endY);
            }
            ++i;
        }
        g.setFont(LABEL_FONT);
        i = 0;
        while (i < this.dataTable.getNumberOfColumns()) {
            if (i != this.colorColumn && !this.shouldIgnoreColumn(i)) {
                double x = (double)midX + this.anchorVectorX[i] * radius;
                double y = (double)midY - this.anchorVectorY[i] * radius;
                Rectangle2D stringBounds = LABEL_FONT.getStringBounds(this.dataTable.getColumnName(this.columnMapping[i]), g.getFontRenderContext());
                if (this.angles[i] >= 0.0 && this.angles[i] <= 90.0) {
                    x += this.anchorVectorX[i] * 5.0;
                    y -= this.anchorVectorY[i] * 5.0;
                } else if (this.angles[i] >= 90.0 && this.angles[i] < 180.0) {
                    x += this.anchorVectorX[i] * 10.0;
                    y -= this.anchorVectorY[i] * 10.0;
                } else if (this.angles[i] >= 180.0 && this.angles[i] < 270.0) {
                    x += this.anchorVectorX[i] * 15.0 - stringBounds.getWidth();
                    y -= this.anchorVectorY[i] * 15.0;
                } else if (this.angles[i] >= 270.0 && this.angles[i] < 360.0) {
                    x += this.anchorVectorX[i] * 10.0 - stringBounds.getWidth();
                    y -= this.anchorVectorY[i] * 10.0;
                }
                if (this.dataTable.isSupportingColumnWeights()) {
                    Rectangle2D.Double weightRect = new Rectangle2D.Double(x - 2.0, y - stringBounds.getHeight(), stringBounds.getWidth() + 2.0, stringBounds.getHeight() + 3.0);
                    g.setColor(this.getWeightColor(this.dataTable.getColumnWeight(this.columnMapping[i]), this.maxWeight));
                    g.fill(weightRect);
                }
                g.setColor(GRID_COLOR);
                g.drawString(this.dataTable.getColumnName(this.columnMapping[i]), (int)x, (int)y);
            }
            ++i;
        }
        Iterator<PlotterPoint> i2 = this.plotterPoints.iterator();
        while (i2.hasNext()) {
            this.drawPoint(g, i2.next(), midX, midY, radius);
        }
        if (this.colorColumn != -1 && this.plotterPoints.size() > 0) {
            this.drawLegend(g, this.dataTable, this.colorColumn);
        }
    }

    protected void drawPoint(Graphics2D g, PlotterPoint point, int midX, int midY, double radius) {
        int x = midX;
        int y = midY;
        x += (int)(point.getX() * radius * this.scale);
        y -= (int)(point.getY() * radius * this.scale);
        Color pointColor = Color.red;
        if (this.colorColumn != -1) {
            pointColor = RadVizPlotter.getPointColor(point.getColor());
        }
        this.drawPoint(g, x, (double)y, pointColor, point.getBorderColor());
    }

    private double sin(double angle) {
        while (angle >= 180.0) {
            angle -= 180.0;
        }
        double value = angle / 180.0 * Math.PI;
        return Math.sin(value);
    }
}

