/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.gui.plotter.ColorQuartilePlotter;
import edu.udo.cs.yale.gui.plotter.Quartile;
import edu.udo.cs.yale.gui.plotter.RectangleStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class QuartilePlotter
extends ColorQuartilePlotter {
    private static final long serialVersionUID = -5115095967846809152L;
    private static Icon[] RECTANGLE_STYLE_ICONS = new RectangleStyleIcon[10];
    private boolean[] columns = null;

    static {
        int i = 0;
        while (i < RECTANGLE_STYLE_ICONS.length) {
            QuartilePlotter.RECTANGLE_STYLE_ICONS[i] = new RectangleStyleIcon(i);
            ++i;
        }
    }

    public QuartilePlotter() {
    }

    public QuartilePlotter(DataTable dataTable) {
        super(dataTable);
    }

    public void setDataTable(DataTable dataTable) {
        this.columns = new boolean[dataTable.getNumberOfColumns()];
        super.setDataTable(dataTable);
    }

    public int getNumberOfAxes() {
        return 0;
    }

    public String getPlotName() {
        return "Dimensions";
    }

    public int getValuePlotSelectionType() {
        return 1;
    }

    public void setPlotColumn(int index, boolean plot) {
        this.columns[index] = plot;
        this.repaint();
    }

    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    public Icon getIcon(int index) {
        return RECTANGLE_STYLE_ICONS[index % RECTANGLE_STYLE_ICONS.length];
    }

    protected void prepareData() {
        this.allQuartiles.clear();
        this.globalMin = Double.POSITIVE_INFINITY;
        this.globalMax = Double.NEGATIVE_INFINITY;
        if (this.columns != null) {
            int i = 0;
            while (i < this.dataTable.getNumberOfColumns()) {
                if (this.columns[i]) {
                    Quartile quartile = Quartile.calculateQuartile(this.dataTable, i);
                    quartile.setColor(new RectangleStyle(i).getColor());
                    this.allQuartiles.add(quartile);
                    this.globalMin = Math.min(this.globalMin, quartile.getMin());
                    this.globalMax = Math.max(this.globalMax, quartile.getMax());
                }
                ++i;
            }
        }
    }

    private static class RectangleStyleIcon
    implements Icon {
        private RectangleStyle style;

        private RectangleStyleIcon(int index) {
            this.style = new RectangleStyle(index);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.style.set((Graphics2D)g);
            g.fillRect(x, y, 16, 16);
            g.setColor(Color.black);
            g.drawRect(x, y, 16, 16);
        }
    }
}

