/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.ObjectVisualizer;
import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.gui.plotter.AndrewsCurves;
import edu.udo.cs.yale.gui.plotter.BoundDiagram;
import edu.udo.cs.yale.gui.plotter.ColorHistogramMatrixPlotter;
import edu.udo.cs.yale.gui.plotter.ColorHistogramPlotter;
import edu.udo.cs.yale.gui.plotter.ColorQuartileMatrixPlotter;
import edu.udo.cs.yale.gui.plotter.ColorQuartilePlotter;
import edu.udo.cs.yale.gui.plotter.DensityPlotter;
import edu.udo.cs.yale.gui.plotter.GridVizPlotter;
import edu.udo.cs.yale.gui.plotter.HintonDiagram;
import edu.udo.cs.yale.gui.plotter.HistogramMatrixPlotter;
import edu.udo.cs.yale.gui.plotter.HistogramPlotter;
import edu.udo.cs.yale.gui.plotter.ParallelPlotter;
import edu.udo.cs.yale.gui.plotter.Plotter;
import edu.udo.cs.yale.gui.plotter.QuartilePlotter;
import edu.udo.cs.yale.gui.plotter.RadVizPlotter;
import edu.udo.cs.yale.gui.plotter.ScatterMatrixPlotter;
import edu.udo.cs.yale.gui.plotter.ScatterPlotter;
import edu.udo.cs.yale.gui.plotter.SurveyPlotter;
import edu.udo.cs.yale.gui.plotter.charts.BarChart2DPlotter;
import edu.udo.cs.yale.gui.plotter.charts.BarChart3DPlotter;
import edu.udo.cs.yale.gui.plotter.charts.BubbleChartPlotter;
import edu.udo.cs.yale.gui.plotter.charts.PieChart2DPlotter;
import edu.udo.cs.yale.gui.plotter.charts.PieChart3DPlotter;
import edu.udo.cs.yale.gui.plotter.charts.RingChartPlotter;
import edu.udo.cs.yale.gui.plotter.conditions.PlotterCondition;
import edu.udo.cs.yale.gui.plotter.mathplot.BoxPlot2D;
import edu.udo.cs.yale.gui.plotter.mathplot.BoxPlot3D;
import edu.udo.cs.yale.gui.plotter.mathplot.ScatterPlot3D;
import edu.udo.cs.yale.gui.plotter.mathplot.ScatterPlot3DColor;
import edu.udo.cs.yale.gui.plotter.mathplot.SticksPlot2D;
import edu.udo.cs.yale.gui.plotter.mathplot.SticksPlot3D;
import edu.udo.cs.yale.gui.plotter.mathplot.SurfacePlot3D;
import edu.udo.cs.yale.gui.plotter.som.SOMPlotter;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.visualization.SOMModelPlotter;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.ObjectVisualizerService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.freehep.util.export.ExportDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotterPanel
extends JPanel
implements MouseMotionListener,
MouseListener,
ItemListener,
Runnable {
    private static final long serialVersionUID = -8724351470349745191L;
    public static final int DEFAULT_MAX_NUMBER_OF_DATA_POINTS = 1000;
    public static LinkedHashMap<String, Class<? extends Plotter>> WEIGHT_PLOTTER_SELECTION = new LinkedHashMap();
    public static LinkedHashMap<String, Class<? extends Plotter>> DATA_SET_PLOTTER_SELECTION;
    public static LinkedHashMap<String, Class<? extends Plotter>> MODEL_PLOTTER_SELECTION;
    private Plotter plotter = null;
    private transient DataTable dataTable;
    private JLabel coordinatesLabel = new JLabel("                      ");
    private Point pressStart = null;
    private String selectedPlotter = null;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private JComboBox plotterCombo = new JComboBox();
    private LinkedHashMap<String, Class<? extends Plotter>> availablePlotters = new LinkedHashMap();

    static {
        WEIGHT_PLOTTER_SELECTION.put("Lines", ScatterPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put("Histogram", HistogramPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put("Hinton", HintonDiagram.class);
        WEIGHT_PLOTTER_SELECTION.put("Bound", BoundDiagram.class);
        WEIGHT_PLOTTER_SELECTION.put("Pie", PieChart2DPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put("Pie 3D", PieChart3DPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put("Ring", RingChartPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put("Bars", BarChart2DPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put("Bars 3D", BarChart3DPlotter.class);
        DATA_SET_PLOTTER_SELECTION = new LinkedHashMap();
        DATA_SET_PLOTTER_SELECTION.put("Scatter", ScatterPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Scatter Matrix", ScatterMatrixPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Scatter 3D", ScatterPlot3D.class);
        DATA_SET_PLOTTER_SELECTION.put("Scatter 3D Color", ScatterPlot3DColor.class);
        DATA_SET_PLOTTER_SELECTION.put("Bubble", BubbleChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Parallel", ParallelPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Survey", SurveyPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("SOM", SOMPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Density", DensityPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Pie", PieChart2DPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Pie 3D", PieChart3DPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Ring", RingChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Bars", BarChart2DPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Bars 3D", BarChart3DPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Andrews Curves", AndrewsCurves.class);
        DATA_SET_PLOTTER_SELECTION.put("Histogram", HistogramPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Histogram Color", ColorHistogramPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Histogram Matrix", HistogramMatrixPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Histogram Color Matrix", ColorHistogramMatrixPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Quartile", QuartilePlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Quartile Color", ColorQuartilePlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Quartile Color Matrix", ColorQuartileMatrixPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Sticks", SticksPlot2D.class);
        DATA_SET_PLOTTER_SELECTION.put("Sticks 3D", SticksPlot3D.class);
        DATA_SET_PLOTTER_SELECTION.put("Box", BoxPlot2D.class);
        DATA_SET_PLOTTER_SELECTION.put("Box 3D", BoxPlot3D.class);
        DATA_SET_PLOTTER_SELECTION.put("RadViz", RadVizPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("GridViz", GridVizPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Surface 3D", SurfacePlot3D.class);
        MODEL_PLOTTER_SELECTION = new LinkedHashMap();
        MODEL_PLOTTER_SELECTION.put("SOM", SOMModelPlotter.class);
    }

    public PlotterPanel(DataTable dataTable) {
        this(dataTable, DATA_SET_PLOTTER_SELECTION);
    }

    public PlotterPanel(DataTable dataTable, LinkedHashMap<String, Class<? extends Plotter>> availablePlotters) {
        super(new BorderLayout());
        this.availablePlotters = availablePlotters;
        if (this.availablePlotters == null || this.availablePlotters.size() == 0) {
            throw new IllegalArgumentException("The list of available plotters must not be null or empty!");
        }
        Iterator<String> i = availablePlotters.keySet().iterator();
        this.selectedPlotter = i.next();
        JScrollPane plotterScrollPane = new JScrollPane(this.mainPanel);
        plotterScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.add((Component)plotterScrollPane, "Center");
        this.setDataTable(dataTable);
    }

    public Plotter getSelectedPlotter() {
        return this.plotter;
    }

    public void setDataTable(DataTable dataTable) {
        this.dataTable = dataTable;
        if (dataTable.containsMissingValues()) {
            LogService.logMessage("Plotter: the given data contains missing values. Probably most plotters will not be able to produce proper visualizations. Please replace missing values beforehand if possible.", 6);
        }
        int maxRowNumber = 1000;
        String maxRowNumberString = System.getProperty("yale.gui.plotter.rows.maximum");
        if (maxRowNumberString != null && maxRowNumberString.trim().length() > 0) {
            try {
                int newMaxRows;
                maxRowNumber = newMaxRows = Integer.parseInt(maxRowNumberString);
            }
            catch (NumberFormatException e) {
                LogService.logMessage("Plotter: cannot read maximum number of plotter points (was '" + maxRowNumberString + "').", 4);
            }
        }
        if (this.dataTable.getNumberOfRows() > maxRowNumber) {
            this.dataTable.sample(maxRowNumber);
            LogService.logMessage("Cannot plot all data points, using only a sample of " + maxRowNumber + " rows.", 4);
        }
        this.update(true);
    }

    private void setSelectedPlotter(String name) {
        this.selectedPlotter = name;
        this.update(false);
    }

    private void update(boolean fillPlotterList) {
        int[] axis = null;
        LinkedList<Integer> valuesList = new LinkedList<Integer>();
        if (this.plotter != null) {
            axis = new int[this.plotter.getNumberOfAxes()];
            int i = 0;
            while (i < axis.length) {
                axis[i] = this.plotter.getAxis(i);
                ++i;
            }
            i = 0;
            while (i < this.dataTable.getNumberOfColumns()) {
                if (this.plotter.getPlotColumn(i)) {
                    valuesList.add(i);
                }
                ++i;
            }
        }
        int[] selectedIndices = new int[valuesList.size()];
        int k = 0;
        Iterator v = valuesList.iterator();
        while (v.hasNext()) {
            selectedIndices[k++] = (Integer)v.next();
        }
        try {
            this.plotter = this.availablePlotters.get(this.selectedPlotter).newInstance();
            this.plotter.setDataTable(this.dataTable);
        }
        catch (Exception e) {
            SwingTools.showErrorMessage("Cannot instantiate plotter '" + this.selectedPlotter + "':", e);
            return;
        }
        this.mainPanel.removeAll();
        this.plotter.addMouseMotionListener(this);
        this.plotter.addMouseListener(this);
        JComponent plotterComponent = this.plotter.getPlotter();
        plotterComponent.setBorder(BorderFactory.createEtchedBorder());
        this.mainPanel.add((Component)plotterComponent, "Center");
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel axesSelectionPanel = new JPanel(gridBag);
        String toolTip = "The plotter which should be used for displaying data.";
        JLabel label = new JLabel("Plotter");
        label.setToolTipText(toolTip);
        gridBag.setConstraints(label, c);
        axesSelectionPanel.add(label);
        if (fillPlotterList) {
            Thread thread = new Thread(this);
            thread.setPriority(10);
            thread.start();
        }
        gridBag.setConstraints(this.plotterCombo, c);
        axesSelectionPanel.add(this.plotterCombo);
        int i = 0;
        while (i < this.plotter.getNumberOfAxes()) {
            toolTip = "Select a column for " + this.plotter.getAxisName(i);
            label = new JLabel(this.plotter.getAxisName(i));
            label.setToolTipText(toolTip);
            gridBag.setConstraints(label, c);
            axesSelectionPanel.add(label);
            final JComboBox<String> axisCombo = new JComboBox<String>();
            axisCombo.setToolTipText(toolTip);
            axisCombo.addItem("None");
            int j = 0;
            while (j < this.dataTable.getNumberOfColumns()) {
                axisCombo.addItem(this.dataTable.getColumnName(j));
                ++j;
            }
            final int index = i;
            axisCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    PlotterPanel.this.plotter.setAxis(index, axisCombo.getSelectedIndex() - 1);
                }
            });
            if (axis != null && axis.length > i) {
                axisCombo.setSelectedIndex(Math.max(0, axis[i] + 1));
            }
            gridBag.setConstraints(axisCombo, c);
            axesSelectionPanel.add(axisCombo);
            if (this.plotter.isSupportingLogScale(i)) {
                final JCheckBox logScaleBox = new JCheckBox("Log Scale", false);
                logScaleBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PlotterPanel.this.plotter.setLogScale(index, logScaleBox.isSelected());
                    }
                });
                gridBag.setConstraints(logScaleBox, c);
                axesSelectionPanel.add(logScaleBox);
            }
            ++i;
        }
        if (this.plotter.getValuePlotSelectionType() != -1) {
            JLabel plotLabel;
            if (this.plotter.getPlotName() == null) {
                plotLabel = new JLabel("Plots");
                toolTip = "Select the column which should be plotted.";
            } else {
                plotLabel = new JLabel(this.plotter.getPlotName());
                toolTip = "Select a column for " + this.plotter.getPlotName();
            }
            plotLabel.setToolTipText(toolTip);
            gridBag.setConstraints(plotLabel, c);
            axesSelectionPanel.add(plotLabel);
        }
        switch (this.plotter.getValuePlotSelectionType()) {
            case 1: {
                final JList<String> plotList = new JList<String>(this.dataTable.getColumnNames());
                plotList.setToolTipText(toolTip);
                plotList.setBorder(BorderFactory.createLoweredBevelBorder());
                plotList.setCellRenderer(new LineStyleCellRenderer(this.plotter));
                plotList.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent e) {
                        int i = 0;
                        while (i < plotList.getModel().getSize()) {
                            PlotterPanel.this.plotter.setPlotColumn(i, plotList.isSelectedIndex(i));
                            ++i;
                        }
                    }
                });
                plotList.setSelectionMode(2);
                plotList.setSelectedIndices(selectedIndices);
                JScrollPane listScrollPane = new JScrollPane(plotList);
                c.weighty = 1.0;
                gridBag.setConstraints(listScrollPane, c);
                axesSelectionPanel.add(listScrollPane);
                c.weighty = 0.0;
                break;
            }
            case 0: {
                final JComboBox<String> plotCombo = new JComboBox<String>();
                plotCombo.setToolTipText(toolTip);
                plotCombo.addItem("None");
                int j = 0;
                while (j < this.dataTable.getNumberOfColumns()) {
                    plotCombo.addItem(this.dataTable.getColumnName(j));
                    ++j;
                }
                plotCombo.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        PlotterPanel.this.plotter.setPlotColumn(plotCombo.getSelectedIndex() - 1, true);
                    }
                });
                if (selectedIndices.length > 0) {
                    plotCombo.setSelectedIndex(selectedIndices[0] + 1);
                }
                gridBag.setConstraints(plotCombo, c);
                axesSelectionPanel.add(plotCombo);
                break;
            }
        }
        if (this.plotter.canHandleZooming()) {
            label = new JLabel("Zooming");
            toolTip = "Set a new zooming factor.";
            label.setToolTipText(toolTip);
            gridBag.setConstraints(label, c);
            axesSelectionPanel.add(label);
            final JSlider zoomingSlider = new JSlider(1, 100, this.plotter.getInitialZoomFactor());
            zoomingSlider.setToolTipText(toolTip);
            gridBag.setConstraints(zoomingSlider, c);
            axesSelectionPanel.add(zoomingSlider);
            zoomingSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    PlotterPanel.this.plotter.setZooming(zoomingSlider.getValue());
                }
            });
        }
        if (this.plotter.canHandleJitter()) {
            label = new JLabel("Jitter");
            toolTip = "Select the amount of jittering (small perturbation of data points).";
            label.setToolTipText(toolTip);
            gridBag.setConstraints(label, c);
            axesSelectionPanel.add(label);
            final JSlider jitterSlider = new JSlider(0, 100, 0);
            jitterSlider.setToolTipText(toolTip);
            gridBag.setConstraints(jitterSlider, c);
            axesSelectionPanel.add(jitterSlider);
            jitterSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    PlotterPanel.this.plotter.setJitter(jitterSlider.getValue());
                }
            });
        }
        if (this.plotter.hasOptionsDialog()) {
            toolTip = "Opens a dialog with further options for this plotter.";
            JButton optionsButton = new JButton("Options");
            optionsButton.setToolTipText(toolTip);
            gridBag.setConstraints(optionsButton, c);
            axesSelectionPanel.add(optionsButton);
            optionsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotterPanel.this.plotter.showOptionsDialog();
                }
            });
        }
        int componentCounter = 0;
        while (this.plotter.getOptionsComponent(componentCounter) != null) {
            JComponent options = this.plotter.getOptionsComponent(componentCounter);
            gridBag.setConstraints(options, c);
            axesSelectionPanel.add(options);
            ++componentCounter;
        }
        if (!this.plotter.hasSaveImageButton()) {
            toolTip = "Saves an image of the current plot.";
            JButton imageButton = new JButton("Save Image...");
            imageButton.setToolTipText(toolTip);
            imageButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComponent tosave = PlotterPanel.this.plotter.getPlotter();
                    ExportDialog exportDialog = new ExportDialog("YALE");
                    exportDialog.showExportDialog(PlotterPanel.this.getPanel(), "Save Image...", (Component)tosave, "plot");
                }
            });
            gridBag.setConstraints(imageButton, c);
            axesSelectionPanel.add(imageButton);
        }
        if (this.plotter.isSaveable()) {
            toolTip = "Saves the data underlying this plot into a file.";
            JButton saveButton = new JButton("Save...");
            saveButton.setToolTipText(toolTip);
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotterPanel.this.plotter.save();
                }
            });
            gridBag.setConstraints(saveButton, c);
            axesSelectionPanel.add(saveButton);
        }
        if (this.plotter.isProvidingCoordinates()) {
            this.coordinatesLabel = new JLabel("                      ");
            toolTip = "The current coordinates of the mouese cursor with respect to the data dimensions.";
            this.coordinatesLabel.setToolTipText(toolTip);
            this.coordinatesLabel.setBorder(BorderFactory.createEtchedBorder());
            this.coordinatesLabel.setFont(new Font("Monospaced", 0, this.coordinatesLabel.getFont().getSize()));
            gridBag.setConstraints(this.coordinatesLabel, c);
            axesSelectionPanel.add(this.coordinatesLabel);
        }
        if (this.plotter.getValuePlotSelectionType() != 1) {
            c.weighty = 1.0;
            JPanel fillPanel = new JPanel();
            gridBag.setConstraints(fillPanel, c);
            axesSelectionPanel.add(fillPanel);
            c.weighty = 0.0;
        }
        axesSelectionPanel.setAlignmentX(0.0f);
        this.mainPanel.add((Component)axesSelectionPanel, "West");
        this.revalidate();
        this.repaint();
    }

    private Component getPanel() {
        return this;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point2D p = this.plotter.getPositionInDataSpace(e.getPoint());
        if (p != null) {
            DecimalFormat format = new DecimalFormat(" 0.000E0;-0.000E0");
            this.coordinatesLabel.setText(String.valueOf(format.format(p.getX())) + " , " + format.format(p.getY()));
        }
        this.plotter.setMousePosInDataSpace(e.getX(), e.getY());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.pressStart != null && Math.abs((double)e.getX() - this.pressStart.getX()) > 5.0 && Math.abs((double)e.getY() - this.pressStart.getY()) > 5.0) {
            this.plotter.setDragBounds((int)Math.min(this.pressStart.getX(), (double)e.getX()), (int)Math.min(this.pressStart.getY(), (double)e.getY()), (int)Math.abs(this.pressStart.getX() - (double)e.getX()), (int)Math.abs(this.pressStart.getY() - (double)e.getY()));
        } else {
            this.plotter.setDragBounds(-1, -1, -1, -1);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            String id;
            if (e.getClickCount() > 1 && (id = this.plotter.getIdForPos(e.getX(), e.getY())) != null) {
                ObjectVisualizer visualizer = ObjectVisualizerService.getVisualizerForObject(id);
                visualizer.startVisualization(id);
            }
        } else if (e.getButton() == 3) {
            this.plotter.setDrawRange(-1.0, -1.0, -1.0, -1.0);
            this.pressStart = null;
            this.plotter.setDragBounds(-1, -1, -1, -1);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && this.pressStart != null && Math.abs((double)e.getX() - this.pressStart.getX()) > 5.0 && Math.abs((double)e.getY() - this.pressStart.getY()) > 5.0) {
            Point2D pressPoint = this.plotter.getPositionInDataSpace(this.pressStart);
            Point2D releasePoint = this.plotter.getPositionInDataSpace(e.getPoint());
            if (pressPoint != null) {
                this.plotter.setDrawRange(Math.min(pressPoint.getX(), releasePoint.getX()), Math.max(pressPoint.getX(), releasePoint.getX()), Math.min(pressPoint.getY(), releasePoint.getY()), Math.max(pressPoint.getY(), releasePoint.getY()));
            }
        }
        this.plotter.setDragBounds(-1, -1, -1, -1);
        this.pressStart = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.pressStart = e.getPoint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setSelectedPlotter((String)this.plotterCombo.getSelectedItem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JComboBox jComboBox = this.plotterCombo;
        synchronized (jComboBox) {
            this.plotterCombo.removeItemListener(this);
            this.plotterCombo.removeAllItems();
            for (String plotterName : this.availablePlotters.keySet()) {
                try {
                    Plotter plotter = this.availablePlotters.get(plotterName).newInstance();
                    PlotterCondition condition = plotter.getPlotterCondition();
                    if (condition.acceptDataTable(this.dataTable)) {
                        this.plotterCombo.addItem(plotterName);
                        continue;
                    }
                    LogService.logMessage("Cannot use plotter '" + plotterName + "': " + condition.getRejectionReason(this.dataTable), 2);
                }
                catch (InstantiationException e) {
                    LogService.logMessage("Plotter panel: cannot instantiate plotter '" + plotterName + "'. Skipping...", 4);
                }
                catch (IllegalAccessException e) {
                    LogService.logMessage("Plotter panel: cannot acess plotter '" + plotterName + "'. Skipping...", 4);
                }
            }
            this.plotterCombo.setToolTipText("The plotter which should be used for displaying data.");
            this.plotterCombo.addItemListener(this);
        }
    }

    private static class LineStyleCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -7039142638209143602L;
        Plotter plotter;

        public LineStyleCellRenderer(Plotter plotter) {
            this.plotter = plotter;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            Icon icon = this.plotter.getIcon(index);
            if (icon != null) {
                this.setIcon(icon);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

