/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.gui.plotter.Plotter;
import edu.udo.cs.yale.gui.plotter.ToolTip;
import edu.udo.cs.yale.gui.plotter.conditions.BasicPlotterCondition;
import edu.udo.cs.yale.gui.plotter.conditions.PlotterCondition;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PlotterAdapter
extends JPanel
implements Plotter {
    private static final long serialVersionUID = -8994113034200480325L;
    public static final double POINTSIZE = 6.0;
    private static final int[] TICS = new int[]{1, 2, 5};
    public static final int MARGIN = 20;
    public static final int WEIGHT_BORDER_WIDTH = 5;
    public static final Font LABEL_FONT = new Font("Lucida Sans", 0, 11);
    protected static final Color GRID_COLOR = Color.lightGray;
    protected static final Color TOOLTIP_COLOR = new Color(170, 150, 240, 210);
    protected static Icon[] LINE_STYLE_ICONS;
    protected static final Color[] LINE_COLORS;
    protected static final Stroke[] LINE_STROKES;
    protected static final LineStyle[] LINE_STYLES;
    private static Color MIN_LEGEND_COLOR;
    private static Color MAX_LEGEND_COLOR;

    static {
        LINE_COLORS = new Color[]{Color.black, Color.red, Color.blue, Color.orange, new Color(0, 200, 0), Color.pink, Color.yellow, Color.gray};
        LINE_STROKES = new Stroke[]{new BasicStroke()};
        LINE_STYLES = new LineStyle[LINE_COLORS.length * LINE_STROKES.length];
        MIN_LEGEND_COLOR = Color.BLUE;
        MAX_LEGEND_COLOR = Color.RED;
        int i = 0;
        while (i < LINE_STROKES.length) {
            int j = 0;
            while (j < LINE_COLORS.length) {
                PlotterAdapter.LINE_STYLES[i * PlotterAdapter.LINE_COLORS.length + j] = new LineStyle(LINE_COLORS[j], LINE_STROKES[i]);
                ++j;
            }
            ++i;
        }
        LINE_STYLE_ICONS = new LineStyleIcon[LINE_STYLES.length];
        i = 0;
        while (i < LINE_STYLE_ICONS.length) {
            PlotterAdapter.LINE_STYLE_ICONS[i] = new LineStyleIcon(i);
            ++i;
        }
    }

    private static void setMinLegendColor(Color minColor) {
        MIN_LEGEND_COLOR = minColor;
    }

    private static void setMaxLegendColor(Color maxColor) {
        MAX_LEGEND_COLOR = maxColor;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        PlotterAdapter.setMinLegendColor(this.getColorFromProperty("yale.gui.plotter.legend.mincolor", Color.BLUE));
        PlotterAdapter.setMaxLegendColor(this.getColorFromProperty("yale.gui.plotter.legend.maxcolor", Color.RED));
    }

    private Color getColorFromProperty(String propertyName, Color errorColor) {
        String propertyString = System.getProperty(propertyName);
        if (propertyString != null) {
            String[] colors = propertyString.split(",");
            Color color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
            return color;
        }
        return errorColor;
    }

    public boolean canHandleJitter() {
        return false;
    }

    public boolean canHandleZooming() {
        return false;
    }

    public int getAxis(int axis) {
        return -1;
    }

    public String getAxisName(int index) {
        return null;
    }

    public Icon getIcon(int index) {
        return LINE_STYLE_ICONS[index % LINE_STYLE_ICONS.length];
    }

    public String getIdForPos(int x, int y) {
        return null;
    }

    public int getInitialZoomFactor() {
        return 1;
    }

    public int getNumberOfAxes() {
        return 0;
    }

    public JComponent getOptionsComponent(int index) {
        return null;
    }

    public boolean getPlotColumn(int dimension) {
        return false;
    }

    public String getPlotName() {
        return null;
    }

    public final JComponent getPlotter() {
        return this;
    }

    public PlotterCondition getPlotterCondition() {
        return new BasicPlotterCondition();
    }

    public Point2D getPositionInDataSpace(Point p) {
        return null;
    }

    public int getValuePlotSelectionType() {
        return 0;
    }

    public boolean hasOptionsDialog() {
        return false;
    }

    public boolean hasSaveImageButton() {
        return false;
    }

    public boolean isProvidingCoordinates() {
        return false;
    }

    public boolean isSaveable() {
        return false;
    }

    public void save() {
    }

    public void setAxis(int plotterAxis, int dimension) {
    }

    public void setDragBounds(int x, int y, int w, int h) {
    }

    public void setDrawRange(double x, double y, double w, double h) {
    }

    public void setJitter(int jitter) {
    }

    public void setKey(String key) {
    }

    public void setMousePosInDataSpace(int mouseX, int mouseY) {
    }

    public void setPlotColumn(int dimension, boolean plot) {
    }

    public void setDataTable(DataTable dataTable) {
        dataTable.addDataTableListener(this);
    }

    public void setZooming(int zooming) {
    }

    public void showOptionsDialog() {
    }

    public boolean isSupportingLogScale(int axis) {
        return false;
    }

    public void setLogScale(int axis, boolean logScale) {
    }

    public final void dataTableUpdated(DataTable source) {
        int maxRowNumber = 1000;
        String maxRowNumberString = System.getProperty("yale.gui.plotter.rows.maximum");
        if (maxRowNumberString != null && maxRowNumberString.trim().length() > 0) {
            try {
                int newMaxRows;
                maxRowNumber = newMaxRows = Integer.parseInt(maxRowNumberString);
            }
            catch (NumberFormatException e) {
                LogService.logMessage("Plotter: cannot read maximum number of plotter points (was '" + maxRowNumberString + "').", 4);
            }
        }
        if (source.getNumberOfRows() > maxRowNumber) {
            source.sample(maxRowNumber);
            LogService.logMessage("Cannot plot all data points, using only a sample of " + maxRowNumber + " rows.", 4);
        }
        this.repaint();
    }

    protected double getPointColorValue(DataTable table, DataTableRow row, int column, double min, double max) {
        double compareValue;
        String otherColumnName;
        int otherColumnIndex;
        int endParIndex;
        String columnName;
        int startParIndex;
        double colorValue = row.getValue(column);
        double normalized = (colorValue - min) / (max - min);
        if (table.isNominal(column) && table.getNumberOfValues(column) == 2 && (startParIndex = (columnName = table.getColumnName(column)).indexOf("(") + 1) >= 0 && (endParIndex = columnName.indexOf(")", startParIndex)) >= 0 && (otherColumnIndex = table.getColumnIndex(otherColumnName = columnName.substring(startParIndex, endParIndex))) >= 0 && colorValue != (compareValue = row.getValue(otherColumnIndex))) {
            if (normalized > 0.8) {
                normalized = 0.8;
            } else if (normalized < 0.2) {
                normalized = 0.2;
            }
        }
        return normalized;
    }

    protected Color getPointBorderColor(DataTable table, DataTableRow row, int column) {
        Color result = Color.BLACK;
        if (table.isNominal(column)) {
            double compareValue;
            String otherColumnName;
            int otherColumnIndex;
            int endParIndex;
            double colorValue = row.getValue(column);
            String columnName = table.getColumnName(column);
            int startParIndex = columnName.indexOf("(") + 1;
            if (startParIndex >= 0 && (endParIndex = columnName.indexOf(")", startParIndex)) >= 0 && (otherColumnIndex = table.getColumnIndex(otherColumnName = columnName.substring(startParIndex, endParIndex))) >= 0 && colorValue != (compareValue = row.getValue(otherColumnIndex))) {
                result = Color.RED;
            }
        }
        return result;
    }

    public static Color getPointColor(double value) {
        return PlotterAdapter.getPointColor(value, 255);
    }

    public static Color getPointColor(double value, int alpha) {
        if (Double.isNaN(value)) {
            return Color.RED;
        }
        float[] minCol = Color.RGBtoHSB(MIN_LEGEND_COLOR.getRed(), MIN_LEGEND_COLOR.getGreen(), MIN_LEGEND_COLOR.getBlue(), null);
        float[] maxCol = Color.RGBtoHSB(MAX_LEGEND_COLOR.getRed(), MAX_LEGEND_COLOR.getGreen(), MAX_LEGEND_COLOR.getBlue(), null);
        double hColorDiff = maxCol[0] - minCol[0];
        double sColorDiff = maxCol[1] - minCol[1];
        double bColorDiff = maxCol[2] - minCol[2];
        Color color = new Color(Color.HSBtoRGB((float)((double)minCol[0] + hColorDiff * value), (float)((double)minCol[1] + value * sColorDiff), (float)((double)minCol[2] + value * bColorDiff)));
        if (alpha < 255) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }
        return color;
    }

    protected void drawPoint(Graphics2D g, double x, double y, Color color, Color borderColor) {
        Ellipse2D.Double pointShape = new Ellipse2D.Double(x - 3.0, y - 3.0, 6.0, 6.0);
        g.setColor(color);
        g.fill(pointShape);
        g.setColor(borderColor);
        g.draw(pointShape);
    }

    protected void drawLegend(Graphics graphics, DataTable table, int legendColumn) {
        this.drawLegend(graphics, table, legendColumn, 0, 255);
    }

    protected void drawLegend(Graphics graphics, DataTable table, int legendColumn, int xOffset, int alpha) {
        if (legendColumn < 0 || legendColumn > table.getNumberOfColumns() - 1) {
            return;
        }
        if (table.isNominal(legendColumn)) {
            String maxNominalValuesString = System.getProperty("yale.gui.plotter.legend.classlimit");
            int maxNumberOfNominalValues = 10;
            try {
                if (maxNominalValuesString != null) {
                    maxNumberOfNominalValues = Integer.parseInt(maxNominalValuesString);
                }
            }
            catch (NumberFormatException e) {
                LogService.logMessage("Plotter: cannot parse maximal number of nominal values for legend (" + maxNominalValuesString + ")! Using 10...", 4);
            }
            if (maxNumberOfNominalValues == -1 || table.getNumberOfValues(legendColumn) <= maxNumberOfNominalValues) {
                this.drawNominalLegend(graphics, table, legendColumn, xOffset, alpha);
            } else {
                LogService.logMessage("Plotter: cannot draw nominal legend since number of different values is too high (more than " + maxNominalValuesString + ")! Using numerical legend instead.", 4);
                this.drawNumericalLegend(graphics, table, legendColumn, alpha);
            }
        } else {
            this.drawNumericalLegend(graphics, table, legendColumn, alpha);
        }
    }

    private void drawNominalLegend(Graphics graphics, DataTable table, int legendColumn, int xOffset, int alpha) {
        Graphics2D g = (Graphics2D)graphics.create();
        g.translate(xOffset, 0);
        int numberOfValues = table.getNumberOfValues(legendColumn);
        int currentX = 20;
        int i = 0;
        while (i < numberOfValues) {
            if (currentX > this.getWidth()) break;
            String nominalValue = table.mapIndex(legendColumn, i);
            if (nominalValue.length() > 16) {
                nominalValue = String.valueOf(nominalValue.substring(0, 16)) + "...";
            }
            Rectangle2D.Double colorRect = new Rectangle2D.Double(currentX, 5.0, 10.0, 10.0);
            Color color = PlotterAdapter.getPointColor((double)i / (double)(numberOfValues - 1), alpha);
            g.setColor(color);
            g.fill(colorRect);
            g.setColor(Color.black);
            g.draw(colorRect);
            g.drawString(nominalValue, currentX += 15, 15);
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(nominalValue, g.getFontRenderContext());
            currentX = (int)((double)currentX + (stringBounds.getWidth() + 15.0));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawNumericalLegend(Graphics graphics, DataTable table, int legendColumn, int alpha) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        DataTable dataTable = table;
        synchronized (dataTable) {
            for (DataTableRow row : table) {
                double colorValue = row.getValue(legendColumn);
                min = Math.min(min, colorValue);
                max = Math.max(max, colorValue);
            }
        }
        this.drawNumericalLegend(graphics, min, max, alpha);
    }

    private void drawNumericalLegend(Graphics graphics, double minColor, double maxColor, int alpha) {
        String minColorString = Tools.formatNumber(minColor);
        String maxColorString = Tools.formatNumber(maxColor);
        Graphics2D g = (Graphics2D)graphics.create();
        Rectangle2D minStringBounds = LABEL_FONT.getStringBounds(minColorString, g.getFontRenderContext());
        Rectangle2D maxStringBounds = LABEL_FONT.getStringBounds(maxColorString, g.getFontRenderContext());
        int legendWidth = (int)(minStringBounds.getWidth() + 114.0 + maxStringBounds.getWidth());
        int keyX = 20 + this.getWidth() / 2 - legendWidth / 2;
        int keyY = (int)(22.0 - minStringBounds.getHeight() / 2.0);
        g.setColor(Color.black);
        g.drawString(minColorString, keyX, keyY);
        keyX = (int)((double)keyX + (minStringBounds.getWidth() + 10.0));
        int i = 0;
        while (i < 100) {
            double scaledColor = (double)i / 100.0;
            Color lineColor = PlotterAdapter.getPointColor(scaledColor, alpha);
            g.setColor(lineColor);
            g.drawLine(keyX, keyY, keyX, keyY - 10);
            ++keyX;
            ++i;
        }
        g.setColor(Color.black);
        Rectangle2D.Double frame = new Rectangle2D.Double(keyX - 101, keyY - 11, 101.0, 11.0);
        g.draw(frame);
        g.drawString(maxColorString, keyX += 4, keyY);
    }

    protected void drawToolTip(Graphics2D g, ToolTip toolTip) {
        if (toolTip != null) {
            g.setFont(LABEL_FONT);
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(toolTip.getText(), g.getFontRenderContext());
            g.setColor(TOOLTIP_COLOR);
            Rectangle2D.Double bg = new Rectangle2D.Double((double)toolTip.getX() - stringBounds.getWidth() / 2.0 - 4.0, (double)toolTip.getY() - stringBounds.getHeight() / 2.0, stringBounds.getWidth() + 5.0, stringBounds.getHeight() + 3.0);
            g.fill(bg);
            g.setColor(Color.black);
            g.draw(bg);
            g.drawString(toolTip.getText(), (int)((double)toolTip.getX() - stringBounds.getWidth() / 2.0 - 2.0), toolTip.getY() + 6);
        }
    }

    protected int getNumberOfPlots(DataTable table) {
        int counter = 0;
        int i = 0;
        while (i < table.getNumberOfColumns()) {
            if (this.getPlotColumn(i)) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    protected double getTicSize(DataTable dataTable, int column, double min, double max) {
        if (column < 0) {
            return Double.NaN;
        }
        if (this.getNumberOfPlots(dataTable) == 1 && dataTable.isNominal(column)) {
            if (dataTable.getNumberOfValues(column) <= 10) {
                return 1.0;
            }
            return this.getNumericalTicSize(min, max);
        }
        return this.getNumericalTicSize(min, max);
    }

    protected double getNumericalTicSize(double min, double max) {
        double delta = (max - min) / 5.0;
        double e = Math.floor(Math.log(delta) / Math.log(10.0));
        double factor = Math.pow(10.0, e);
        int i = TICS.length - 1;
        while (i >= 0) {
            if ((double)TICS[i] * factor <= delta) {
                return (double)TICS[i] * factor;
            }
            --i;
        }
        return factor;
    }

    protected double getMaxWeight(DataTable dataTable) {
        double maxWeight = Double.NaN;
        if (dataTable.isSupportingColumnWeights()) {
            maxWeight = Double.NEGATIVE_INFINITY;
            int c = 0;
            while (c < dataTable.getNumberOfColumns()) {
                double weight = dataTable.getColumnWeight(c);
                if (!Double.isNaN(weight)) {
                    maxWeight = Math.max(Math.abs(weight), maxWeight);
                }
                ++c;
            }
        }
        return maxWeight;
    }

    protected Color getWeightColor(double weight, double maxWeight) {
        Color weightColor = Color.white;
        if (!Double.isNaN(weight) && !Double.isNaN(maxWeight)) {
            weightColor = new Color(255, 255, 0, (int)(Math.abs(weight) / maxWeight * 100.0));
        }
        return weightColor;
    }

    protected void drawWeightRectangle(Graphics2D newSpace, DataTable dataTable, int column, double maxWeight, int plotterSize) {
        if (dataTable.isSupportingColumnWeights()) {
            newSpace.setColor(this.getWeightColor(dataTable.getColumnWeight(column), maxWeight));
            Rectangle2D.Double weightRect = new Rectangle2D.Double(1.0, 1.0, plotterSize - 2, plotterSize - 2);
            newSpace.fill(weightRect);
            newSpace.setColor(Color.WHITE);
            int weightBorder = 6;
            weightRect = new Rectangle2D.Double(weightBorder, weightBorder, plotterSize - 2 * weightBorder, plotterSize - 2 * weightBorder);
            newSpace.fill(weightRect);
        }
    }

    protected static class LineStyleIcon
    implements Icon {
        private int index;

        private LineStyleIcon(int index) {
            this.index = index;
        }

        public int getIconWidth() {
            return 26;
        }

        public int getIconHeight() {
            return 1;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            LINE_STYLES[this.index].set((Graphics2D)g);
            g.drawLine(x + 2, y, x + 26, y);
        }
    }

    protected static class LineStyle {
        private Color color;
        private Stroke stroke;

        private LineStyle(Color color, Stroke stroke) {
            this.color = color;
            this.stroke = stroke;
        }

        public void set(Graphics2D g) {
            g.setColor(this.color);
            g.setStroke(this.stroke);
        }

        public Color getColor() {
            return this.color;
        }
    }
}

