/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.gui.plotter.Bin;
import edu.udo.cs.yale.gui.plotter.Bins;
import edu.udo.cs.yale.gui.plotter.PlotterAdapter;
import edu.udo.cs.yale.gui.plotter.RectangleStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HistogramPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = 5447178172542465015L;
    public static final int MIN_BIN_NUMBER = 2;
    public static final int MAX_BIN_NUMBER = 100;
    public static final int DEFAULT_BIN_NUMBER = 40;
    private static Icon[] RECTANGLE_STYLE_ICONS = new RectangleStyleIcon[10];
    private static final Font SCALED_LABEL_FONT;
    private static final int LABEL_MARGIN_X = 50;
    private static final int LABEL_MARGIN_Y = 15;
    protected transient DataTable dataTable;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected double xTicSize;
    protected double yTicSize;
    private boolean[] columns = new boolean[0];
    protected Map<Integer, Bins> allPlots = new HashMap<Integer, Bins>();
    protected int binNumber = 40;
    protected boolean drawLegend = true;
    private String key = null;
    protected int currentXPlotterColumn = -1;

    static {
        int i = 0;
        while (i < RECTANGLE_STYLE_ICONS.length) {
            HistogramPlotter.RECTANGLE_STYLE_ICONS[i] = new RectangleStyleIcon(i);
            ++i;
        }
        SCALED_LABEL_FONT = LABEL_FONT.deriveFont(AffineTransform.getScaleInstance(1.0, -1.0));
    }

    public HistogramPlotter() {
        this.setBackground(Color.white);
    }

    public HistogramPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.columns = new boolean[this.dataTable.getNumberOfColumns()];
        this.repaint();
    }

    public Bins getBins(int plotColumn) {
        return this.allPlots.get(plotColumn);
    }

    public Icon getIcon(int index) {
        return RECTANGLE_STYLE_ICONS[index % RECTANGLE_STYLE_ICONS.length];
    }

    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            JLabel label = new JLabel("Number of bins:");
            label.setToolTipText("Set the number of bins which should be displayed.");
            return label;
        }
        if (index == 1) {
            final JSlider binNumberSlider = new JSlider(2, 100, 40);
            binNumberSlider.setMajorTickSpacing(98);
            binNumberSlider.setMinorTickSpacing(9);
            binNumberSlider.setPaintTicks(true);
            binNumberSlider.setPaintLabels(true);
            binNumberSlider.setToolTipText("Set the number of bins which should be displayed.");
            binNumberSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (!binNumberSlider.getValueIsAdjusting()) {
                        HistogramPlotter.this.setBinNumber(binNumberSlider.getValue());
                    }
                }
            });
            return binNumberSlider;
        }
        return null;
    }

    public void setBinNumber(int binNumber) {
        this.binNumber = binNumber;
        this.repaint();
    }

    public void setPlotColumn(int index, boolean plot) {
        this.columns[index] = plot;
        this.repaint();
    }

    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    public int getValuePlotSelectionType() {
        return 1;
    }

    protected int getNumberOfPlots() {
        int counter = 0;
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i]) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public void setDrawLegend(boolean drawLegend) {
        this.drawLegend = drawLegend;
    }

    public void setKey(String key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareData() {
        this.minX = Double.POSITIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        this.allPlots.clear();
        if (this.getNumberOfPlots() == 0) {
            return;
        }
        this.currentXPlotterColumn = -1;
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            double[] minX = new double[this.dataTable.getNumberOfColumns()];
            double[] maxX = new double[this.dataTable.getNumberOfColumns()];
            int d = 0;
            while (d < minX.length) {
                minX[d] = Double.POSITIVE_INFINITY;
                maxX[d] = Double.NEGATIVE_INFINITY;
                ++d;
            }
            for (DataTableRow row : this.dataTable) {
                int d2 = 0;
                while (d2 < row.getNumberOfValues()) {
                    if (this.getPlotColumn(d2)) {
                        this.currentXPlotterColumn = d2;
                        double value = row.getValue(d2);
                        if (!Double.isNaN(value)) {
                            minX[d2] = Math.min(value, minX[d2]);
                            this.minX = Math.min(value, this.minX);
                            maxX[d2] = Math.max(value, maxX[d2]);
                            this.maxX = Math.max(value, this.maxX);
                        }
                    }
                    ++d2;
                }
            }
            int d3 = 0;
            while (d3 < minX.length) {
                if (this.getPlotColumn(d3)) {
                    Bins bins = new Bins(d3, minX[d3], maxX[d3], this.binNumber);
                    this.allPlots.put(d3, bins);
                }
                ++d3;
            }
            for (DataTableRow row : this.dataTable) {
                int d4 = 0;
                while (d4 < row.getNumberOfValues()) {
                    if (this.getPlotColumn(d4)) {
                        Bins bins = this.allPlots.get(d4);
                        bins.addPoint(row.getValue(d4));
                        this.maxY = Math.max((double)bins.getMaxCounter(), this.maxY);
                    }
                    ++d4;
                }
            }
        }
        this.minY = 0.0;
        if (this.dataTable.getNumberOfRows() == 0) {
            this.minX = 0.0;
            this.maxX = 1.0;
            this.minY = 0.0;
            this.maxY = 1.0;
        }
        if (this.minX == this.maxX) {
            this.minX -= 0.5;
            this.maxX += 0.5;
        }
        if (this.minY == this.maxY) {
            this.minY -= 0.5;
            this.maxY += 0.5;
        }
        this.xTicSize = this.getTicSize(this.dataTable, this.currentXPlotterColumn, this.minX, this.maxX);
        this.yTicSize = this.getNumericalTicSize(this.minY, this.maxY);
        this.minX = Math.floor(this.minX / this.xTicSize) * this.xTicSize;
        this.maxX = Math.ceil(this.maxX / this.xTicSize) * this.xTicSize;
        this.minY = Math.floor(this.minY / this.yTicSize) * this.yTicSize;
        this.maxY = Math.ceil(this.maxY / this.yTicSize) * this.yTicSize;
    }

    private void drawBins(Graphics2D g, double dx, double dy, double sx, double sy) {
        if (this.allPlots.size() == 0) {
            return;
        }
        Iterator<Bins> b = this.allPlots.values().iterator();
        int offset = 0;
        while (b.hasNext()) {
            Bins bins = b.next();
            if (bins.getMaxCounter() > 0) {
                Iterator<Bin> i = bins.getIterator();
                while (i.hasNext()) {
                    Bin bin = i.next();
                    Rectangle2D.Double rectangle = new Rectangle2D.Double((bin.getLeft() + dx) * sx + (double)offset, dy * sy, (bin.getRight() - bin.getLeft()) * sx, (double)bin.getCounter() * sy);
                    bins.getRectangleStyle().set(g);
                    g.fill(rectangle);
                    g.setColor(Color.black);
                    g.draw(rectangle);
                }
            }
            offset += 2;
        }
    }

    private void drawGrid(Graphics2D g, double dx, double dy, double sx, double sy) {
        DecimalFormat format = new DecimalFormat("0.00E0");
        g.setFont(SCALED_LABEL_FONT);
        int numberOfXTics = (int)Math.ceil((this.maxX - this.minX) / this.xTicSize) + 1;
        int i = 0;
        while (i < numberOfXTics) {
            this.drawVerticalTic(g, i, format, dx, dy, sx, sy);
            ++i;
        }
        int numberOfYTics = (int)Math.ceil((this.maxY - this.minY) / this.yTicSize) + 1;
        int i2 = 0;
        while (i2 < numberOfYTics) {
            this.drawHorizontalTic(g, i2, format, dx, dy, sx, sy);
            ++i2;
        }
    }

    private void drawVerticalTic(Graphics2D g, int ticNumber, DecimalFormat format, double dx, double dy, double sx, double sy) {
        double x = (double)ticNumber * this.xTicSize + this.minX;
        g.setColor(GRID_COLOR);
        g.draw(new Line2D.Double((x + dx) * sx, (this.minY + dy) * sy, (x + dx) * sx, (this.maxY + dy) * sy));
        g.setColor(Color.black);
        String label = null;
        if (this.getNumberOfPlots(this.dataTable) == 1 && this.dataTable.isNominal(this.currentXPlotterColumn)) {
            int index = (int)Math.round(x);
            if (index >= 0 && index < this.dataTable.getNumberOfValues(this.currentXPlotterColumn)) {
                label = this.dataTable.mapIndex(this.currentXPlotterColumn, index);
            }
        } else {
            label = format.format(x);
        }
        if (label != null) {
            Rectangle2D stringBounds = SCALED_LABEL_FONT.getStringBounds(label, g.getFontRenderContext());
            g.drawString(label, (float)((x + dx) * sx - stringBounds.getWidth() / 2.0), (float)((this.minY + dy) * sy + stringBounds.getHeight()));
        }
    }

    private void drawHorizontalTic(Graphics2D g, int ticNumber, DecimalFormat format, double dx, double dy, double sx, double sy) {
        double y = (double)ticNumber * this.yTicSize + this.minY;
        g.setColor(GRID_COLOR);
        g.draw(new Line2D.Double((this.minX + dx) * sx, (y + dy) * sy, (this.maxX + dx) * sx, (y + dy) * sy));
        g.setColor(Color.black);
        String label = String.valueOf(format.format(y)) + " ";
        Rectangle2D stringBounds = SCALED_LABEL_FONT.getStringBounds(label, g.getFontRenderContext());
        g.drawString(label, (float)((this.minX + dx) * sx - stringBounds.getWidth()), (float)((y + dy) * sy - stringBounds.getHeight() / 2.0 - stringBounds.getY()));
    }

    private void drawBins(Graphics2D g, int pixWidth, int pixHeight) {
        double sx = 0.0;
        double sy = 0.0;
        sx = ((double)pixWidth - 50.0) / (this.maxX - this.minX);
        sy = ((double)pixHeight - 15.0) / (this.maxY - this.minY);
        Graphics2D coordinateSpace = (Graphics2D)g.create();
        if (this.drawLegend) {
            coordinateSpace.translate(50, 15);
        } else {
            coordinateSpace.translate(25.0, 3.0);
        }
        if (Double.isNaN(sx) || Double.isNaN(sy)) {
            coordinateSpace.scale(1.0, -1.0);
            coordinateSpace.drawString("No data points available (yet).", 0, -20);
            coordinateSpace.drawString("Zooming out with a right click might help.", 0, 0);
        } else {
            if (this.drawLegend) {
                this.drawGrid(coordinateSpace, -this.minX, -this.minY, sx, sy);
            }
            this.drawBins(coordinateSpace, -this.minX, -this.minY, sx, sy);
        }
        coordinateSpace.dispose();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int pixWidth = this.getWidth() - 40;
        int pixHeight = this.getHeight() - 40;
        Graphics2D translated = (Graphics2D)graphics.create();
        translated.translate(20, 20);
        this.paintHistogram(translated, pixWidth, pixHeight);
    }

    public void paintHistogram(Graphics graphics, int pixWidth, int pixHeight) {
        Graphics2D g = (Graphics2D)graphics;
        if (this.key != null) {
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(this.key, g.getFontRenderContext());
            int xPos = (int)((double)pixWidth / 2.0 - stringBounds.getWidth() / 2.0);
            int yPos = 16;
            g.setColor(Color.black);
            g.drawString(this.key, xPos, yPos);
        }
        Graphics2D scaled = (Graphics2D)g.create();
        scaled.translate(0, pixHeight + 1);
        this.prepareData();
        if (this.allPlots.size() == 0) {
            scaled.drawString("No plots selected.", 20, -20);
        } else {
            scaled.scale(1.0, -1.0);
            g.setColor(Color.black);
            this.drawBins(scaled, pixWidth, pixHeight);
        }
        scaled.dispose();
    }

    private static class RectangleStyleIcon
    implements Icon {
        private RectangleStyle style;

        private RectangleStyleIcon(int index) {
            this.style = new RectangleStyle(index);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.style.set((Graphics2D)g);
            g.fillRect(x, y, 16, 16);
            g.setColor(Color.black);
            g.drawRect(x, y, 16, 16);
        }
    }
}

