/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.gui.plotter.HistogramPlotter;
import edu.udo.cs.yale.gui.plotter.PlotterAdapter;
import edu.udo.cs.yale.gui.plotter.conditions.ColumnsPlotterCondition;
import edu.udo.cs.yale.gui.plotter.conditions.PlotterCondition;
import edu.udo.cs.yale.tools.LogService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HistogramMatrixPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = 9049081889010883621L;
    static final int MAX_NUMBER_OF_COLUMNS = 100;
    static final int DEFAULT_BIN_NUMBER = 15;
    private HistogramPlotter[] plotters = new HistogramPlotter[0];
    private double maxWeight = Double.NaN;
    private transient DataTable dataTable;
    private int plotterSize;

    public HistogramMatrixPlotter() {
        this.setBackground(Color.white);
        String sizeProperty = System.getProperty("yale.gui.plotter.matrixplot.size");
        this.plotterSize = 200;
        try {
            if (sizeProperty != null) {
                this.plotterSize = Integer.parseInt(sizeProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.logMessage("Histogram matrix: cannot parse plotter size (was '" + sizeProperty + "'), using default size (200).", 4);
        }
    }

    public HistogramMatrixPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.plotters = new HistogramPlotter[dataTable.getNumberOfColumns()];
        int x = 0;
        while (x < this.plotters.length) {
            this.plotters[x] = new HistogramPlotter(dataTable);
            this.plotters[x].getPlotter().setSize(new Dimension(this.plotterSize, this.plotterSize));
            this.plotters[x].setPlotColumn(x, true);
            this.plotters[x].setDrawLegend(false);
            this.plotters[x].setKey(dataTable.getColumnName(x));
            ++x;
        }
        this.setBinNumber(15);
        this.maxWeight = this.getMaxWeight(dataTable);
        this.repaint();
    }

    public PlotterCondition getPlotterCondition() {
        return new ColumnsPlotterCondition(100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getMaxNumberPerRow() * this.plotterSize + 40, this.getMaxNumberPerRow() * this.plotterSize + 40);
    }

    private int getMaxNumberPerRow() {
        return (int)Math.ceil(Math.sqrt(this.plotters.length));
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int xPos = 0;
        int yPos = 0;
        int x = 0;
        while (x < this.plotters.length) {
            if (xPos >= this.getMaxNumberPerRow()) {
                ++yPos;
                xPos = 0;
            }
            Graphics2D newSpace = (Graphics2D)graphics.create();
            newSpace.translate(20 + xPos * this.plotterSize, 20 + yPos * this.plotterSize);
            this.drawWeightRectangle(newSpace, this.dataTable, x, this.maxWeight, this.plotterSize);
            newSpace.translate(7, 7);
            this.plotters[x].paintHistogram(newSpace, this.plotterSize - 13, this.plotterSize - 13);
            newSpace.dispose();
            ++xPos;
            ++x;
        }
    }

    public int getValuePlotSelectionType() {
        return -1;
    }

    public Icon getIcon(int index) {
        return null;
    }

    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            JLabel label = new JLabel("Number of bins:");
            label.setToolTipText("Set the number of bins which should be displayed.");
            return label;
        }
        if (index == 1) {
            final JSlider binNumberSlider = new JSlider(2, 100, 15);
            binNumberSlider.setMajorTickSpacing(98);
            binNumberSlider.setMinorTickSpacing(9);
            binNumberSlider.setPaintTicks(true);
            binNumberSlider.setPaintLabels(true);
            binNumberSlider.setToolTipText("Set the number of bins which should be displayed.");
            binNumberSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (!binNumberSlider.getValueIsAdjusting()) {
                        HistogramMatrixPlotter.this.setBinNumber(binNumberSlider.getValue());
                    }
                }
            });
            return binNumberSlider;
        }
        return null;
    }

    public void setBinNumber(int size) {
        int x = 0;
        while (x < this.plotters.length) {
            this.plotters[x].setBinNumber(size);
            ++x;
        }
        this.repaint();
    }
}

