/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.gui.plotter.PlotterAdapter;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.swing.Icon;

public class HintonDiagram
extends PlotterAdapter
implements MouseListener {
    private static final long serialVersionUID = -1299407916734619185L;
    private double[] values;
    private double maxWeight;
    private String[] names;
    private int boxSize = 51;
    private int horizontalCount;
    private int verticalCount;
    private String currentToolTip;
    private double toolTipX;
    private double toolTipY;
    private int plotIndex = -1;
    private transient DataTable dataTable;

    public HintonDiagram() {
        this.setBackground(Color.white);
        this.addMouseListener(this);
    }

    public HintonDiagram(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.repaint();
    }

    public String getPlotName() {
        return "Plot";
    }

    public void setPlotColumn(int index, boolean plot) {
        this.plotIndex = index;
        this.repaint();
    }

    public boolean getPlotColumn(int index) {
        return index == this.plotIndex;
    }

    public boolean canHandleZooming() {
        return true;
    }

    public Icon getIcon(int index) {
        return null;
    }

    public void setZooming(int amount) {
        if (amount % 2 == 0) {
            ++amount;
        }
        this.boxSize = amount;
        this.repaint();
    }

    public int getInitialZoomFactor() {
        return this.boxSize;
    }

    private void prepareData() {
        if (this.plotIndex < 0) {
            this.values = new double[0];
            this.names = new String[0];
        } else {
            int size = this.dataTable.getNumberOfRows();
            this.values = new double[size];
            this.names = new String[size];
            Iterator<DataTableRow> i = this.dataTable.iterator();
            int counter = 0;
            this.maxWeight = Double.NEGATIVE_INFINITY;
            while (i.hasNext()) {
                DataTableRow row = i.next();
                this.values[counter] = row.getValue(this.plotIndex);
                this.maxWeight = Math.max(this.maxWeight, Math.abs(this.values[counter]));
                String id = row.getId();
                if (id == null) {
                    id = String.valueOf(this.values[counter]);
                }
                this.names[counter] = id;
                ++counter;
            }
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        this.prepareData();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        this.horizontalCount = (int)Math.floor((double)(width + 1) / (double)(this.boxSize + 1));
        this.verticalCount = (int)Math.floor((double)(height + 1) / (double)(this.boxSize + 1));
        if (this.horizontalCount * this.verticalCount < this.values.length) {
            while (this.horizontalCount * this.verticalCount < this.values.length) {
                ++this.verticalCount;
            }
        } else if (this.horizontalCount * this.verticalCount > this.values.length) {
            while (this.horizontalCount * (this.verticalCount - 1) > this.values.length) {
                --this.verticalCount;
            }
        }
        this.setPreferredSize(new Dimension(this.horizontalCount * (this.boxSize + 1) + 1, this.verticalCount * (this.boxSize + 1) + 1));
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, this.horizontalCount * (this.boxSize + 1), this.verticalCount * (this.boxSize + 1));
        int h = 1;
        while (h < this.horizontalCount) {
            g.drawLine(this.boxSize * h + h, 0, this.boxSize * h + h, this.boxSize * this.verticalCount + this.verticalCount - 1);
            ++h;
        }
        int v = 1;
        while (v < this.verticalCount) {
            g.drawLine(0, this.boxSize * v + v, this.boxSize * this.horizontalCount + this.horizontalCount - 1, this.boxSize * v + v);
            ++v;
        }
        int att = 0;
        int horiz = 1;
        int vert = 1;
        while (att < this.values.length) {
            if (this.values[att] < 0.0) {
                g.setColor(SwingTools.LIGHT_BLUE);
            } else {
                g.setColor(SwingTools.LIGHT_YELLOW);
            }
            int breite = (int)(Math.abs(this.values[att]) / this.maxWeight * (double)this.boxSize);
            int centerx = (horiz - 1) * (this.boxSize + 1) + (this.boxSize + 1) / 2;
            int centery = (vert - 1) * (this.boxSize + 1) + (this.boxSize + 1) / 2;
            g.fillRect(centerx - breite / 2, centery - breite / 2, breite, breite);
            if (++horiz > this.horizontalCount) {
                horiz = 1;
                ++vert;
            }
            ++att;
        }
        g.setColor(Color.WHITE);
        if (horiz <= this.horizontalCount) {
            g.fillRect(horiz == 1 ? 0 : (horiz - 1) * (this.boxSize + 1) + 1, (vert - 1) * (this.boxSize + 1) + 1, width, height);
        }
        if (++vert <= this.verticalCount) {
            g.fillRect(0, (vert - 1) * (this.boxSize + 1) + 1, width, height);
        }
        this.drawToolTip((Graphics2D)g);
    }

    private void drawToolTip(Graphics2D g) {
        if (this.currentToolTip != null) {
            g.setFont(LABEL_FONT);
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(this.currentToolTip, g.getFontRenderContext());
            g.setColor(TOOLTIP_COLOR);
            Rectangle2D.Double bg = new Rectangle2D.Double(this.toolTipX - stringBounds.getWidth() / 2.0 - 4.0, this.toolTipY - stringBounds.getHeight() / 2.0 - 2.0, stringBounds.getWidth() + 5.0, Math.abs(stringBounds.getHeight()) + 3.0);
            g.fill(bg);
            g.setColor(Color.black);
            g.draw(bg);
            g.drawString(this.currentToolTip, (float)(this.toolTipX - stringBounds.getWidth() / 2.0) - 2.0f, (float)(this.toolTipY + 3.0));
        }
    }

    private void setToolTip(String toolTip, double x, double y) {
        this.currentToolTip = toolTip;
        this.toolTipX = x;
        this.toolTipY = y;
        this.repaint();
    }

    private String getAttributeName(int x, int y) {
        int horiz = x / (this.boxSize + 1) + (x % (this.boxSize + 1) > 0 ? 1 : 0);
        horiz = Math.min(horiz, this.horizontalCount);
        int vert = y / (this.boxSize + 1) + (y % (this.boxSize + 1) > 0 ? 1 : 0);
        vert = Math.min(vert, this.verticalCount);
        int index = (vert - 1) * this.horizontalCount + horiz;
        index = Math.min(index, this.values.length);
        index = Math.max(index, 0);
        return String.valueOf(this.names[index - 1]) + ": " + Tools.formatNumber(this.values[index - 1]);
    }

    public void mouseClicked(MouseEvent event) {
        String name = this.getAttributeName(event.getX(), event.getY());
        this.setToolTip(name, event.getX(), event.getY());
    }

    public void mouseReleased(MouseEvent event) {
        this.currentToolTip = null;
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseDragged(MouseEvent arg0) {
    }

    public void mouseMoved(MouseEvent event) {
    }
}

