/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.gui.plotter.PlotterAdapter;
import edu.udo.cs.yale.gui.plotter.Quartile;
import edu.udo.cs.yale.tools.LogService;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ColorQuartilePlotter
extends PlotterAdapter {
    private static final long serialVersionUID = -5115095967846809152L;
    private static final int LABEL_MARGIN_X = 50;
    private static final int NUMBER_OF_TICS = 6;
    private int columnIndex = -1;
    private int colorIndex = -1;
    protected transient DataTable dataTable;
    protected List<Quartile> allQuartiles = new LinkedList<Quartile>();
    private boolean drawLegend = true;
    private String key = null;
    protected double globalMin = Double.NaN;
    protected double globalMax = Double.NaN;

    public ColorQuartilePlotter() {
        this.setBackground(Color.white);
    }

    public ColorQuartilePlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.repaint();
    }

    public int getNumberOfAxes() {
        return 1;
    }

    public int getAxis(int axis) {
        return this.columnIndex;
    }

    public String getAxisName(int index) {
        if (index == 0) {
            return "Dimension";
        }
        return "empty";
    }

    public void setAxis(int index, int dimension) {
        if (this.columnIndex != dimension) {
            this.columnIndex = dimension;
            this.repaint();
        }
    }

    public String getPlotName() {
        return "Color";
    }

    public void setPlotColumn(int index, boolean plot) {
        this.colorIndex = index;
        this.repaint();
    }

    public boolean getPlotColumn(int index) {
        return index == this.colorIndex;
    }

    public void setDrawLegend(boolean drawLegend) {
        this.drawLegend = drawLegend;
    }

    public void setKey(String key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareData() {
        this.allQuartiles.clear();
        this.globalMin = Double.POSITIVE_INFINITY;
        this.globalMax = Double.NEGATIVE_INFINITY;
        if (this.columnIndex != -1) {
            if (this.colorIndex != -1) {
                TreeMap<Double, LinkedList<Double>> valueMap = new TreeMap<Double, LinkedList<Double>>();
                DataTable dataTable = this.dataTable;
                synchronized (dataTable) {
                    for (DataTableRow row : this.dataTable) {
                        double columnValue = row.getValue(this.columnIndex);
                        double colorValue = row.getValue(this.colorIndex);
                        LinkedList<Double> values = (LinkedList<Double>)valueMap.get(colorValue);
                        if (values == null) {
                            values = new LinkedList<Double>();
                            values.add(columnValue);
                            valueMap.put(colorValue, values);
                            continue;
                        }
                        values.add(columnValue);
                    }
                    String maxClassesProperty = System.getProperty("yale.gui.plotter.colors.classlimit");
                    int maxClasses = 10;
                    try {
                        if (maxClassesProperty != null) {
                            maxClasses = Integer.parseInt(maxClassesProperty);
                        }
                    }
                    catch (NumberFormatException e) {
                        LogService.logMessage("Quartile: cannot parse property 'yale.gui.plotter.colors.classlimit', using maximal 10 different classes.", 4);
                    }
                    if (valueMap.size() <= maxClasses) {
                        for (Map.Entry e : valueMap.entrySet()) {
                            Double key = (Double)e.getKey();
                            int colorValue = (int)key.doubleValue();
                            Color color = ColorQuartilePlotter.getPointColor((double)colorValue / ((double)valueMap.size() - 1.0));
                            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 30);
                            Quartile quartile = Quartile.calculateQuartile((List)e.getValue());
                            this.globalMin = Math.min(this.globalMin, quartile.getMin());
                            this.globalMax = Math.max(this.globalMax, quartile.getMax());
                            quartile.setColor(color);
                            this.allQuartiles.add(quartile);
                        }
                    } else {
                        LogService.logMessage("Quartile Color: cannot create colorized quartile plot since the number of different values (" + valueMap.size() + ") is too large. Allowed are " + maxClassesProperty + " different values for a colorized plot (edit this limit in the properties dialog).", 4);
                    }
                }
            }
            Quartile quartile = Quartile.calculateQuartile(this.dataTable, this.columnIndex);
            this.allQuartiles.add(quartile);
            this.globalMin = quartile.getMin();
            this.globalMax = quartile.getMax();
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.drawLegend) {
            this.drawLegend(graphics, this.dataTable, this.colorIndex, 50, 30);
        }
        int pixWidth = this.getWidth() - 40;
        int pixHeight = this.getHeight() - 40;
        Graphics2D translated = (Graphics2D)graphics.create();
        translated.translate(20, 20);
        this.paintQuartiles(translated, pixWidth, pixHeight);
        translated.dispose();
    }

    public void paintQuartiles(Graphics2D g, int pixWidth, int pixHeight) {
        this.prepareData();
        if (this.allQuartiles.size() == 0) {
            return;
        }
        if (this.drawLegend) {
            this.drawGrid(g, pixWidth, pixHeight);
        }
        if (this.key != null) {
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(this.key, g.getFontRenderContext());
            int xPos = (int)((double)pixWidth / 2.0 - stringBounds.getWidth() / 2.0);
            int yPos = 16;
            g.setColor(Color.black);
            g.drawString(this.key, xPos, yPos);
        }
        double offsetWidth = this.drawLegend ? pixWidth - 50 : pixWidth;
        double offset = offsetWidth / (double)(this.allQuartiles.size() + 1);
        if (this.drawLegend) {
            g.translate(50.0, 0.0);
        }
        for (Quartile quartile : this.allQuartiles) {
            g.translate(offset, 0.0);
            this.paintQuartile(g, quartile, pixHeight);
        }
    }

    private void paintQuartile(Graphics2D g, Quartile quartile, int pixHeight) {
        double upperQPos = this.getNormedPosition(quartile.getUpperQuartile(), pixHeight);
        double lowerQPos = this.getNormedPosition(quartile.getLowerQuartile(), pixHeight);
        double quartileHeight = this.getNormedLength(quartile.getUpperQuartile() - quartile.getLowerQuartile(), pixHeight);
        Rectangle2D.Double quartileRect = new Rectangle2D.Double(0.0, upperQPos, 20.0, quartileHeight);
        g.setColor(quartile.getColor());
        g.fill(quartileRect);
        g.setColor(Color.BLACK);
        g.draw(quartileRect);
        double medianPos = this.getNormedPosition(quartile.getMedian(), pixHeight);
        g.draw(new Line2D.Double(0.0, medianPos, 20.0, medianPos));
        double lowerWhiskerPos = this.getNormedPosition(quartile.getLowerWhisker(), pixHeight);
        g.draw(new Line2D.Double(0.0, lowerWhiskerPos, 20.0, lowerWhiskerPos));
        double upperWhiskerPos = this.getNormedPosition(quartile.getUpperWhisker(), pixHeight);
        g.draw(new Line2D.Double(0.0, upperWhiskerPos, 20.0, upperWhiskerPos));
        double whiskersXPos = 10.0;
        g.draw(new Line2D.Double(whiskersXPos, upperQPos, whiskersXPos, upperWhiskerPos));
        g.draw(new Line2D.Double(whiskersXPos, lowerQPos, whiskersXPos, lowerWhiskerPos));
        double meanXPos = 15.0;
        double mean = this.getNormedPosition(quartile.getMean(), pixHeight);
        Rectangle2D.Double meanRect = new Rectangle2D.Double(meanXPos - 2.0, mean - 2.0, 5.0, 5.0);
        g.fill(meanRect);
        double standardDeviation = this.getNormedLength(quartile.getStandardDeviation(), pixHeight);
        g.draw(new Line2D.Double(meanXPos, mean, meanXPos, mean + standardDeviation));
        g.draw(new Line2D.Double(meanXPos, mean, meanXPos, mean - standardDeviation));
        double outlierXPos = 10.0;
        double[] outliers = quartile.getOutliers();
        int i = 0;
        while (i < outliers.length) {
            double outlierYPos = this.getNormedPosition(outliers[i], pixHeight);
            this.drawPoint(g, outlierXPos, outlierYPos, Color.WHITE, Color.BLACK);
            ++i;
        }
    }

    private double getNormedPosition(double value, int pixHeight) {
        return (double)pixHeight - (value - this.globalMin) / (this.globalMax - this.globalMin) * (double)pixHeight;
    }

    private double getNormedLength(double length, int pixHeight) {
        return length / (this.globalMax - this.globalMin) * (double)pixHeight;
    }

    private void drawGrid(Graphics2D g, int pixWidth, int pixHeight) {
        Graphics2D coordinateSpace = (Graphics2D)g.create();
        coordinateSpace.translate(50, 0);
        this.drawGridLines(coordinateSpace, pixWidth - 50, pixHeight);
        coordinateSpace.dispose();
    }

    private void drawGridLines(Graphics2D g, int pixWidth, int pixHeight) {
        DecimalFormat format = new DecimalFormat("0.00E0");
        g.setFont(LABEL_FONT);
        double numberOfYTics = 6.0;
        double yTicSize = (this.globalMax - this.globalMin) / numberOfYTics;
        double ticDifference = (double)pixHeight / numberOfYTics;
        int i = 0;
        while ((double)i <= numberOfYTics) {
            this.drawHorizontalTic(g, i, yTicSize, ticDifference, pixWidth, pixHeight, format);
            ++i;
        }
    }

    private void drawHorizontalTic(Graphics2D g, int ticNumber, double yTicSize, double ticDifference, int pixWidth, int pixHeight, DecimalFormat format) {
        g.setColor(GRID_COLOR);
        double yValue = this.globalMax - (double)ticNumber * yTicSize;
        double yPos = (double)ticNumber * ticDifference;
        g.draw(new Line2D.Double(0.0, yPos, pixWidth, yPos));
        g.setColor(Color.black);
        String label = String.valueOf(format.format(yValue)) + " ";
        Rectangle2D stringBounds = LABEL_FONT.getStringBounds(label, g.getFontRenderContext());
        g.drawString(label, (float)(-stringBounds.getWidth()), (float)(yPos - stringBounds.getHeight() / 2.0 - stringBounds.getY()));
    }
}

