/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.gui.plotter.ColorQuartilePlotter;
import edu.udo.cs.yale.gui.plotter.PlotterAdapter;
import edu.udo.cs.yale.gui.plotter.conditions.ColumnsPlotterCondition;
import edu.udo.cs.yale.gui.plotter.conditions.PlotterCondition;
import edu.udo.cs.yale.tools.LogService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class ColorQuartileMatrixPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = -3049267947471497204L;
    static final int MAX_NUMBER_OF_COLUMNS = 100;
    private ColorQuartilePlotter[] plotters = new ColorQuartilePlotter[0];
    private int plotterSize;
    private int colorIndex = -1;
    private double maxWeight = Double.NaN;
    private transient DataTable dataTable;

    public ColorQuartileMatrixPlotter() {
        this.setBackground(Color.white);
        String sizeProperty = System.getProperty("yale.gui.plotter.matrixplot.size");
        this.plotterSize = 200;
        try {
            if (sizeProperty != null) {
                this.plotterSize = Integer.parseInt(sizeProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.logMessage("Quartile matrix: cannot parse plotter size (was '" + sizeProperty + "'), using default size (200).", 4);
        }
    }

    public ColorQuartileMatrixPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.updateMatrix();
    }

    public PlotterCondition getPlotterCondition() {
        return new ColumnsPlotterCondition(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMatrix() {
        int numberOfPlotters = this.dataTable.getNumberOfColumns();
        if (this.colorIndex != -1) {
            --numberOfPlotters;
        }
        this.plotters = new ColorQuartilePlotter[numberOfPlotters];
        int x = 0;
        DataTable dataTable = this.dataTable;
        synchronized (dataTable) {
            int i = 0;
            while (i < this.dataTable.getNumberOfColumns()) {
                if (i != this.colorIndex) {
                    this.plotters[x] = new ColorQuartilePlotter(this.dataTable);
                    this.plotters[x].getPlotter().setSize(new Dimension(this.plotterSize, this.plotterSize));
                    this.plotters[x].setAxis(0, i);
                    this.plotters[x].setPlotColumn(this.colorIndex, true);
                    this.plotters[x].setDrawLegend(false);
                    this.plotters[x].setKey(this.dataTable.getColumnName(i));
                    ++x;
                }
                ++i;
            }
            this.maxWeight = this.getMaxWeight(this.dataTable);
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getMaxNumberPerRow() * this.plotterSize + 40, this.getMaxNumberPerRow() * this.plotterSize + 40);
    }

    private int getMaxNumberPerRow() {
        return (int)Math.ceil(Math.sqrt(this.plotters.length));
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int xPos = 0;
        int yPos = 0;
        int x = 0;
        while (x < this.plotters.length) {
            if (xPos >= this.getMaxNumberPerRow()) {
                ++yPos;
                xPos = 0;
            }
            Graphics2D newSpace = (Graphics2D)graphics.create();
            newSpace.translate(20 + xPos * this.plotterSize, 20 + yPos * this.plotterSize);
            this.drawWeightRectangle(newSpace, this.dataTable, x, this.maxWeight, this.plotterSize);
            newSpace.translate(7, 7);
            this.plotters[x].paintQuartiles(newSpace, this.plotterSize - 13, this.plotterSize - 13);
            newSpace.dispose();
            ++xPos;
            ++x;
        }
        if (this.colorIndex != -1) {
            this.drawLegend(graphics, this.dataTable, this.colorIndex, 0, 30);
        }
    }

    public String getPlotName() {
        return "Color";
    }

    public void setPlotColumn(int index, boolean plot) {
        this.colorIndex = index;
        this.updateMatrix();
    }

    public boolean getPlotColumn(int index) {
        return index == this.colorIndex;
    }

    public Icon getIcon(int index) {
        return null;
    }
}

