/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.gui.plotter.ScatterPlotter;
import java.awt.Color;
import java.awt.geom.Point2D;

public class ColorPlotterPoint {
    private final ScatterPlotter plotter;
    private String id = null;
    private double x;
    private double y;
    private double color;
    private Color borderColor;

    public ColorPlotterPoint(ScatterPlotter plotter, String id, double x, double y, double color, Color borderColor) {
        this.plotter = plotter;
        this.id = id;
        this.x = x;
        this.y = y;
        this.color = color;
        this.borderColor = borderColor;
    }

    public String getId() {
        return this.id;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public double getColor() {
        return this.color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public boolean contains(int x, int y) {
        Point2D point = this.plotter.transform.transform(new Point2D.Double(this.plotter.xTransformation.transform(this.x), this.plotter.yTransformation.transform(this.y)), null);
        return Math.abs(point.getX() - (double)x) < 2.0 && Math.abs(point.getY() - (double)y) < 2.0;
    }

    public boolean isIn(double minX, double maxX, double minY, double maxY) {
        return this.x >= minX && this.x <= maxX && this.y >= minY && this.y <= maxY;
    }
}

