/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.datatable.DataTableRow;
import edu.udo.cs.yale.gui.plotter.Bins;
import edu.udo.cs.yale.gui.plotter.HistogramPlotter;
import edu.udo.cs.yale.gui.plotter.RectangleStyle;
import edu.udo.cs.yale.tools.LogService;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ColorHistogramPlotter
extends HistogramPlotter {
    private static final long serialVersionUID = -2185573642487757891L;
    private int columnIndex = -1;
    private int colorIndex = -1;

    public ColorHistogramPlotter() {
    }

    public ColorHistogramPlotter(DataTable dataTable) {
        super(dataTable);
    }

    public int getNumberOfAxes() {
        return 1;
    }

    public int getAxis(int axis) {
        return this.columnIndex;
    }

    public String getAxisName(int index) {
        if (index == 0) {
            return "Histogram";
        }
        return "empty";
    }

    public void setAxis(int index, int dimension) {
        if (this.columnIndex != dimension) {
            this.currentXPlotterColumn = this.columnIndex = dimension;
            this.repaint();
        }
    }

    public void setPlotColumn(int index, boolean plot) {
        this.colorIndex = index;
        this.repaint();
    }

    public String getPlotName() {
        return "Color";
    }

    public boolean getPlotColumn(int index) {
        return index == this.colorIndex;
    }

    public int getValuePlotSelectionType() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareData() {
        this.minX = Double.POSITIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        this.allPlots.clear();
        if (this.columnIndex != -1 && this.colorIndex != -1) {
            TreeMap<Double, LinkedList<Double>> valueMap = new TreeMap<Double, LinkedList<Double>>();
            DataTable dataTable = this.dataTable;
            synchronized (dataTable) {
                for (DataTableRow row : this.dataTable) {
                    double columnValue = row.getValue(this.columnIndex);
                    this.minX = Math.min(this.minX, columnValue);
                    this.maxX = Math.max(this.maxX, columnValue);
                    double colorValue = row.getValue(this.colorIndex);
                    LinkedList<Double> values = (LinkedList<Double>)valueMap.get(colorValue);
                    if (values == null) {
                        values = new LinkedList<Double>();
                        values.add(columnValue);
                        valueMap.put(colorValue, values);
                        continue;
                    }
                    values.add(columnValue);
                }
                String maxClassesProperty = System.getProperty("yale.gui.plotter.colors.classlimit");
                int maxClasses = 10;
                try {
                    if (maxClassesProperty != null) {
                        maxClasses = Integer.parseInt(maxClassesProperty);
                    }
                }
                catch (NumberFormatException e) {
                    LogService.logMessage("Color histogram: cannot parse property 'yale.gui.plotter.colors.classlimit', using maximal 10 different classes.", 4);
                }
                if (valueMap.size() <= maxClasses) {
                    for (Map.Entry e : valueMap.entrySet()) {
                        Double key = (Double)e.getKey();
                        int colorValue = (int)key.doubleValue();
                        Color color = ColorHistogramPlotter.getPointColor((double)colorValue / ((double)valueMap.size() - 1.0));
                        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 30);
                        RectangleStyle style = new RectangleStyle(color);
                        Bins bins = new Bins(style, this.minX, this.maxX, this.binNumber);
                        this.allPlots.put(colorValue, bins);
                        List values = (List)e.getValue();
                        Iterator v = values.iterator();
                        while (v.hasNext()) {
                            bins.addPoint((Double)v.next());
                            this.maxY = Math.max((double)bins.getMaxCounter(), this.maxY);
                        }
                    }
                } else {
                    super.prepareData();
                    LogService.logMessage("Color histogram: cannot create colored histogram since the number of different values (" + valueMap.size() + ") is too large. Allowed are " + maxClassesProperty + " different values (edit this limit in the properties dialog).", 4);
                }
            }
        }
        this.maxY = 1.0;
        this.minY = 0.0;
        if (this.dataTable.getNumberOfRows() == 0) {
            this.minX = 0.0;
            this.maxX = 1.0;
            this.minY = 0.0;
            this.maxY = 1.0;
        }
        if (this.minX == this.maxX) {
            this.minX -= 0.5;
            this.maxX += 0.5;
        }
        if (this.minY == this.maxY) {
            this.minY -= 0.5;
            this.maxY += 0.5;
        }
        this.xTicSize = this.getTicSize(this.dataTable, this.columnIndex, this.minX, this.maxX);
        this.yTicSize = this.getNumericalTicSize(this.minY, this.maxY);
        this.minX = Math.floor(this.minX / this.xTicSize) * this.xTicSize;
        this.maxX = Math.ceil(this.maxX / this.xTicSize) * this.xTicSize;
        this.minY = Math.floor(this.minY / this.yTicSize) * this.yTicSize;
        this.maxY = Math.ceil(this.maxY / this.yTicSize) * this.yTicSize;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.drawLegend && this.allPlots.size() > 0) {
            this.drawLegend(g, this.dataTable, this.colorIndex, 50, 30);
        }
    }
}

