/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.plotter;

import edu.udo.cs.yale.gui.plotter.Bin;
import edu.udo.cs.yale.gui.plotter.RectangleStyle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bins {
    private RectangleStyle rectangleStyle;
    private int maxCounter = 0;
    private List<Bin> binList = new LinkedList<Bin>();

    public Bins(int styleIndex, double left, double right, int number) {
        this(new RectangleStyle(styleIndex), left, right, number);
    }

    public Bins(RectangleStyle rectangleStyle, double left, double right, int number) {
        this.rectangleStyle = rectangleStyle;
        double delta = (right - left) / (double)number;
        double start = left;
        int i = 0;
        while (i < number) {
            this.binList.add(new Bin(start, start + delta));
            start += delta;
            ++i;
        }
    }

    public RectangleStyle getRectangleStyle() {
        return this.rectangleStyle;
    }

    public void addPoint(double position) {
        for (Bin bin : this.binList) {
            if (!bin.contains(position)) continue;
            int counter = bin.addPoint();
            this.maxCounter = Math.max(this.maxCounter, counter);
            break;
        }
    }

    public int getMaxCounter() {
        return this.maxCounter;
    }

    public Iterator<Bin> getIterator() {
        return this.binList.iterator();
    }

    public String toString() {
        return this.binList.toString();
    }
}

