/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.operatortree.actions;

import edu.udo.cs.yale.BreakpointListener;
import edu.udo.cs.yale.gui.operatortree.OperatorTree;
import edu.udo.cs.yale.gui.tools.IconSize;
import edu.udo.cs.yale.gui.tools.SwingTools;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;

public class ToggleBreakpointItem
extends JCheckBoxMenuItem
implements ActionListener {
    private static final long serialVersionUID = 1727841552148351670L;
    private static final String UP_ICON_NAME = "breakpoint_up.png";
    private static final String WITHIN_ICON_NAME = "breakpoint.png";
    private static final String DOWN_ICON_NAME = "breakpoint_down.png";
    private static final Icon[] UP_ICONS;
    private static final Icon[] WITHIN_ICONS;
    private static final Icon[] DOWN_ICONS;
    private int position;
    private OperatorTree operatorTree;

    static {
        IconSize size;
        UP_ICONS = new Icon[IconSize.values().length];
        WITHIN_ICONS = new Icon[IconSize.values().length];
        DOWN_ICONS = new Icon[IconSize.values().length];
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = 0;
        int n2 = iconSizeArray.length;
        while (n < n2) {
            size = iconSizeArray[n];
            ToggleBreakpointItem.UP_ICONS[counter++] = SwingTools.createIcon("icons/" + size.getSize() + "/" + UP_ICON_NAME);
            ++n;
        }
        counter = 0;
        iconSizeArray = IconSize.values();
        n = 0;
        n2 = iconSizeArray.length;
        while (n < n2) {
            size = iconSizeArray[n];
            ToggleBreakpointItem.WITHIN_ICONS[counter++] = SwingTools.createIcon("icons/" + size.getSize() + "/" + WITHIN_ICON_NAME);
            ++n;
        }
        counter = 0;
        iconSizeArray = IconSize.values();
        n = 0;
        n2 = iconSizeArray.length;
        while (n < n2) {
            size = iconSizeArray[n];
            ToggleBreakpointItem.DOWN_ICONS[counter++] = SwingTools.createIcon("icons/" + size.getSize() + "/" + DOWN_ICON_NAME);
            ++n;
        }
    }

    public ToggleBreakpointItem(OperatorTree operatorTree, int position, IconSize size) {
        super("Breakpoint " + BreakpointListener.BREAKPOINT_POS_NAME_UPPERCASE[position]);
        this.position = position;
        this.operatorTree = operatorTree;
        this.addActionListener(this);
        this.setToolTipText("Toggle breakpoint " + BreakpointListener.BREAKPOINT_POS_NAME[position] + " for the selected operator");
        switch (position) {
            case 0: {
                this.setMnemonic(66);
                this.setIcon(UP_ICONS[size.ordinal()]);
                break;
            }
            case 1: {
                this.setMnemonic(87);
                this.setIcon(WITHIN_ICONS[size.ordinal()]);
                break;
            }
            case 2: {
                this.setMnemonic(65);
                this.setIcon(DOWN_ICONS[size.ordinal()]);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.operatorTree.toggleBreakpoint(this.position, this.getState());
    }
}

