/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.operatortree.actions;

import edu.udo.cs.yale.gui.ConditionalAction;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.operatortree.OperatorTree;
import edu.udo.cs.yale.gui.templates.BuildingBlock;
import edu.udo.cs.yale.gui.templates.SaveAsBuildingBlockDialog;
import edu.udo.cs.yale.gui.tools.IconSize;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.tools.ParameterService;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;

public class SaveBuildingBlockAction
extends ConditionalAction {
    private static final long serialVersionUID = 2238740826770976483L;
    private static final String ICON_NAME = "box_add.png";
    private static final Icon[] ICONS = new Icon[IconSize.values().length];
    private OperatorTree operatorTree;

    static {
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = 0;
        int n2 = iconSizeArray.length;
        while (n < n2) {
            IconSize size = iconSizeArray[n];
            SaveBuildingBlockAction.ICONS[counter++] = SwingTools.createIcon("icons/" + size.getSize() + "/" + ICON_NAME);
            ++n;
        }
    }

    public SaveBuildingBlockAction(OperatorTree operatorTree, IconSize size) {
        super("Save as Building Block...", ICONS[size.ordinal()]);
        this.putValue("ShortDescription", "Save the selected operator as a new building block");
        this.putValue("MnemonicKey", 83);
        this.setCondition(0, 1);
        this.setCondition(2, -1);
        this.operatorTree = operatorTree;
    }

    public void actionPerformed(ActionEvent e) {
        Operator selectedOperator = this.operatorTree.getSelectedOperator();
        if (selectedOperator != null) {
            SaveAsBuildingBlockDialog dialog = new SaveAsBuildingBlockDialog(YaleGUI.getMainFrame(), selectedOperator);
            dialog.setVisible(true);
            if (dialog.isOk()) {
                BuildingBlock buildingBlock = dialog.getBuildingBlock(selectedOperator);
                String name = buildingBlock.getName();
                try {
                    File buildingBlockFile = ParameterService.getUserConfigFile(String.valueOf(name) + ".buildingblock");
                    buildingBlock.save(buildingBlockFile);
                }
                catch (IOException ioe) {
                    SwingTools.showSimpleErrorMessage("Cannot write building block file:", ioe);
                }
            }
        }
    }
}

