/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.operatortree.actions;

import edu.udo.cs.yale.gui.ConditionalAction;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.operatortree.OperatorTree;
import edu.udo.cs.yale.gui.templates.BuildingBlock;
import edu.udo.cs.yale.gui.templates.NewBuildingBlockDialog;
import edu.udo.cs.yale.gui.tools.IconSize;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import java.awt.event.ActionEvent;
import java.io.StringReader;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class NewBuildingBlockAction
extends ConditionalAction {
    private static final long serialVersionUID = 3466426013029085115L;
    private static final String ICON_NAME = "box_new.png";
    private static final Icon[] ICONS = new Icon[IconSize.values().length];
    private OperatorTree operatorTree;

    static {
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = 0;
        int n2 = iconSizeArray.length;
        while (n < n2) {
            IconSize size = iconSizeArray[n];
            NewBuildingBlockAction.ICONS[counter++] = SwingTools.createIcon("icons/" + size.getSize() + "/" + ICON_NAME);
            ++n;
        }
    }

    public NewBuildingBlockAction(OperatorTree operatorTree, IconSize size) {
        super("New BB...", ICONS[size.ordinal()]);
        this.putValue("ShortDescription", "Insert a new building block");
        this.putValue("MnemonicKey", 66);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 2));
        this.setCondition(1, 1);
        this.operatorTree = operatorTree;
    }

    public void actionPerformed(ActionEvent e) {
        Operator selectedOperator = this.operatorTree.getSelectedOperator();
        if (selectedOperator != null) {
            NewBuildingBlockDialog dialog = new NewBuildingBlockDialog(YaleGUI.getMainFrame());
            dialog.setVisible(true);
            if (dialog.isOk()) {
                try {
                    BuildingBlock buildingBlock = dialog.getSelectedBuildingBlock();
                    if (buildingBlock != null) {
                        String xmlDescription = buildingBlock.getXML();
                        try {
                            InputSource source = new InputSource(new StringReader(xmlDescription));
                            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
                            Element element = document.getDocumentElement();
                            Operator operator = Operator.createFromXML(element);
                            YaleGUI.getMainFrame().getOperatorTree().insert(operator);
                        }
                        catch (Exception ex) {
                            SwingTools.showErrorMessage("Cannot instantiate building block '" + buildingBlock.getName() + "'.", ex);
                        }
                    }
                }
                catch (Exception ex) {
                    SwingTools.showSimpleErrorMessage("Cannot create building block:", ex);
                }
            }
        }
    }
}

