/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.operatortree;

import edu.udo.cs.yale.gui.operatortree.OperatorTree;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Polygon;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public class OperatorTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -8256080174651447518L;
    private OperatorPanel operatorPanel = new OperatorPanel();

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof Operator) {
            this.operatorPanel.updateOperator(tree, (Operator)value, selected, hasFocus);
            return this.operatorPanel;
        }
        JLabel label = new JLabel(value.toString());
        label.setEnabled(tree.isEnabled());
        return label;
    }

    private static class OperatorPanel
    extends JPanel {
        private static final String BREAKPOINT_BEFORE = "icons/24/breakpoint_up.png";
        private static final String BREAKPOINT_AFTER = "icons/24/breakpoint_down.png";
        private static final String BREAKPOINT_WITHIN = "icons/24/breakpoint.png";
        private static final String BREAKPOINTS = "icons/24/breakpoints.png";
        private static final String WARNINGS = "icons/24/warning.png";
        private static final long serialVersionUID = -7680223153786362865L;
        private static final Color SELECTED_COLOR = UIManager.getColor("Tree.selectionBackground");
        private static final Color BORDER_SELECTED_COLOR = UIManager.getColor("Tree.selectionBorderColor");
        private static final Color TEXT_SELECTED_COLOR = UIManager.getColor("Tree.selectionForeground");
        private static final Color TEXT_NON_SELECTED_COLOR = UIManager.getColor("Tree.textForeground");
        private static Icon breakpointBeforeIcon = null;
        private static Icon breakpointAfterIcon = null;
        private static Icon breakpointWithinIcon = null;
        private static Icon breakpointsIcon = null;
        private static Icon warningsIcon = null;
        private JLabel iconLabel = new JLabel("");
        private JLabel nameLabel = new JLabel("");
        private JLabel classLabel = new JLabel("");
        private JLabel breakpoint = new JLabel("");
        private JLabel error = new JLabel("");
        private boolean isSelected = false;
        private boolean hasFocus = false;
        private int dndMarker;
        private int[] downArrowXPoints;
        private int[] downArrowYPoints;
        private int[] upArrowXPoints;
        private int[] upArrowYPoints;
        private Polygon upArrow;
        private Polygon downArrow;

        static {
            breakpointBeforeIcon = SwingTools.createIcon(BREAKPOINT_BEFORE);
            breakpointAfterIcon = SwingTools.createIcon(BREAKPOINT_AFTER);
            breakpointWithinIcon = SwingTools.createIcon(BREAKPOINT_WITHIN);
            breakpointsIcon = SwingTools.createIcon(BREAKPOINTS);
            warningsIcon = SwingTools.createIcon(WARNINGS);
        }

        public OperatorPanel() {
            int[] nArray = new int[7];
            nArray[0] = 4;
            nArray[1] = 4;
            nArray[2] = 6;
            nArray[3] = 3;
            nArray[5] = 2;
            nArray[6] = 2;
            this.downArrowXPoints = nArray;
            int[] nArray2 = new int[7];
            nArray2[1] = 4;
            nArray2[2] = 4;
            nArray2[3] = 7;
            nArray2[4] = 4;
            nArray2[5] = 4;
            this.downArrowYPoints = nArray2;
            int[] nArray3 = new int[7];
            nArray3[0] = 3;
            nArray3[1] = 6;
            nArray3[2] = 4;
            nArray3[3] = 4;
            nArray3[4] = 2;
            nArray3[5] = 2;
            this.upArrowXPoints = nArray3;
            int[] nArray4 = new int[7];
            nArray4[1] = 3;
            nArray4[2] = 3;
            nArray4[3] = 7;
            nArray4[4] = 7;
            nArray4[5] = 3;
            nArray4[6] = 3;
            this.upArrowYPoints = nArray4;
            this.upArrow = new Polygon(this.upArrowXPoints, this.upArrowYPoints, 7);
            this.downArrow = new Polygon(this.downArrowXPoints, this.downArrowYPoints, 7);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 0.0;
            layout.setConstraints(this.iconLabel, c);
            this.add(this.iconLabel);
            JPanel namePanel = new JPanel();
            namePanel.setBackground(new Color(0, 0, 0, 0));
            GridBagLayout nameLayout = new GridBagLayout();
            GridBagConstraints nameC = new GridBagConstraints();
            nameC.fill = 1;
            nameC.insets = new Insets(1, 1, 1, 1);
            namePanel.setLayout(nameLayout);
            this.nameLabel.setHorizontalAlignment(2);
            this.nameLabel.setFont(this.getFont().deriveFont(0, 12.0f));
            this.nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            nameC.gridwidth = 0;
            nameLayout.setConstraints(this.nameLabel, nameC);
            namePanel.add(this.nameLabel);
            this.classLabel.setHorizontalAlignment(2);
            this.classLabel.setFont(this.getFont().deriveFont(0, 10.0f));
            this.classLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            nameLayout.setConstraints(this.classLabel, nameC);
            namePanel.add(this.classLabel);
            c.weightx = 1.0;
            layout.setConstraints(namePanel, c);
            this.add(namePanel);
            c.gridwidth = -1;
            c.weightx = 0.0;
            layout.setConstraints(this.breakpoint, c);
            this.add(this.breakpoint);
            c.gridwidth = 0;
            layout.setConstraints(this.error, c);
            this.add(this.error);
        }

        public void updateOperator(JTree tree, Operator operator, boolean selected, boolean focus) {
            this.isSelected = selected;
            this.hasFocus = focus;
            if (selected) {
                this.nameLabel.setForeground(TEXT_SELECTED_COLOR);
                this.classLabel.setForeground(TEXT_SELECTED_COLOR);
            } else {
                this.nameLabel.setForeground(TEXT_NON_SELECTED_COLOR);
                this.classLabel.setForeground(TEXT_NON_SELECTED_COLOR);
            }
            this.dndMarker = ((OperatorTree)tree).getAssociatedDnDSupport().getOperatorMarker(operator.getName());
            OperatorDescription descr = operator.getOperatorDescription();
            Image img = descr.getIcon();
            if (img != null) {
                this.iconLabel.setIcon(new ImageIcon(img));
            } else {
                this.iconLabel.setIcon(null);
            }
            this.iconLabel.setEnabled(operator.isEnabled());
            this.nameLabel.setText(operator.getName());
            this.nameLabel.setEnabled(operator.isEnabled());
            this.classLabel.setText(descr.getName());
            this.classLabel.setEnabled(operator.isEnabled());
            if (operator.hasBreakpoint(0)) {
                this.breakpoint.setIcon(breakpointBeforeIcon);
            } else if (operator.hasBreakpoint(2)) {
                this.breakpoint.setIcon(breakpointAfterIcon);
            } else if (operator.hasBreakpoint(1)) {
                this.breakpoint.setIcon(breakpointWithinIcon);
            } else {
                this.breakpoint.setIcon(null);
            }
            if (operator.hasBreakpoint(0) && operator.hasBreakpoint(2) || operator.hasBreakpoint(0) && operator.hasBreakpoint(1) || operator.hasBreakpoint(1) && operator.hasBreakpoint(2)) {
                this.breakpoint.setIcon(breakpointsIcon);
            }
            this.breakpoint.setEnabled(operator.isEnabled());
            List errors = operator.getErrorList();
            if (errors.size() > 0) {
                this.error.setIcon(warningsIcon);
                this.setToolTipText(SwingTools.transformToolTipText("Error: " + (String)errors.get(0)));
            } else {
                this.error.setIcon(null);
                this.setToolTipText(SwingTools.transformToolTipText(descr.getDescription()));
            }
            this.error.setEnabled(operator.isEnabled());
            this.setEnabled(operator.isEnabled());
        }

        private void paintUpperDropline(Graphics graphics) {
            Graphics g = graphics.create();
            g.setColor(SwingTools.LIGHT_BLUE);
            g.fillRect(0, 0, this.getWidth() - 1, 2);
            g.setColor(SwingTools.DARK_BLUE);
            g.drawRect(0, 0, this.getWidth() - 1, 2);
            g.translate(1, 3);
            g.setColor(SwingTools.LIGHT_BLUE);
            g.fillPolygon(this.upArrow);
            g.setColor(SwingTools.DARK_BLUE);
            g.drawPolygon(this.upArrow);
            g.translate(this.getWidth() - 10, 0);
            g.setColor(SwingTools.LIGHT_BLUE);
            g.fillPolygon(this.upArrow);
            g.setColor(SwingTools.DARK_BLUE);
            g.drawPolygon(this.upArrow);
            g.dispose();
        }

        private void paintLowerDropline(Graphics graphics) {
            Graphics g = graphics.create();
            g.setColor(SwingTools.LIGHT_BLUE);
            g.fillRect(0, this.getHeight() - 3, this.getWidth() - 1, 2);
            g.setColor(SwingTools.DARK_BLUE);
            g.drawRect(0, this.getHeight() - 3, this.getWidth() - 1, 2);
            g.translate(1, this.getHeight() - 11);
            g.setColor(SwingTools.LIGHT_BLUE);
            g.fillPolygon(this.downArrow);
            g.setColor(SwingTools.DARK_BLUE);
            g.drawPolygon(this.downArrow);
            g.translate(this.getWidth() - 10, 0);
            g.setColor(SwingTools.LIGHT_BLUE);
            g.fillPolygon(this.downArrow);
            g.setColor(SwingTools.DARK_BLUE);
            g.drawPolygon(this.downArrow);
            g.dispose();
        }

        public void paint(Graphics g) {
            if (this.isSelected) {
                g.setColor(SELECTED_COLOR);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.hasFocus) {
                g.setColor(BORDER_SELECTED_COLOR);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            if (this.dndMarker == 0) {
                g.setColor(BORDER_SELECTED_COLOR);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            if (this.dndMarker == 1) {
                this.paintUpperDropline(g);
            }
            if (this.dndMarker == 2) {
                this.paintLowerDropline(g);
            }
            super.paint(g);
        }
    }
}

