/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.operatortree;

import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.dialog.OperatorInfoScreen;
import edu.udo.cs.yale.gui.operatormenu.OperatorMenu;
import edu.udo.cs.yale.gui.operatortree.DnDSupport;
import edu.udo.cs.yale.gui.operatortree.OperatorTreeCellEditor;
import edu.udo.cs.yale.gui.operatortree.OperatorTreeCellRenderer;
import edu.udo.cs.yale.gui.operatortree.OperatorTreeModel;
import edu.udo.cs.yale.gui.operatortree.actions.AddAllBreakpointsAction;
import edu.udo.cs.yale.gui.operatortree.actions.CollapseAllAction;
import edu.udo.cs.yale.gui.operatortree.actions.CopyAction;
import edu.udo.cs.yale.gui.operatortree.actions.CutAction;
import edu.udo.cs.yale.gui.operatortree.actions.DeleteOperatorAction;
import edu.udo.cs.yale.gui.operatortree.actions.ExpandAllAction;
import edu.udo.cs.yale.gui.operatortree.actions.InfoOperatorAction;
import edu.udo.cs.yale.gui.operatortree.actions.NewBuildingBlockAction;
import edu.udo.cs.yale.gui.operatortree.actions.NewOperatorAction;
import edu.udo.cs.yale.gui.operatortree.actions.PasteAction;
import edu.udo.cs.yale.gui.operatortree.actions.RemoveAllBreakpointsAction;
import edu.udo.cs.yale.gui.operatortree.actions.RenameOperatorAction;
import edu.udo.cs.yale.gui.operatortree.actions.SaveBuildingBlockAction;
import edu.udo.cs.yale.gui.operatortree.actions.ToggleActivationItem;
import edu.udo.cs.yale.gui.operatortree.actions.ToggleBreakpointItem;
import edu.udo.cs.yale.gui.operatortree.actions.ToggleShowDisabledItem;
import edu.udo.cs.yale.gui.templates.NewBuildingBlockMenu;
import edu.udo.cs.yale.gui.tools.IconSize;
import edu.udo.cs.yale.operator.ExperimentOperator;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import java.awt.Frame;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class OperatorTree
extends JTree
implements TreeSelectionListener,
MouseListener {
    private static final long serialVersionUID = -6934683725946634563L;
    public final Action NEW_OPERATOR_ACTION_24 = new NewOperatorAction(this, IconSize.SMALL);
    public final Action NEW_OPERATOR_ACTION_32 = new NewOperatorAction(this, IconSize.MIDDLE);
    public final Action NEW_BUILDING_BLOCK_ACTION_24 = new NewBuildingBlockAction(this, IconSize.SMALL);
    public final Action NEW_BUILDING_BLOCK_ACTION_32 = new NewBuildingBlockAction(this, IconSize.MIDDLE);
    public final Action CUT_ACTION_24 = new CutAction(this, IconSize.SMALL);
    public final Action CUT_ACTION_32 = new CutAction(this, IconSize.MIDDLE);
    public final Action COPY_ACTION_24 = new CopyAction(this, IconSize.SMALL);
    public final Action COPY_ACTION_32 = new CopyAction(this, IconSize.MIDDLE);
    public final Action PASTE_ACTION_24 = new PasteAction(this, IconSize.SMALL);
    public final Action PASTE_ACTION_32 = new PasteAction(this, IconSize.MIDDLE);
    public final Action DELETE_OPERATOR_ACTION_24 = new DeleteOperatorAction(this, IconSize.SMALL);
    public final Action DELETE_OPERATOR_ACTION_32 = new DeleteOperatorAction(this, IconSize.MIDDLE);
    public final Action RENAME_OPERATOR_ACTION_24 = new RenameOperatorAction(this, IconSize.SMALL);
    public final Action RENAME_OPERATOR_ACTION_32 = new RenameOperatorAction(this, IconSize.MIDDLE);
    public final Action INFO_OPERATOR_ACTION_24 = new InfoOperatorAction(this, IconSize.SMALL);
    public final Action INFO_OPERATOR_ACTION_32 = new InfoOperatorAction(this, IconSize.MIDDLE);
    public final Action SAVE_BUILDING_BLOCK_ACTION_24 = new SaveBuildingBlockAction(this, IconSize.SMALL);
    public final Action SAVE_BUILDING_BLOCK_ACTION_32 = new SaveBuildingBlockAction(this, IconSize.MIDDLE);
    public final ToggleBreakpointItem[] TOGGLE_BREAKPOINT = new ToggleBreakpointItem[]{new ToggleBreakpointItem(this, 0, IconSize.SMALL), new ToggleBreakpointItem(this, 1, IconSize.SMALL), new ToggleBreakpointItem(this, 2, IconSize.SMALL)};
    public final ToggleShowDisabledItem TOGGLE_SHOW_DISABLED = new ToggleShowDisabledItem(this, true);
    public final Action ADD_ALL_BREAKPOINTS_24 = new AddAllBreakpointsAction(this, IconSize.SMALL);
    public final Action ADD_ALL_BREAKPOINTS_32 = new AddAllBreakpointsAction(this, IconSize.MIDDLE);
    public final Action REMOVE_ALL_BREAKPOINTS_24 = new RemoveAllBreakpointsAction(this, IconSize.SMALL);
    public final Action REMOVE_ALL_BREAKPOINTS_32 = new RemoveAllBreakpointsAction(this, IconSize.MIDDLE);
    public final Action EXPAND_ALL_ACTION_24 = new ExpandAllAction(this, IconSize.SMALL);
    public final Action EXPAND_ALL_ACTION_32 = new ExpandAllAction(this, IconSize.MIDDLE);
    public final Action COLLAPSE_ALL_ACTION_24 = new CollapseAllAction(this, IconSize.SMALL);
    public final Action COLLAPSE_ALL_ACTION_32 = new CollapseAllAction(this, IconSize.MIDDLE);
    private MainFrame mainFrame;
    private transient OperatorTreeModel treeModel;
    private transient Operator clipBoard = null;
    private DragSource dragSource;
    private transient DnDSupport associatedDnDSupport;

    public OperatorTree(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.getInputMap().put(KeyStroke.getKeyStroke(88, 2), this.CUT_ACTION_24);
        this.getInputMap().put(KeyStroke.getKeyStroke(67, 2), this.COPY_ACTION_24);
        this.getInputMap().put(KeyStroke.getKeyStroke(86, 2), this.PASTE_ACTION_24);
        this.associatedDnDSupport = new DnDSupport(this);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this.associatedDnDSupport);
        new DropTarget(this, 2, this.associatedDnDSupport, true);
        this.setCellRenderer(new OperatorTreeCellRenderer());
        this.setCellEditor(new OperatorTreeCellEditor(this));
        this.setEditable(true);
        this.setShowsRootHandles(true);
        this.addTreeSelectionListener(this);
        this.addMouseListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setToggleClickCount(5);
        this.setRowHeight(0);
    }

    public Object readResolve() {
        this.treeModel = new OperatorTreeModel(null, this);
        this.clipBoard = null;
        this.associatedDnDSupport = new DnDSupport(this);
        return this;
    }

    public DnDSupport getAssociatedDnDSupport() {
        return this.associatedDnDSupport;
    }

    public void setOperator(Operator root) {
        boolean showDisabled = this.treeModel != null ? this.treeModel.showDisabledOperators() : true;
        this.treeModel = new OperatorTreeModel(root, this);
        this.treeModel.setShowDisabledOperators(showDisabled);
        this.setModel(this.treeModel);
        this.setRootVisible(true);
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i);
            ++i;
        }
    }

    public Operator getSelectedOperator() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (Operator)path.getLastPathComponent();
    }

    public Operator getClipBoard() {
        return this.clipBoard;
    }

    public void expandAll() {
        int row = 0;
        while (row < this.getRowCount()) {
            this.expandRow(row);
            ++row;
        }
    }

    public void collapseAll() {
        int row = this.getRowCount() - 1;
        while (row >= 0) {
            this.collapseRow(row);
            --row;
        }
    }

    public void completeRefresh() {
        this.treeModel.fireStructureChanged(this, new TreePath(this.treeModel.getRoot()));
        this.expandAll();
    }

    public void refresh() {
        this.refresh(new TreePath(this.treeModel.getRoot()));
    }

    public void refresh(TreePath path) {
        this.treeModel.fireOperatorChanged(this, path);
        Object object = path.getLastPathComponent();
        int numberOfChildren = this.treeModel.getChildCount(object);
        int i = 0;
        while (i < numberOfChildren) {
            Object child = this.treeModel.getChild(object, i);
            this.refresh(path.pathByAddingChild(child));
            ++i;
        }
    }

    public void cut() {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator != null) {
            this.clipBoard = selectedOperator;
            this.delete();
            this.mainFrame.enableActions();
        }
    }

    public void copy() {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator != null) {
            this.clipBoard = selectedOperator.cloneOperator(selectedOperator.getName());
            this.mainFrame.enableActions();
        }
    }

    public void paste() {
        if (this.clipBoard != null) {
            this.insert(this.clipBoard);
        }
        this.clipBoard = null;
        this.mainFrame.enableActions();
    }

    public void delete() {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator == null) {
            return;
        }
        int index = this.treeModel.getIndexOfChild(selectedOperator.getParent(), selectedOperator);
        selectedOperator.remove();
        this.treeModel.fireOperatorRemoved(this, this.getSelectionPath().getParentPath(), index, selectedOperator);
        this.mainFrame.experimentChanged();
        this.mainFrame.enableActions();
    }

    public void insert(Operator newOperator) {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator == null) {
            return;
        }
        if (selectedOperator instanceof OperatorChain) {
            int index = ((OperatorChain)selectedOperator).addOperator(newOperator);
            this.treeModel.fireOperatorInserted(this, this.getSelectionPath(), index, newOperator);
            this.scrollPathToVisible(this.getSelectionPath().pathByAddingChild(newOperator));
            this.mainFrame.experimentChanged();
        }
    }

    public void renameOperator() {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            this.startEditingAtPath(path);
        }
    }

    public void replace(Operator operator) {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator == null) {
            return;
        }
        OperatorChain parent = selectedOperator.getParent();
        if (parent == null) {
            return;
        }
        int oldPos = this.treeModel.getIndexOfChild(parent, selectedOperator);
        if (selectedOperator instanceof OperatorChain && operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)selectedOperator;
            OperatorChain newChain = (OperatorChain)operator;
            while (chain.getNumberOfAllOperators() > 0) {
                Operator child = chain.getOperatorFromAll(0);
                chain.removeOperator(child);
                newChain.addOperator(child);
            }
        }
        selectedOperator.remove();
        parent.addOperator(operator, oldPos);
        TreePath path = this.getSelectionPath().getParentPath();
        this.treeModel.fireStructureChanged(this, path);
        this.setSelectionPath(path.pathByAddingChild(operator));
        this.mainFrame.experimentChanged();
    }

    public void showOperatorInfo() {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator != null) {
            OperatorInfoScreen infoScreen = new OperatorInfoScreen((Frame)this.mainFrame, selectedOperator);
            infoScreen.setVisible(true);
        }
    }

    public void addAllBreakpoints() {
        this.addAllBreakpoints((Operator)this.treeModel.getRoot());
        this.refresh();
    }

    private void addAllBreakpoints(Operator operator) {
        operator.setBreakpoint(0, false);
        operator.setBreakpoint(1, false);
        operator.setBreakpoint(2, true);
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            int i = 0;
            while (i < chain.getNumberOfOperators()) {
                this.addAllBreakpoints(chain.getOperator(i));
                ++i;
            }
        }
    }

    public void removeAllBreakpoints() {
        this.removeAllBreakpoints((Operator)this.treeModel.getRoot());
        this.refresh();
    }

    private void removeAllBreakpoints(Operator operator) {
        operator.setBreakpoint(0, false);
        operator.setBreakpoint(1, false);
        operator.setBreakpoint(2, false);
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            int i = 0;
            while (i < chain.getNumberOfOperators()) {
                this.removeAllBreakpoints(chain.getOperator(i));
                ++i;
            }
        }
    }

    public void toggleOperatorActivation(boolean state) {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator != null) {
            selectedOperator.setEnabled(state);
            this.completeRefresh();
            this.mainFrame.experimentChanged();
        }
    }

    public void toggleShowDisabledOperators() {
        this.treeModel.setShowDisabledOperators(!this.treeModel.showDisabledOperators());
        this.completeRefresh();
    }

    public void toggleBreakpoint(int position, boolean state) {
        Operator selectedOperator = this.getSelectedOperator();
        if (selectedOperator != null) {
            selectedOperator.setBreakpoint(position, state);
            this.TOGGLE_BREAKPOINT[position].setSelected(state);
            this.refresh();
            this.mainFrame.experimentChanged();
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        Operator selectedOperator = this.getSelectedOperator();
        this.mainFrame.getPropertyTable().editingStopped(new ChangeEvent(this));
        this.mainFrame.getMainExperimentEditor().changeFromNewOperator2ParameterEditor();
        this.mainFrame.notifyEditorsOfChange(selectedOperator);
        if (selectedOperator == null) {
            return;
        }
        this.mainFrame.enableActions();
        int i = 0;
        while (i < this.TOGGLE_BREAKPOINT.length) {
            this.TOGGLE_BREAKPOINT[i].setState(selectedOperator.hasBreakpoint(i));
            ++i;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int selRow = this.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.getPathForLocation(e.getX(), e.getY());
        if (selRow != -1) {
            if (e.getClickCount() == 1) {
                this.evaluateSingleClick(selRow, selPath);
            } else if (e.getClickCount() == 2) {
                this.evaluateDoubleClick(selRow, selPath);
            }
        }
        this.evaluatePopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.evaluatePopup(e);
    }

    private void evaluateSingleClick(int row, TreePath path) {
        this.setSelectionPath(path);
        this.mainFrame.enableActions();
    }

    private void evaluateDoubleClick(int row, TreePath path) {
        this.setSelectionPath(path);
        if (this.getSelectedOperator().hasBreakpoint()) {
            this.toggleBreakpoint(0, false);
            this.toggleBreakpoint(1, false);
            this.toggleBreakpoint(2, false);
        } else {
            this.toggleBreakpoint(2, true);
        }
    }

    private void evaluatePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.createOperatorPopupMenu().show(this, e.getX(), e.getY());
        }
    }

    public void addOperatorMenuItems(JMenu menu) {
        menu.add(this.RENAME_OPERATOR_ACTION_24);
        menu.add(this.COPY_ACTION_24);
        menu.add(this.CUT_ACTION_24);
        menu.add(this.PASTE_ACTION_24);
        menu.add(this.DELETE_OPERATOR_ACTION_24);
        menu.addSeparator();
        menu.add(this.SAVE_BUILDING_BLOCK_ACTION_24);
    }

    private JPopupMenu createOperatorPopupMenu() {
        Operator op = this.getSelectedOperator();
        JPopupMenu menu = new JPopupMenu();
        if (op != null && op instanceof OperatorChain) {
            menu.add(OperatorMenu.NEW_OPERATOR_MENU);
        }
        if (op != null && !(op instanceof ExperimentOperator)) {
            if (op instanceof OperatorChain && ((OperatorChain)op).getNumberOfAllOperators() > 0) {
                menu.add(OperatorMenu.REPLACE_OPERATORCHAIN_MENU);
            } else {
                menu.add(OperatorMenu.REPLACE_OPERATOR_MENU);
            }
        }
        if (op != null && op instanceof OperatorChain) {
            final NewBuildingBlockMenu buildingBlockMenu = new NewBuildingBlockMenu();
            menu.add(buildingBlockMenu);
            buildingBlockMenu.addMenuListener(new MenuListener(){

                public void menuCanceled(MenuEvent e) {
                }

                public void menuDeselected(MenuEvent e) {
                }

                public void menuSelected(MenuEvent e) {
                    buildingBlockMenu.addAllMenuItems();
                }
            });
        }
        menu.add(this.SAVE_BUILDING_BLOCK_ACTION_24);
        menu.addSeparator();
        menu.add(this.RENAME_OPERATOR_ACTION_24);
        menu.add(this.DELETE_OPERATOR_ACTION_24);
        menu.add(this.COPY_ACTION_24);
        menu.add(this.CUT_ACTION_24);
        menu.add(this.PASTE_ACTION_24);
        menu.addSeparator();
        menu.add(this.INFO_OPERATOR_ACTION_24);
        menu.addSeparator();
        int i = 0;
        while (i < this.TOGGLE_BREAKPOINT.length) {
            menu.add(this.TOGGLE_BREAKPOINT[i]);
            ++i;
        }
        menu.add(this.ADD_ALL_BREAKPOINTS_24);
        menu.add(this.REMOVE_ALL_BREAKPOINTS_24);
        menu.addSeparator();
        menu.add(this.EXPAND_ALL_ACTION_24);
        menu.add(this.COLLAPSE_ALL_ACTION_24);
        menu.addSeparator();
        if (op != null && !(op instanceof ExperimentOperator)) {
            ToggleActivationItem activationItem = new ToggleActivationItem(this, op.isEnabled());
            if (op.getParent() != null && !op.getParent().isEnabled()) {
                activationItem.setEnabled(false);
            }
            menu.add(activationItem);
        }
        menu.add(this.TOGGLE_SHOW_DISABLED);
        return menu;
    }
}

