/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.operatortree;

import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.operatortree.OperatorTree;
import edu.udo.cs.yale.gui.operatortree.OperatorTreeModel;
import edu.udo.cs.yale.gui.operatortree.TransferableOperator;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.Timer;
import javax.swing.tree.TreePath;

public class DnDSupport
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private OperatorTree operatorTree;
    private Point previousCursorLocation = new Point();
    private Point currentCursorLocation;
    private Point operatorPosition;
    private static String[] markedOperator = new String[3];
    private int previousDnDMarker = 0;
    private int currentDnDMarker = 0;
    private boolean changeHappened;
    public static final int fullMarker = 0;
    public static final int upperMarker = 1;
    public static final int lowerMarker = 2;
    private TreePath originPath;
    private TreePath currentPath;
    private TreePath previousPath;
    private Timer nodeExpandDelay;
    private final Integer[] myDnDActions = new Integer[]{1, 2, 3};
    private final List acceptedDnDActions = Arrays.asList(this.myDnDActions);

    public DnDSupport(OperatorTree tree) {
        this.operatorTree = tree;
        this.setupNodeExpandTimer();
    }

    public static void setMarkedOperator(String[] marked) {
        markedOperator = marked;
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (!this.dragAllowed(e)) {
            e.rejectDrag();
            return;
        }
        this.previousCursorLocation = e.getLocation();
        e.acceptDrag(e.getDropAction());
    }

    public void drop(DropTargetDropEvent e) {
        int indexInsert;
        DataFlavor[] currentFlavors = TransferableOperator.DATA_FLAVORS;
        DataFlavor acceptedFlavor = null;
        if (!e.isLocalTransfer()) {
            acceptedFlavor = TransferableOperator.TRANSFERRED_OPERATOR_FLAVOR;
        } else {
            int i = 0;
            while (i < currentFlavors.length) {
                if (e.isDataFlavorSupported(currentFlavors[i])) {
                    acceptedFlavor = currentFlavors[i];
                    break;
                }
                ++i;
            }
        }
        if (acceptedFlavor == null) {
            e.rejectDrop();
            return;
        }
        if (!this.acceptedDnDActions.contains(e.getDropAction())) {
            e.rejectDrop();
            return;
        }
        Transferable receivedOperator = null;
        Operator newOperator = null;
        try {
            e.acceptDrop(e.getDropAction());
            receivedOperator = e.getTransferable();
            if (receivedOperator == null) {
                throw new NullPointerException();
            }
            newOperator = receivedOperator.getTransferData(acceptedFlavor) instanceof Operator ? (Operator)receivedOperator.getTransferData(acceptedFlavor) : null;
        }
        catch (Throwable t) {
            t.printStackTrace();
            e.dropComplete(false);
            return;
        }
        Point dropLocation = e.getLocation();
        TreePath dropLocationPath = this.operatorTree.getClosestPathForLocation(dropLocation.x, dropLocation.y);
        if (dropLocationPath == null) {
            e.dropComplete(false);
            return;
        }
        Operator targetOperator = (Operator)dropLocationPath.getLastPathComponent();
        if (targetOperator == null) {
            e.dropComplete(false);
            return;
        }
        boolean notDownDrag = true;
        if (targetOperator.equals(newOperator)) {
            notDownDrag = false;
        }
        for (OperatorChain moveUP = targetOperator.getParent(); moveUP != null; moveUP = moveUP.getParent()) {
            if (!moveUP.equals(newOperator)) continue;
            notDownDrag = false;
        }
        if (notDownDrag) {
            if (e.getDropAction() == 2) {
                int indexDelete = newOperator.getParent().getIndexOfOperator(newOperator, true);
                TreePath oldLocation = this.originPath.getParentPath();
                newOperator.remove();
                ((OperatorTreeModel)this.operatorTree.getModel()).fireOperatorRemoved(this, oldLocation, indexDelete, newOperator);
            } else if (e.getDropAction() == 1) {
                newOperator = newOperator.cloneOperator(newOperator.getName());
            }
            int indexOfTargetOperator = 0;
            OperatorChain newParentOperator = null;
            if (targetOperator.getParent() != null) {
                indexOfTargetOperator = targetOperator.getParent().getIndexOfOperator(targetOperator, true);
                newParentOperator = targetOperator.getParent();
            }
            int droplineIndicator = this.getOperatorMarker(targetOperator.getName());
            indexInsert = 0;
            if (droplineIndicator < 0) {
                e.dropComplete(false);
                return;
            }
            if (droplineIndicator == 0 || droplineIndicator > 2) {
                indexInsert = ((OperatorChain)targetOperator).addOperator(newOperator);
            }
            if (droplineIndicator == 1) {
                if (indexOfTargetOperator >= 0) {
                    indexInsert = indexOfTargetOperator;
                }
                newParentOperator.addOperator(newOperator, indexInsert);
                dropLocationPath = dropLocationPath.getParentPath();
            }
            if (droplineIndicator == 2) {
                if (indexOfTargetOperator < newParentOperator.getNumberOfAllOperators()) {
                    indexInsert = indexOfTargetOperator + 1;
                }
                newParentOperator.addOperator(newOperator, indexInsert);
                dropLocationPath = dropLocationPath.getParentPath();
            }
        } else {
            e.dropComplete(true);
            return;
        }
        ((OperatorTreeModel)this.operatorTree.getModel()).fireOperatorInserted(this, dropLocationPath, indexInsert, newOperator);
        this.operatorTree.scrollPathToVisible(dropLocationPath.pathByAddingChild(newOperator));
        YaleGUI.getMainFrame().experimentChanged();
        this.clearOperatorMarker();
        e.dropComplete(true);
    }

    public void dragOver(DropTargetDragEvent e) {
        if (!this.dragAllowed(e)) {
            e.rejectDrag();
            return;
        }
        this.currentCursorLocation = e.getLocation();
        if (!this.currentCursorLocation.equals(this.previousCursorLocation)) {
            Operator currentDropZone;
            this.currentPath = this.operatorTree.getClosestPathForLocation(this.currentCursorLocation.x, this.currentCursorLocation.y);
            Rectangle dropActionTriggerArea = this.operatorTree.getPathBounds(this.currentPath);
            if (dropActionTriggerArea != null && (currentDropZone = (Operator)this.currentPath.getLastPathComponent()) != null) {
                this.operatorPosition = this.operatorTree.getPathBounds(this.currentPath).getLocation();
                double operatorHeight = this.operatorTree.getPathBounds(this.currentPath).getHeight();
                long aQuarter = Math.round(operatorHeight / 4.0);
                long aHalf = Math.round(operatorHeight / 2.0);
                boolean dropTargetIsOperatorChain = currentDropZone instanceof OperatorChain;
                long currentPartition = dropTargetIsOperatorChain ? aQuarter : aHalf;
                String[] cleanMarkedOperator = new String[]{"", "", ""};
                DnDSupport.setMarkedOperator(cleanMarkedOperator);
                if (currentDropZone.getParent() != null) {
                    if ((long)this.currentCursorLocation.y < (long)this.operatorPosition.y + currentPartition) {
                        DnDSupport.markedOperator[1] = currentDropZone.getName();
                        this.currentDnDMarker = 1;
                    }
                    if ((double)this.currentCursorLocation.y > (double)this.operatorPosition.y + operatorHeight - (double)currentPartition) {
                        DnDSupport.markedOperator[2] = currentDropZone.getName();
                        this.currentDnDMarker = 2;
                    }
                }
                if (dropTargetIsOperatorChain && ((long)this.currentCursorLocation.y >= (long)this.operatorPosition.y + aQuarter && (double)this.currentCursorLocation.y <= (double)this.operatorPosition.y + operatorHeight - (double)aQuarter || currentDropZone.getParent() == null)) {
                    DnDSupport.markedOperator[0] = currentDropZone.getName();
                    this.currentDnDMarker = 0;
                    this.nodeExpandDelay.restart();
                }
                if (this.previousDnDMarker != this.currentDnDMarker || this.previousPath != this.currentPath) {
                    this.changeHappened = true;
                }
                if (this.changeHappened) {
                    this.operatorTree.treeDidChange();
                }
                this.changeHappened = false;
                this.previousDnDMarker = this.currentDnDMarker;
                this.previousPath = this.currentPath;
                this.operatorTree.treeDidChange();
            }
            Insets insets = new Insets(40, 40, 40, 40);
            Rectangle currentlyVisible = this.operatorTree.getVisibleRect();
            Rectangle validCursorArea = new Rectangle(currentlyVisible.x + insets.left, currentlyVisible.y + insets.top, currentlyVisible.width - (insets.left + insets.right), currentlyVisible.height - (insets.top + insets.bottom));
            if (!validCursorArea.contains(this.currentCursorLocation)) {
                Rectangle updatedArea = new Rectangle(this.currentCursorLocation.x - insets.left, this.currentCursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
                this.operatorTree.scrollRectToVisible(updatedArea);
            }
            this.previousCursorLocation = this.currentCursorLocation;
        }
        e.acceptDrag(e.getDropAction());
    }

    public void dropActionChanged(DropTargetDragEvent e) {
        if (!this.dragAllowed(e)) {
            e.rejectDrag();
            return;
        }
        e.acceptDrag(e.getDropAction());
    }

    public void dragExit(DropTargetEvent e) {
        this.clearOperatorMarker();
    }

    public void dragDropEnd(DragSourceDropEvent e) {
        this.clearOperatorMarker();
        this.operatorTree.setEditable(true);
        if (!e.getDropSuccess()) {
            DataFlavor acceptedFlavor = TransferableOperator.TRANSFERRED_OPERATOR_FLAVOR;
            try {
                Transferable currentlyDraggedOperator = e.getDragSourceContext().getTransferable();
                if (currentlyDraggedOperator == null) {
                    throw new NullPointerException();
                }
                if (currentlyDraggedOperator.getTransferData(acceptedFlavor) instanceof Operator) {
                    Operator newOperator = (Operator)currentlyDraggedOperator.getTransferData(acceptedFlavor);
                    int indexDelete = newOperator.getParent().getIndexOfOperator(newOperator, true);
                    TreePath oldLocation = this.originPath.getParentPath();
                    newOperator.remove();
                    ((OperatorTreeModel)this.operatorTree.getModel()).fireOperatorRemoved(this, oldLocation, indexDelete, newOperator);
                    YaleGUI.getMainFrame().experimentChanged();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        }
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        Operator selectedOperator;
        if (!this.acceptedDnDActions.contains(e.getDragAction())) {
            return;
        }
        Point dragOrigin = e.getDragOrigin();
        this.originPath = this.operatorTree.getPathForLocation(dragOrigin.x, dragOrigin.y);
        if (this.originPath != null && this.originPath.getParentPath() != null && (selectedOperator = (Operator)this.originPath.getLastPathComponent()) != null) {
            TransferableOperator selectedTransferableOperator = new TransferableOperator(selectedOperator);
            try {
                this.operatorTree.setEditable(false);
                e.startDrag(null, null, new Point(0, 0), selectedTransferableOperator, this);
            }
            catch (InvalidDnDOperationException dndE) {
                dndE.printStackTrace();
            }
        }
    }

    private boolean dragAllowed(DropTargetDragEvent e) {
        DataFlavor[] currentFlavors = TransferableOperator.DATA_FLAVORS;
        DataFlavor acceptedFlavor = null;
        int i = 0;
        while (i < currentFlavors.length) {
            if (e.isDataFlavorSupported(currentFlavors[i])) {
                acceptedFlavor = currentFlavors[i];
                break;
            }
            ++i;
        }
        if (acceptedFlavor == null) {
            return false;
        }
        return this.acceptedDnDActions.contains(e.getSourceActions());
    }

    public int getOperatorMarker(String operatorName) {
        List<String> markerList = Arrays.asList(markedOperator);
        return markerList.indexOf(operatorName);
    }

    private void clearOperatorMarker() {
        this.nodeExpandDelay.stop();
        String[] cleanMarkedOperator = new String[]{"", "", ""};
        markedOperator = cleanMarkedOperator;
        this.operatorTree.treeDidChange();
    }

    private void setupNodeExpandTimer() {
        this.nodeExpandDelay = new Timer(1500, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DnDSupport.this.operatorTree.isRootVisible() && DnDSupport.this.operatorTree.getRowForPath(DnDSupport.this.currentPath) == 0) {
                    return;
                }
                if (DnDSupport.this.operatorTree.isExpanded(DnDSupport.this.currentPath)) {
                    DnDSupport.this.operatorTree.collapsePath(DnDSupport.this.currentPath);
                } else {
                    DnDSupport.this.operatorTree.expandPath(DnDSupport.this.currentPath);
                }
            }
        });
        this.nodeExpandDelay.setRepeats(false);
    }
}

