/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.operatormenu;

import edu.udo.cs.yale.gui.operatormenu.NewOperatorMenu;
import edu.udo.cs.yale.gui.operatormenu.ReplaceOperatorMenu;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.tools.GroupTree;
import edu.udo.cs.yale.tools.OperatorService;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public abstract class OperatorMenu
extends JMenu {
    public static final OperatorMenu NEW_OPERATOR_MENU = new NewOperatorMenu();
    public static final OperatorMenu REPLACE_OPERATOR_MENU = new ReplaceOperatorMenu(false);
    public static final OperatorMenu REPLACE_OPERATORCHAIN_MENU = new ReplaceOperatorMenu(true);

    protected OperatorMenu(String name, boolean onlyChains) {
        super(name);
        this.addMenu(OperatorService.getGroups(), this, onlyChains);
    }

    public void addMenu(GroupTree group, JMenu menu, boolean onlyChains) {
        for (GroupTree subGroup : group.getSubGroups()) {
            JMenu subMenu = new JMenu(subGroup.getName());
            this.addMenu(subGroup, subMenu, onlyChains);
            if (subMenu.getItemCount() <= 0) continue;
            menu.add(subMenu);
        }
        for (final OperatorDescription description : group.getOperatorDescriptions()) {
            if (onlyChains && !OperatorChain.class.isAssignableFrom(description.getOperatorClass())) continue;
            JMenuItem item = null;
            Image icon = description.getIcon();
            item = icon == null ? new JMenuItem(description.getName()) : new JMenuItem(description.getName(), new ImageIcon(icon));
            item.setToolTipText(SwingTools.transformToolTipText(description.getDescription()));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OperatorMenu.this.performAction(description);
                }
            });
            menu.add(item);
        }
    }

    public abstract void performAction(OperatorDescription var1);
}

