/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.experimenteditor;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.experimenteditor.ExperimentEditor;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.gui.tools.syntax.JEditTextArea;
import edu.udo.cs.yale.gui.tools.syntax.TextAreaDefaults;
import edu.udo.cs.yale.gui.tools.syntax.XMLTokenMarker;
import edu.udo.cs.yale.operator.Operator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.swing.JPanel;

public class XMLEditor
extends JPanel
implements ExperimentEditor {
    private static final long serialVersionUID = 4172143138689034659L;
    private JEditTextArea editor;
    private MainFrame mainFrame;

    public XMLEditor(MainFrame mainFrame) {
        super(new BorderLayout());
        this.mainFrame = mainFrame;
        TextAreaDefaults defaultSettings = TextAreaDefaults.getDefaults();
        defaultSettings.styles = SwingTools.getSyntaxStyles();
        this.editor = new JEditTextArea(defaultSettings);
        this.editor.setTokenMarker(new XMLTokenMarker());
        this.add((Component)this.editor, "Center");
    }

    public void setText(String text) {
        this.editor.setText(text);
    }

    public void experimentChanged(Operator op) {
        this.setText(op.getXML(""));
    }

    public void setCurrentOperator(Operator currentOperator) {
        if (currentOperator != null) {
            this.editor.requestFocus();
            this.editor.setCaretPosition(0);
            String name = currentOperator.getName();
            String text = this.editor.getText();
            int result = text.indexOf("\"" + name + "\"");
            if (result >= 0) {
                this.editor.select(result + 1, result + name.length() + 1);
            }
        }
    }

    public void validateExperiment() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(this.editor.getText().getBytes());
        Experiment newExp = new Experiment(in);
        ((InputStream)in).close();
        if (!newExp.getRootOperator().getXML("").equals(YaleGUI.getMainFrame().getExperiment().getRootOperator().getXML(""))) {
            newExp.setExperimentFile(YaleGUI.getMainFrame().getExperiment().getExperimentFile());
            YaleGUI.getMainFrame().setExperiment(newExp);
            this.mainFrame.experimentChanged();
        }
    }
}

