/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.experimenteditor;

import edu.udo.cs.yale.datatable.DataTable;
import edu.udo.cs.yale.gui.plotter.PlotterPanel;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.ResultObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultDisplay
extends JPanel {
    private static final long serialVersionUID = 1970923271834221630L;
    private List<ResultObject> results = new LinkedList<ResultObject>();
    private JTabbedPane tabs = new JTabbedPane();
    private JLabel label = new JLabel("Results");
    private Collection<DataTable> dataTables = new LinkedList<DataTable>();

    public ResultDisplay() {
        super(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.add((Component)this.label, "North");
        this.setData(null, "Results");
    }

    public void clear() {
        this.tabs.removeAll();
        this.results.clear();
        this.dataTables.clear();
        this.label.setText("No results produced.");
        this.repaint();
    }

    public void setDataTables(Collection<DataTable> dataTables) {
        this.dataTables = dataTables;
        this.addDataTables();
    }

    private void addDataTables() {
        for (DataTable table : this.dataTables) {
            this.tabs.addTab(table.getName(), new PlotterPanel(table));
        }
    }

    public void setData(IOContainer resultContainer, String message) {
        int selectedIndex = this.tabs.getSelectedIndex();
        int i = this.tabs.getTabCount() - 1;
        while (i >= 0) {
            Component c = this.tabs.getComponentAt(i);
            if (!(c instanceof PlotterPanel)) {
                this.tabs.removeTabAt(i);
            }
            --i;
        }
        this.results = ResultDisplay.convertToList(resultContainer);
        TreeSet<String> doubleUsedNames = new TreeSet<String>();
        TreeSet<String> usedResultNames = new TreeSet<String>();
        for (ResultObject resultObject : this.results) {
            if (usedResultNames.contains(resultObject.getName())) {
                doubleUsedNames.add(resultObject.getName());
            }
            usedResultNames.add(resultObject.getName());
        }
        if (this.results.size() > 0) {
            this.label.setText(null);
            int counter = 0;
            for (ResultObject result : this.results) {
                JPanel resultPanel = new JPanel(new BorderLayout());
                Component visualisationComponent = result.getVisualizationComponent(resultContainer);
                if (visualisationComponent instanceof JLabel) {
                    visualisationComponent = new JScrollPane(visualisationComponent);
                }
                if (visualisationComponent instanceof JScrollPane) {
                    ((JScrollPane)visualisationComponent).getVerticalScrollBar().setUnitIncrement(10);
                    ((JScrollPane)visualisationComponent).getHorizontalScrollBar().setUnitIncrement(10);
                }
                resultPanel.putClientProperty("main.component", visualisationComponent);
                resultPanel.add(visualisationComponent, "Center");
                JPanel buttonPanel = new JPanel(new FlowLayout(2));
                Iterator action = result.getActions().iterator();
                while (action.hasNext()) {
                    buttonPanel.add(new JButton((Action)action.next()));
                }
                resultPanel.add((Component)buttonPanel, "South");
                String tabName = result.getName();
                if (doubleUsedNames.contains(result.getName())) {
                    tabName = String.valueOf(result.getName()) + " (" + result.getSource() + ")";
                }
                this.tabs.addTab(tabName, resultPanel);
                this.tabs.setToolTipTextAt(counter++, "Show the result '" + result.getName() + "'.");
            }
        } else {
            this.label.setText("No results produced.");
        }
        if (selectedIndex < this.tabs.getTabCount()) {
            this.tabs.setSelectedIndex(selectedIndex);
        } else if (this.tabs.getTabCount() > 0) {
            this.tabs.setSelectedIndex(0);
        }
    }

    private static List<ResultObject> convertToList(IOContainer container) {
        LinkedList<ResultObject> list = new LinkedList<ResultObject>();
        if (container != null) {
            ResultObject result = null;
            do {
                try {
                    result = container.get(ResultObject.class, list.size());
                    list.add(result);
                }
                catch (MissingIOObjectException e) {
                    break;
                }
            } while (result != null);
        }
        return list;
    }

    public void showSomething() {
        if (this.tabs.getSelectedIndex() == -1 && this.tabs.getTabCount() > 0) {
            this.tabs.setSelectedIndex(0);
        }
    }
}

