/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.experimenteditor;

import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.experimenteditor.DescriptionEditor;
import edu.udo.cs.yale.gui.experimenteditor.ExperimentEditor;
import edu.udo.cs.yale.gui.experimenteditor.NewOperatorEditor;
import edu.udo.cs.yale.gui.experimenteditor.XMLEditor;
import edu.udo.cs.yale.gui.operatortree.OperatorTree;
import edu.udo.cs.yale.gui.properties.OperatorPropertyTable;
import edu.udo.cs.yale.gui.properties.SettingsChangeListener;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainExperimentEditor
extends JSplitPane
implements ExperimentEditor,
ChangeListener,
SettingsChangeListener {
    private static final long serialVersionUID = 9160820147290119297L;
    public static final int PARAMETERS = 0;
    public static final int XML = 1;
    public static final int DESCRIPTION = 2;
    public static final int NEW_OPERATOR = 3;
    private OperatorTree operatorTree;
    private JTabbedPane operatorTreeTabs = new JTabbedPane();
    private JTabbedPane editorTabs = new JTabbedPane();
    private OperatorPropertyTable propertyTable;
    private XMLEditor xmlEditor;
    private DescriptionEditor descriptionEditor;
    private NewOperatorEditor newOperatorEditor;
    private int lastIndex = 0;
    private MainFrame mainFrame;

    public MainExperimentEditor(MainFrame mainFrame) {
        super(1);
        this.setResizeWeight(0.0);
        this.setBorder(null);
        this.mainFrame = mainFrame;
        this.operatorTree = new OperatorTree(mainFrame);
        this.operatorTree.setBorder(null);
        this.propertyTable = new OperatorPropertyTable(mainFrame);
        this.xmlEditor = new XMLEditor(mainFrame);
        this.descriptionEditor = new DescriptionEditor();
        this.newOperatorEditor = new NewOperatorEditor();
        JScrollPane treeScrollPane = new JScrollPane(this.operatorTree);
        treeScrollPane.setBorder(null);
        this.operatorTreeTabs.add((Component)treeScrollPane, "Operator Tree");
        this.add(this.operatorTreeTabs);
        int counter = 0;
        this.editorTabs.add((Component)new JScrollPane(this.propertyTable), "Parameters");
        this.editorTabs.setToolTipTextAt(counter++, "Shows the parameters of the currently selected operator.");
        this.editorTabs.add((Component)this.xmlEditor, "XML");
        this.editorTabs.setToolTipTextAt(counter++, "Shows the XML definition of the current experiment.");
        this.editorTabs.add((Component)this.descriptionEditor, "Comment");
        this.editorTabs.setToolTipTextAt(counter++, "Shows a comment editor for the currently selected operator.");
        this.editorTabs.add((Component)this.newOperatorEditor, "New Operator");
        this.editorTabs.setToolTipTextAt(counter++, "Shows a grouped view of all available operators for dragging them into the operator tree.");
        this.add(this.editorTabs);
        this.editorTabs.addChangeListener(this);
    }

    private ExperimentEditor getExperimentEditor(int index) {
        switch (index) {
            case 1: {
                return this.xmlEditor;
            }
            case 2: {
                return this.descriptionEditor;
            }
        }
        return null;
    }

    public void setGroupSelectionDivider(int pos) {
        this.newOperatorEditor.setDividerLocation(pos);
    }

    public int getGroupSelectionDivider() {
        return this.newOperatorEditor.getDividerLocation();
    }

    public void experimentChanged(Operator operator) {
        this.operatorTree.setOperator(operator);
        this.propertyTable.setOperator(null);
        this.xmlEditor.experimentChanged(operator);
        this.descriptionEditor.setCurrentOperator(null);
    }

    public void setCurrentOperator(Operator current) {
        this.propertyTable.setOperator(current);
        this.xmlEditor.setCurrentOperator(current);
        this.descriptionEditor.setCurrentOperator(current);
    }

    public void validateExperiment() {
    }

    public OperatorTree getOperatorTree() {
        return this.operatorTree;
    }

    public OperatorPropertyTable getPropertyTable() {
        return this.propertyTable;
    }

    public XMLEditor getXMLEditor() {
        return this.xmlEditor;
    }

    public boolean isXMLViewActive() {
        return this.editorTabs.getSelectedIndex() == 1;
    }

    public boolean isDescriptionViewActive() {
        return this.editorTabs.getSelectedIndex() == 2;
    }

    public void changeToXMLEditor() {
        this.editorTabs.setSelectedIndex(1);
    }

    public void changeFromNewOperator2ParameterEditor() {
        if (this.editorTabs.getSelectedIndex() == 3) {
            this.editorTabs.setSelectedIndex(0);
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.getPropertyTable().stopCurrentEditing();
        int currentIndex = this.editorTabs.getSelectedIndex();
        if (this.lastIndex == currentIndex) {
            return;
        }
        try {
            ExperimentEditor newEditor;
            ExperimentEditor lastEditor;
            if (currentIndex >= 0 && (lastEditor = this.getExperimentEditor(this.lastIndex)) != null) {
                lastEditor.validateExperiment();
            }
            if ((newEditor = this.getExperimentEditor(currentIndex)) != null) {
                newEditor.experimentChanged(YaleGUI.getMainFrame().getExperiment().getRootOperator());
            }
            this.lastIndex = currentIndex;
        }
        catch (Exception ex) {
            switch (JOptionPane.showConfirmDialog(this, String.valueOf(ex.toString()) + Tools.getLineSeparator() + "Cancel to ignore changes, Ok to go on editing.", "Error", 2, 0)) {
                case 0: {
                    this.editorTabs.setSelectedIndex(this.lastIndex);
                    break;
                }
                default: {
                    ExperimentEditor lastEditor = this.getExperimentEditor(this.lastIndex);
                    if (lastEditor == null) break;
                    lastEditor.experimentChanged(YaleGUI.getMainFrame().getExperiment().getRootOperator());
                }
            }
        }
        this.mainFrame.enableActions();
    }

    public void settingsChanged(Properties properties) {
    }
}

