/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.experimenteditor;

import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.experimenteditor.ExperimentEditor;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.gui.tools.syntax.HTMLTokenMarker;
import edu.udo.cs.yale.gui.tools.syntax.JEditTextArea;
import edu.udo.cs.yale.operator.Operator;

public class DescriptionEditor
extends JEditTextArea
implements ExperimentEditor {
    private static final long serialVersionUID = -2661346182983330754L;
    private transient Operator currentOperator;

    public DescriptionEditor() {
        super(SwingTools.getTextAreaDefaults());
        this.setTokenMarker(new HTMLTokenMarker());
    }

    public void setCurrentOperator(Operator operator) {
        this.currentOperator = operator;
        if (this.currentOperator != null) {
            String description = this.currentOperator.getUserDescription();
            if (description != null) {
                String text = SwingTools.text2SimpleHtml(description);
                this.setText(text);
            } else {
                this.setText(null);
            }
        } else {
            this.setText(null);
        }
    }

    public void experimentChanged(Operator operator) {
    }

    public void validateExperiment() throws Exception {
        String newExp;
        String oldExp = YaleGUI.getMainFrame().getExperiment().getRootOperator().getXML("");
        if (this.currentOperator != null) {
            this.currentOperator.setUserDescription(SwingTools.html2YaleText(this.getText()));
        }
        if (!(newExp = YaleGUI.getMainFrame().getExperiment().getRootOperator().getXML("")).equals(oldExp)) {
            YaleGUI.getMainFrame().experimentChanged();
        }
    }
}

