/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.dialog.boxviewer;

import edu.udo.cs.yale.gui.dialog.boxviewer.LeafRenderer;
import edu.udo.cs.yale.gui.dialog.boxviewer.OperatorRenderer;
import edu.udo.cs.yale.gui.dialog.boxviewer.SimpleChainRenderer;
import edu.udo.cs.yale.gui.dialog.boxviewer.WrapperRenderer;
import edu.udo.cs.yale.operator.ExperimentOperator;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.SimpleOperatorChain;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class ExperimentRenderer
extends JPanel {
    private static final long serialVersionUID = 2111854024857950879L;
    private static OperatorRenderer leafRenderer = new LeafRenderer();
    private static OperatorRenderer chainRenderer = new SimpleChainRenderer();
    private static OperatorRenderer wrapperRenderer = new WrapperRenderer();
    private boolean resized = false;
    private transient Operator operator;

    public void setOperator(Operator operator) {
        this.operator = operator;
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.operator == null) {
            return;
        }
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g2d = (Graphics2D)g;
        Dimension size = ExperimentRenderer.getRenderer(this.operator).getSize(this.operator, g2d);
        Dimension dimension = new Dimension((int)size.getWidth() + 20, (int)size.getHeight() + 20);
        this.setPreferredSize(dimension);
        if (!this.resized) {
            this.revalidate();
            this.repaint();
            this.resized = true;
        }
        g2d.translate((double)this.getWidth() / 2.0 - size.getWidth() / 2.0, 10.0);
        ExperimentRenderer.getRenderer(this.operator).drawOperator(this.operator, g2d);
    }

    public void print(Graphics g) {
        if (this.operator == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        ExperimentRenderer.getRenderer(this.operator).drawOperator(this.operator, g2d);
    }

    public static OperatorRenderer getRenderer(Operator op) {
        if (op instanceof OperatorChain) {
            if (op instanceof SimpleOperatorChain || op instanceof ExperimentOperator) {
                return chainRenderer;
            }
            return wrapperRenderer;
        }
        return leafRenderer;
    }
}

