/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.dialog.boxviewer;

import edu.udo.cs.yale.gui.dialog.boxviewer.ExperimentRenderer;
import edu.udo.cs.yale.gui.dialog.boxviewer.OperatorRenderer;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;

public abstract class ChainRenderer
extends OperatorRenderer {
    private static final int BORDER = 10;

    public abstract Paint getBackground(Dimension var1);

    public void drawOperator(Operator op, Graphics2D g) {
        Dimension d = this.getSize(op, g);
        g.setPaint(this.getBackground(d));
        g.fillRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
        g.setPaint(Color.black);
        g.setStroke(new BasicStroke(3.0f));
        g.drawRect(0, 0, (int)d.getWidth(), (int)d.getHeight());
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(10, 10);
        this.drawName(op, g2);
        g2.dispose();
        double width = d.getWidth();
        double y = 20.0 + this.getNameSize(op, g).getHeight();
        OperatorChain chain = (OperatorChain)op;
        int i = 0;
        while (i < chain.getNumberOfOperators()) {
            Operator innerOp = chain.getOperator(i);
            OperatorRenderer renderer = ExperimentRenderer.getRenderer(innerOp);
            Dimension innerSize = renderer.getSize(innerOp, g);
            Graphics2D gn = (Graphics2D)g.create((int)(width / 2.0 - innerSize.getWidth() / 2.0), (int)y, (int)innerSize.getWidth(), (int)innerSize.getHeight());
            renderer.drawOperator(innerOp, gn);
            gn.dispose();
            y += innerSize.getHeight() + 10.0;
            ++i;
        }
    }

    public Dimension getSize(Operator operator, Graphics2D g) {
        Dimension d = this.getNameSize(operator, g);
        OperatorChain chain = (OperatorChain)operator;
        double width = d.getWidth();
        double height = d.getHeight() + 10.0;
        int i = 0;
        while (i < chain.getNumberOfOperators()) {
            Operator innerOp = chain.getOperator(i);
            OperatorRenderer renderer = ExperimentRenderer.getRenderer(innerOp);
            Dimension innerSize = renderer.getSize(innerOp, g);
            width = Math.max(width, innerSize.getWidth());
            height += innerSize.getHeight() + 10.0;
            ++i;
        }
        return new Dimension((int)width + 20, (int)height + 10);
    }
}

