/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.dialog.boxviewer;

import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.dialog.actions.BoxViewerExportAction;
import edu.udo.cs.yale.gui.dialog.actions.BoxViewerPrintAction;
import edu.udo.cs.yale.gui.dialog.boxviewer.ExperimentRenderer;
import edu.udo.cs.yale.gui.tools.ComponentPrinter;
import edu.udo.cs.yale.gui.tools.ExtendedToolBar;
import edu.udo.cs.yale.gui.tools.IconSize;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.freehep.util.export.ExportDialog;

public class BoxViewerDialog
extends JDialog {
    private static final long serialVersionUID = -1090928037950227038L;
    public final Action PRINT_ACTION_24 = new BoxViewerPrintAction(this, IconSize.SMALL);
    public final Action PRINT_ACTION_32 = new BoxViewerPrintAction(this, IconSize.MIDDLE);
    public final Action EXPORT_ACTION_24 = new BoxViewerExportAction(this, IconSize.SMALL);
    public final Action EXPORT_ACTION_32 = new BoxViewerExportAction(this, IconSize.MIDDLE);
    private ExperimentRenderer experimentRenderer;
    private transient PrinterJob printerJob = PrinterJob.getPrinterJob();

    public BoxViewerDialog(Operator operator) {
        super(YaleGUI.getMainFrame(), "Box View", false);
        this.setLayout(new BorderLayout());
        ExtendedToolBar toolBar = new ExtendedToolBar();
        toolBar.add(this.PRINT_ACTION_32);
        toolBar.add(this.EXPORT_ACTION_32);
        this.add((Component)toolBar, "North");
        this.experimentRenderer = new ExperimentRenderer();
        this.experimentRenderer.setOperator(YaleGUI.getMainFrame().getExperiment().getRootOperator());
        JScrollPane scrollPane = new JScrollPane(this.experimentRenderer);
        this.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoxViewerDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        this.add((Component)buttonPanel, "South");
        this.setSize(400, 600);
        this.setLocationRelativeTo(YaleGUI.getMainFrame());
    }

    public Object readResolve() {
        this.printerJob = PrinterJob.getPrinterJob();
        return this;
    }

    public void printExperiment() {
        this.printerJob.setPrintable(new ComponentPrinter(this.experimentRenderer));
        if (this.printerJob.printDialog()) {
            try {
                this.printerJob.print();
            }
            catch (PrinterException pe) {
                SwingTools.showSimpleErrorMessage("Printer error", pe);
            }
        }
    }

    public void exportExperiment() {
        ExportDialog exportDialog = new ExportDialog("YALE");
        exportDialog.showExportDialog((Component)YaleGUI.getMainFrame(), "Export", (Component)this.experimentRenderer, YaleGUI.getMainFrame().getBaseName());
    }
}

