/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.dialog;

import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.dialog.Tutorial;
import edu.udo.cs.yale.gui.dialog.WizardDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WelcomeDialog
extends JDialog {
    private static final long serialVersionUID = -201033815501632610L;
    private static final int NEW = 0;
    private static final int RECENT = 1;
    private static final int OPEN = 2;
    private static final int WIZARD = 3;
    private static final int TUTORIAL = 4;
    private JRadioButton[] startOptions = new JRadioButton[]{new JRadioButton("Start with a blank experiment"), new JRadioButton("Open one of the recently used experiments"), new JRadioButton("Open an existing experiment"), new JRadioButton("Start the Experiment Wizard"), new JRadioButton("Start the Yale online tutorial")};
    private JList recentFileList;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private MainFrame mainFrame;

    public WelcomeDialog(MainFrame mainFrame) {
        super(mainFrame, "Welcome to YALE!", true);
        this.mainFrame = mainFrame;
        Box box = new Box(1);
        box.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        int i = 0;
        while (i < this.startOptions.length) {
            box.add(this.startOptions[i]);
            this.buttonGroup.add(this.startOptions[i]);
            this.startOptions[i].setAlignmentX(0.0f);
            if (i == 1) {
                if (YaleGUI.getRecentFiles().size() == 0) {
                    this.startOptions[1].setEnabled(false);
                } else {
                    this.recentFileList = new JList<Object>(YaleGUI.getRecentFiles().toArray(new Object[YaleGUI.getRecentFiles().size()]));
                    this.recentFileList.setBorder(BorderFactory.createBevelBorder(1));
                    this.recentFileList.setSelectionMode(0);
                    this.recentFileList.addListSelectionListener(new ListSelectionListener(){

                        public void valueChanged(ListSelectionEvent e) {
                            WelcomeDialog.this.startOptions[1].setSelected(true);
                        }
                    });
                    JPanel listPanel = new JPanel(new FlowLayout(2));
                    listPanel.add(this.recentFileList);
                    listPanel.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
                    listPanel.setAlignmentX(0.0f);
                    box.add(listPanel);
                    this.startOptions[1].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            if (WelcomeDialog.this.recentFileList.getSelectedIndex() == -1) {
                                WelcomeDialog.this.recentFileList.setSelectedIndex(0);
                            }
                        }
                    });
                }
            }
            ++i;
        }
        this.startOptions[0].setSelected(true);
        this.getContentPane().add((Component)box, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton start = new JButton("Start");
        start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WelcomeDialog.this.start();
            }
        });
        buttonPanel.add(start);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(mainFrame);
    }

    private void start() {
        this.dispose();
        int selected = 0;
        while (!this.startOptions[selected].isSelected()) {
            ++selected;
        }
        switch (selected) {
            case 0: {
                break;
            }
            case 2: {
                this.mainFrame.open();
                break;
            }
            case 1: {
                this.mainFrame.open(YaleGUI.getRecentFiles().get(this.recentFileList.getSelectedIndex()));
                break;
            }
            case 3: {
                new WizardDialog(this.mainFrame).setVisible(true);
                break;
            }
            case 4: {
                new Tutorial(this.mainFrame).setVisible(true);
            }
        }
    }
}

