/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.dialog;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.tools.ParameterService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class Tutorial
extends JDialog {
    private static final long serialVersionUID = 2826577972132069114L;
    private static final String START_TEXT = "<h2>Welcome to the Yale online tutorial!</h2><p>This tutorial demonstrates basic concepts of Yale and simple experiments which can be performed. The user should have some knowledge in the domain of machine learning and data mining.</p><p>Whenever this tutorial refers to the &quot;Yale Tutorial&quot;, it means the printed version available at<br><center><code>http://yale.cs.uni-dortmund.de</code></center></p><p>You should read the first chapter of the Yale Tutorial for better motivation, but you can also try to start with the online tutorial without reading the printed version. Please read the texts carefully and try at least the suggested steps. The online tutorial will take about one hour.</p><h4>Please note:</h4><p>Most parts of Yale provide additional information if you hold the mouse pointer a few moments on the part (tool tip texts). In this way all operators and parameters are described too.</p>";
    private static final String END_TEXT = "<h2>Congratulations!</h2><p>You have finished the Yale online tutorial. You should be able to perform many of the possible experiments. Now you know the most important building blocks of data mining experiments. Of course these building blocks can be arbitrarily nested in Yale as long as their input and output types fits. For a reference of all operators please refer to the Yale Tutorial. Check also the other sample experiments which can be found in the sample directory of Yale.</p><p>We have added many known preprocessing steps and learning operators to Yale. Most data formats can also be handled. If you need to adapt Yale you should read the chapter of the Yale Tutorial which describes the creation of operators and the extension mechanism. Yale can easily be extended. Have fun!</p>";
    private static final String[] EXPERIMENTS;
    private int state = 0;
    private MainFrame mainFrame;
    private JEditorPane description;
    private JScrollPane descriptionScrollPane;
    private JButton prevButton;
    private JButton nextButton;

    static {
        UIDefaults uiDefaults = UIManager.getDefaults();
        Font f = new Font("SansSerif", 0, 12);
        FontUIResource font = new FontUIResource(f);
        uiDefaults.put("EditorPane.font", font);
        EXPERIMENTS = new String[]{"Empty.xml", "01_IO" + File.separator + "01_ExampleSource.xml", "02_Learner" + File.separator + "01_DecisionTree.xml", "01_IO" + File.separator + "18_ModelWriter.xml", "01_IO" + File.separator + "19_ModelLoader.xml", "02_Learner" + File.separator + "12_AssociationRules.xml", "02_Learner" + File.separator + "19_Stacking.xml", "01_IO" + File.separator + "03_Sparse.xml", "01_IO" + File.separator + "02_ArffExampleSource.xml", "01_IO" + File.separator + "26_ExcelExampleSource.xml", "06_Visualisation" + File.separator + "08_SVMVisualisation.xml", "03_Preprocessing" + File.separator + "07_MissingValueReplenishment.xml", "03_Preprocessing" + File.separator + "08_NoiseGenerator.xml", "03_Preprocessing" + File.separator + "15_ExampleSetJoin.xml", "04_Validation" + File.separator + "03_XValidation_Numerical.xml", "02_Learner" + File.separator + "14_CostSensitiveLearningAndROCPlot.xml", "02_Learner" + File.separator + "13_AsymmetricCostLearning.xml", "02_Learner" + File.separator + "18_SimpleCostSensitiveLearning.xml", "05_Features" + File.separator + "03_PrincipalComponents.xml", "05_Features" + File.separator + "10_ForwardSelection.xml", "05_Features" + File.separator + "09_FeatureSelectionFilter.xml", "05_Features" + File.separator + "12_WeightGuidedFeatureSelection.xml", "05_Features" + File.separator + "18_MultiobjectiveSelection.xml", "04_Validation" + File.separator + "12_WrapperValidation.xml", "05_Features" + File.separator + "19_YAGGA.xml", "05_Features" + File.separator + "20_YAGGAResultAttributeSetting.xml", "03_Preprocessing" + File.separator + "12_FeatureGenerationByUser.xml", "05_Features" + File.separator + "13_EvolutionaryWeighting.xml", "06_Visualisation" + File.separator + "07_DataSetAndWeightsVisualisation.xml", "01_IO" + File.separator + "21_PreprocessingModelWriter.xml", "01_IO" + File.separator + "22_PreprocessingModelLoader.xml", "07_Meta" + File.separator + "01_ParameterOptimization.xml", "07_Meta" + File.separator + "06_OperatorEnabler.xml", "05_Features" + File.separator + "17_WeightingThreshold.xml", "04_Validation" + File.separator + "13_SignificanceTest.xml", "07_Meta" + File.separator + "08_MacroDefinition.xml"};
    }

    public Tutorial(MainFrame mainFrame) {
        super(mainFrame, "Yale Tutorial", false);
        this.mainFrame = mainFrame;
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout layout = new GridBagLayout();
        JPanel mainPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.ipadx = 10;
        c.ipady = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.description = new JEditorPane("text/html", SwingTools.text2DisplayHtml(START_TEXT));
        this.description.setEditable(false);
        this.description.setBackground(this.getBackground());
        this.descriptionScrollPane = new JScrollPane(this.description);
        c.gridwidth = 0;
        layout.setConstraints(this.descriptionScrollPane, c);
        mainPanel.add(this.descriptionScrollPane);
        c.weighty = 0.0;
        rootPanel.add((Component)mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.prevButton = new JButton("Previous");
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Tutorial.this.previous();
            }
        });
        this.prevButton.setEnabled(false);
        buttonPanel.add(this.prevButton);
        this.nextButton = new JButton("Next");
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Tutorial.this.next();
            }
        });
        buttonPanel.add(this.nextButton);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Tutorial.this.close();
            }
        });
        buttonPanel.add(closeButton);
        rootPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(rootPanel);
        this.pack();
        this.setSize(400, 600);
        this.setLocationRelativeTo(mainFrame);
        mainFrame.setTutorialMode(true);
    }

    private void setExperiment(String experiment) {
        File expFile = ParameterService.getSampleFile(experiment);
        this.mainFrame.open(expFile, false);
        this.description.setText(SwingTools.text2DisplayHtml(YaleGUI.getMainFrame().getExperiment().getRootOperator().getUserDescription()));
        this.description.getCaret().setDot(0);
        this.descriptionScrollPane.getVerticalScrollBar().setValue(0);
    }

    private void previous() {
        this.nextButton.setEnabled(true);
        if (this.state > 0) {
            --this.state;
        }
        if (this.state == 0) {
            this.prevButton.setEnabled(false);
            this.description.setText(SwingTools.text2DisplayHtml(START_TEXT));
        } else {
            this.setExperiment(EXPERIMENTS[this.state - 1]);
        }
    }

    private void next() {
        this.prevButton.setEnabled(true);
        if (this.state < EXPERIMENTS.length + 1) {
            ++this.state;
        }
        if (this.state == EXPERIMENTS.length + 1) {
            this.nextButton.setEnabled(false);
            this.description.setText(SwingTools.text2DisplayHtml(END_TEXT));
        } else {
            this.setExperiment(EXPERIMENTS[this.state - 1]);
        }
    }

    private void close() {
        this.mainFrame.setExperiment(new Experiment());
        this.mainFrame.setTutorialMode(false);
        this.dispose();
    }
}

