/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.dialog;

import edu.udo.cs.yale.gui.properties.SettingsTabs;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TotDDialog
extends JDialog {
    private static final String TOTD_ICON_NAME = "icons/48/lightbulb_on.png";
    private static Icon totdIcon = null;
    private static final long serialVersionUID = 8283186515936703793L;
    private JEditorPane text = new JEditorPane();
    private JScrollPane textScrollPane = new JScrollPane(this.text);
    private JCheckBox showTip = new JCheckBox("Show tips at start up");
    private List<String> allTips = new ArrayList<String>();

    static {
        totdIcon = SwingTools.createIcon(TOTD_ICON_NAME);
    }

    public TotDDialog(JFrame owner) {
        super(owner, "Tip of the Day", true);
        boolean currentShowTipProperty;
        try {
            StringBuffer current = new StringBuffer();
            URL totdURL = Tools.getResource("totd.txt");
            if (totdURL != null) {
                BufferedReader in = new BufferedReader(new InputStreamReader(totdURL.openStream()));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#")) continue;
                    if (line.length() == 0) {
                        String tip = current.toString();
                        if (tip.length() > 0) {
                            this.allTips.add(tip);
                        }
                        current = new StringBuffer();
                        continue;
                    }
                    current.append(String.valueOf(line) + " ");
                }
                in.close();
            } else {
                LogService.logMessage("Cannot show Tip of the Day: resource 'totd.txt' not found...", 4);
            }
        }
        catch (IOException e) {
            this.text.setText("Cannot display tip of the day: " + e.getMessage());
        }
        this.getContentPane().setLayout(new BorderLayout());
        JLabel iconLabel = new JLabel();
        if (totdIcon != null) {
            iconLabel.setIcon(totdIcon);
            iconLabel.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        }
        this.getContentPane().add((Component)iconLabel, "West");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        String tipProperty = System.getProperty("yale.gui.tip.show");
        if (tipProperty != null && tipProperty.equals("true")) {
            this.showTip.setSelected(true);
            currentShowTipProperty = true;
        } else {
            this.showTip.setSelected(false);
            currentShowTipProperty = false;
        }
        buttonPanel.add(this.showTip);
        JButton nextButton = new JButton("Next");
        nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TotDDialog.this.nextTip();
            }
        });
        buttonPanel.add(nextButton);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TotDDialog.this.closeDialog(currentShowTipProperty);
            }
        });
        buttonPanel.add(closeButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.text.setEditable(false);
        this.text.setContentType("text/html");
        this.nextTip();
        this.getContentPane().add((Component)this.textScrollPane, "Center");
        this.setSize(500, 400);
        this.setLocationRelativeTo(owner);
    }

    private void closeDialog(boolean currentShowTipProperty) {
        boolean show = this.showTip.isSelected();
        if (currentShowTipProperty != show) {
            System.setProperty("yale.gui.tip.show", show ? "true" : "false");
            SettingsTabs settings = new SettingsTabs();
            try {
                settings.save();
            }
            catch (IOException e) {
                SwingTools.showSimpleErrorMessage("Cannot write setting into file!", e);
            }
        }
        this.dispose();
    }

    private void nextTip() {
        Random random = new Random();
        int nextTip = random.nextInt(this.allTips.size());
        String tip = this.allTips.get(nextTip);
        String nextTipString = null;
        nextTipString = ++nextTip < 10 ? "00" + nextTip : (nextTip < 100 ? "0" + nextTip : "" + nextTip);
        this.text.setText("<h2>Tip " + nextTipString + "</h2>" + Tools.getLineSeparator() + tip);
        this.text.getCaret().setDot(0);
        this.textScrollPane.getVerticalScrollBar().setValue(0);
    }
}

