/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.dialog;

import edu.udo.cs.yale.gui.dialog.SearchableTextComponent;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SearchDialog
extends JDialog {
    private static final long serialVersionUID = -1019890951712706875L;
    private JTextField patternField = new JTextField(20);
    private JTextField replaceField = new JTextField(20);
    private JCheckBox caseSensitive = new JCheckBox("Case sensitive");
    private JCheckBox regExp = new JCheckBox("Regular expression");
    private JRadioButton up = new JRadioButton("Up");
    private JRadioButton down = new JRadioButton("Down");
    private transient SearchableTextComponent textComponent;

    public SearchDialog(Component owner, SearchableTextComponent textComponent) {
        this(owner, textComponent, false);
    }

    public SearchDialog(Component owner, SearchableTextComponent textComponent, boolean allowReplace) {
        this.textComponent = textComponent;
        this.textComponent.requestFocus();
        this.textComponent.setCaretPosition(0);
        if (allowReplace) {
            this.setTitle("Search and Replace");
        } else {
            this.setTitle("Search");
        }
        this.setModal(false);
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.ipadx = 10;
        c.weightx = 1.0;
        c.gridwidth = 1;
        JLabel label = new JLabel("Search:");
        layout.setConstraints(label, c);
        this.getContentPane().add(label);
        c.gridwidth = -1;
        layout.setConstraints(this.patternField, c);
        this.getContentPane().add(this.patternField);
        final JButton search = new JButton("Search");
        this.getRootPane().setDefaultButton(search);
        search.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.search();
                SearchDialog.this.getRootPane().setDefaultButton(search);
            }
        });
        c.gridwidth = 0;
        layout.setConstraints(search, c);
        this.getContentPane().add(search);
        if (allowReplace) {
            c.gridwidth = 1;
            label = new JLabel("Replace:");
            layout.setConstraints(label, c);
            this.getContentPane().add(label);
            c.gridwidth = -1;
            layout.setConstraints(this.replaceField, c);
            this.getContentPane().add(this.replaceField);
            final JButton replace = new JButton("Replace");
            replace.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SearchDialog.this.replace();
                    SearchDialog.this.search();
                    SearchDialog.this.getRootPane().setDefaultButton(replace);
                }
            });
            c.gridwidth = 0;
            layout.setConstraints(replace, c);
            this.getContentPane().add(replace);
        }
        JPanel directionPanel = new JPanel();
        directionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 0, 0, 7), BorderFactory.createTitledBorder("Direction")));
        ButtonGroup directionGroup = new ButtonGroup();
        this.up.setMnemonic(85);
        directionGroup.add(this.up);
        directionPanel.add(this.up);
        this.down.setMnemonic(68);
        directionGroup.add(this.down);
        this.down.setSelected(true);
        directionPanel.add(this.down);
        c.gridwidth = 1;
        layout.setConstraints(directionPanel, c);
        this.getContentPane().add(directionPanel);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 0, 0, 7), BorderFactory.createTitledBorder("Options")));
        optionsPanel.add(this.caseSensitive);
        optionsPanel.add(this.regExp);
        c.gridwidth = -1;
        layout.setConstraints(optionsPanel, c);
        this.getContentPane().add(optionsPanel);
        c.gridwidth = 0;
        JPanel dummyPanel = new JPanel();
        layout.setConstraints(dummyPanel, c);
        this.getContentPane().add(dummyPanel);
        JPanel closeButtonPanel = new JPanel(new FlowLayout(1));
        JButton cancel = new JButton("Close");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.dispose();
            }
        });
        closeButtonPanel.add(cancel);
        c.gridwidth = 0;
        layout.setConstraints(closeButtonPanel, c);
        this.getContentPane().add(closeButtonPanel);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void search() {
        String text;
        String pattern = this.patternField.getText().trim();
        if (pattern.length() == 0) {
            return;
        }
        int startPos = this.textComponent.getCaretPosition();
        if (startPos > (text = this.textComponent.getText()).length()) {
            startPos = 0;
        }
        if (this.down.isSelected()) {
            Result result = this.search(startPos, pattern, text, this.textComponent.canHandleCarriageReturn());
            if (result == null) {
                this.noMoreHits();
                return;
            }
            this.textComponent.select(result.start, result.end);
        } else {
            Result result;
            Result lastResult = null;
            int pos = 0;
            while ((result = this.search(pos, pattern, text, this.textComponent.canHandleCarriageReturn())) != null && result.end < startPos) {
                pos = result.start + 1;
                lastResult = result;
            }
            if (lastResult == null) {
                this.noMoreHits();
            } else {
                this.textComponent.select(lastResult.start, lastResult.end);
            }
        }
    }

    private void replace() {
        this.textComponent.replaceSelection(this.replaceField.getText());
    }

    private Result search(int start, String pattern, String text, boolean canHandleCarriageReturn) {
        int result;
        if (!canHandleCarriageReturn) {
            text = Tools.transformAllLineSeparators(text);
        }
        if (this.regExp.isSelected()) {
            Matcher matcher = Pattern.compile(pattern, this.caseSensitive.isSelected() ? 0 : 2).matcher(text.subSequence(start, text.length()));
            if (matcher.find()) {
                return new Result(start + matcher.start(), start + matcher.end());
            }
            return null;
        }
        if (!this.caseSensitive.isSelected()) {
            text = text.toLowerCase();
            pattern = pattern.toLowerCase();
        }
        if ((result = text.indexOf(pattern, start)) == -1) {
            return null;
        }
        return new Result(result, result + pattern.length());
    }

    private void noMoreHits() {
        String restartAt = this.up.isSelected() ? "end" : "beginning";
        switch (JOptionPane.showConfirmDialog(this, "Search string not found. Search from " + restartAt + "?", "String not found", 0)) {
            case 0: {
                this.textComponent.setCaretPosition(this.up.isSelected() ? this.textComponent.getText().replaceAll("\r", "").length() : 0);
                this.search();
                break;
            }
            default: {
                return;
            }
        }
    }

    private static class Result {
        private int start;
        private int end;

        private Result(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "start: " + this.start + ", end: " + this.end;
        }
    }
}

