/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.dialog;

import edu.udo.cs.yale.gui.ResultContainer;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.math.AnovaCalculator;
import edu.udo.cs.yale.tools.math.SignificanceCalculationException;
import edu.udo.cs.yale.tools.math.SignificanceTestResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ResultHistoryDialog
extends JDialog {
    private static final long serialVersionUID = 7498142147390911809L;
    private final Action ANOVA_ACTION = new AnovaAction();
    private List<PerformanceVector> selectedPerformanceVectors = new LinkedList<PerformanceVector>();

    public ResultHistoryDialog(Frame owner) {
        super(owner, "Result Comparator");
        this.setLayout(new BorderLayout());
        JSplitPane resultSelectionSplitPane = new JSplitPane(0);
        resultSelectionSplitPane.setBorder(null);
        JPanel experimentSelectionPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        experimentSelectionPanel.setLayout(layout);
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(4, 4, 4, 4);
        JLabel experimentLabel = new JLabel("Experiment");
        layout.setConstraints(experimentLabel, c);
        experimentSelectionPanel.add(experimentLabel);
        final JList resultSelectionList = new JList(YaleGUI.getResultHistory());
        resultSelectionList.setSelectionMode(2);
        JScrollPane listPane = new JScrollPane(resultSelectionList);
        c.weighty = 1.0;
        layout.setConstraints(listPane, c);
        experimentSelectionPanel.add(listPane);
        JPanel testPanel = new JPanel(new FlowLayout(1));
        this.ANOVA_ACTION.setEnabled(false);
        JButton testButton = new JButton(this.ANOVA_ACTION);
        testPanel.add(testButton);
        c.weighty = 0.0;
        layout.setConstraints(testPanel, c);
        experimentSelectionPanel.add(testPanel);
        resultSelectionSplitPane.add(experimentSelectionPanel);
        JPanel xmlPanel = new JPanel();
        layout = new GridBagLayout();
        c = new GridBagConstraints();
        xmlPanel.setLayout(layout);
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(4, 4, 4, 4);
        JLabel xmlLabel = new JLabel("XML Setup");
        layout.setConstraints(xmlLabel, c);
        xmlPanel.add(xmlLabel);
        final JTextArea xmlArea = new JTextArea();
        xmlArea.setEditable(false);
        xmlArea.setLineWrap(true);
        xmlArea.setWrapStyleWord(true);
        JScrollPane textPane = new JScrollPane(xmlArea);
        c.weighty = 1.0;
        layout.setConstraints(textPane, c);
        xmlPanel.add(textPane);
        resultSelectionSplitPane.add(xmlPanel);
        JSplitPane mainSplitPane = new JSplitPane(1);
        mainSplitPane.add(resultSelectionSplitPane);
        JPanel resultsPanel = new JPanel();
        layout = new GridBagLayout();
        c = new GridBagConstraints();
        resultsPanel.setLayout(layout);
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(4, 4, 4, 4);
        JLabel resultsLabel = new JLabel("Results");
        layout.setConstraints(resultsLabel, c);
        resultsPanel.add(resultsLabel);
        final JTextArea resultsArea = new JTextArea();
        resultsArea.setEditable(false);
        resultsArea.setLineWrap(true);
        resultsArea.setWrapStyleWord(true);
        JScrollPane resultsPane = new JScrollPane(resultsArea);
        c.weighty = 1.0;
        layout.setConstraints(resultsPane, c);
        resultsPanel.add(resultsPane);
        mainSplitPane.add(resultsPanel);
        resultSelectionList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int[] indices = resultSelectionList.getSelectedIndices();
                    if (indices.length > 0) {
                        if (indices.length == 1) {
                            ResultContainer selectedContainer = (ResultContainer)resultSelectionList.getSelectedValue();
                            xmlArea.setText(selectedContainer.getRootOperator().getXML(""));
                            resultsArea.setText(selectedContainer.getResults());
                            ResultHistoryDialog.this.ANOVA_ACTION.setEnabled(false);
                        } else {
                            xmlArea.setText("");
                            resultsArea.setText("");
                            ResultHistoryDialog.this.selectedPerformanceVectors.clear();
                            int i = 0;
                            while (i < indices.length) {
                                ResultContainer selectedContainer = (ResultContainer)YaleGUI.getResultHistory().getElementAt(indices[i]);
                                PerformanceVector performance = selectedContainer.getPerformance();
                                if (performance != null) {
                                    ResultHistoryDialog.this.selectedPerformanceVectors.add(performance);
                                }
                                ++i;
                            }
                            if (indices.length == ResultHistoryDialog.this.selectedPerformanceVectors.size()) {
                                ResultHistoryDialog.this.ANOVA_ACTION.setEnabled(true);
                            } else {
                                ResultHistoryDialog.this.ANOVA_ACTION.setEnabled(false);
                            }
                        }
                    } else {
                        xmlArea.setText("");
                        resultsArea.setText("");
                        ResultHistoryDialog.this.ANOVA_ACTION.setEnabled(false);
                    }
                }
            }
        });
        resultSelectionSplitPane.setDividerLocation(0.5);
        mainSplitPane.setDividerLocation(0.2);
        mainSplitPane.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)mainSplitPane, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultHistoryDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(600, 400);
        this.setLocationRelativeTo(owner);
    }

    private class AnovaAction
    extends AbstractAction {
        private static final long serialVersionUID = 6768585475843634549L;

        public AnovaAction() {
            super("Anova");
        }

        public void actionPerformed(ActionEvent e) {
            AnovaCalculator calculator = new AnovaCalculator();
            calculator.setAlpha(0.05);
            for (PerformanceVector vector : ResultHistoryDialog.this.selectedPerformanceVectors) {
                PerformanceCriterion pc = vector.getMainCriterion();
                calculator.addGroup(pc.getExampleCount(), pc.getAverage(), pc.getVariance());
            }
            try {
                SignificanceTestResult result = calculator.performSignificanceTest();
                JOptionPane.showMessageDialog(ResultHistoryDialog.this, result.getVisualizationComponent(null), "ANOVA result", -1);
            }
            catch (SignificanceCalculationException ex) {
                SwingTools.showSimpleErrorMessage("Cannot calculate statistical significance.", ex);
            }
        }
    }
}

