/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.dialog;

import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.condition.InnerOperatorCondition;
import edu.udo.cs.yale.operator.learner.Learner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class OperatorInfoScreen
extends JDialog {
    private static final long serialVersionUID = -6566133238783779634L;

    public OperatorInfoScreen(Frame owner, Operator operator) {
        super(owner, "Operator Info", true);
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout layout = new GridBagLayout();
        JPanel mainPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.ipadx = 10;
        c.weightx = 1.0;
        JLabel label = null;
        Image img = operator.getOperatorDescription().getIcon();
        if (img != null) {
            label = new JLabel(new ImageIcon(img));
            c.gridwidth = 0;
            layout.setConstraints(label, c);
            mainPanel.add(label);
        }
        Component sep = Box.createVerticalStrut(10);
        c.gridwidth = 0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        label = new JLabel("Name");
        label.setToolTipText("The name of the operator");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel(operator.getName());
        label.setToolTipText("The name of the operator");
        c.gridwidth = 0;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel("Group");
        label.setToolTipText("The group of the operator");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel(operator.getOperatorDescription().getGroup());
        label.setToolTipText("The group of the operator");
        c.gridwidth = 0;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel("Class");
        label.setToolTipText("The type of the operator");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel(operator.getOperatorDescription().getName());
        label.setToolTipText("The type of the operator");
        c.gridwidth = 0;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        sep = Box.createVerticalStrut(10);
        c.gridwidth = 0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        label = new JLabel("Input");
        label.setToolTipText("Expected input");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel(SwingTools.getStringFromClassArray(operator.getInputClasses()));
        label.setToolTipText("Expected input");
        c.gridwidth = 0;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel("Output");
        label.setToolTipText("Delivered output");
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        label = new JLabel(SwingTools.getStringFromClassArray(operator.getOutputClasses()));
        label.setToolTipText("Delivered output");
        c.gridwidth = 0;
        layout.setConstraints(label, c);
        mainPanel.add(label);
        if (operator instanceof Learner) {
            sep = Box.createVerticalStrut(10);
            c.gridwidth = 0;
            layout.setConstraints(sep, c);
            mainPanel.add(sep);
            Learner learner = (Learner)((Object)operator);
            StringBuffer learnerCapabilities = new StringBuffer();
            Iterator<LearnerCapability> i = LearnerCapability.getAllCapabilities().iterator();
            boolean first = true;
            while (i.hasNext()) {
                LearnerCapability capability = i.next();
                try {
                    if (!learner.supportsCapability(capability)) continue;
                    if (!first) {
                        learnerCapabilities.append(", ");
                    }
                    learnerCapabilities.append(capability.getDescription());
                    first = false;
                }
                catch (Exception e) {
                    break;
                }
            }
            String result = learnerCapabilities.toString();
            if (result.length() > 0) {
                JTextArea capabilities = new JTextArea("");
                capabilities.setToolTipText("The capabilities of this learning scheme.");
                capabilities.setEditable(false);
                capabilities.setLineWrap(true);
                capabilities.setWrapStyleWord(true);
                capabilities.setBackground(this.getBackground());
                capabilities.setText(result);
                JScrollPane textScrollPane = new JScrollPane(capabilities);
                textScrollPane.setBorder(BorderFactory.createTitledBorder("Learner Capabilities"));
                c.weighty = 1.0;
                c.gridwidth = 0;
                layout.setConstraints(textScrollPane, c);
                mainPanel.add(textScrollPane);
            }
        }
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            sep = Box.createVerticalStrut(10);
            c.gridwidth = 0;
            layout.setConstraints(sep, c);
            mainPanel.add(sep);
            if (chain.getMinNumberOfInnerOperators() == chain.getMaxNumberOfInnerOperators()) {
                label = new JLabel("Inner Operators");
                label.setToolTipText("Number of inner operators");
                c.gridwidth = -1;
                layout.setConstraints(label, c);
                mainPanel.add(label);
                label = new JLabel(String.valueOf(((OperatorChain)operator).getMinNumberOfInnerOperators()));
                label.setToolTipText("Number of inner operators");
                c.gridwidth = 0;
                layout.setConstraints(label, c);
                mainPanel.add(label);
            } else {
                label = new JLabel("Min Inner");
                label.setToolTipText("Minimum number of inner operators");
                c.gridwidth = -1;
                layout.setConstraints(label, c);
                mainPanel.add(label);
                label = new JLabel(String.valueOf(((OperatorChain)operator).getMinNumberOfInnerOperators()));
                label.setToolTipText("Minimum number of inner operators");
                c.gridwidth = 0;
                layout.setConstraints(label, c);
                mainPanel.add(label);
                label = new JLabel("Max Inner");
                label.setToolTipText("Maximum number of inner operators");
                c.gridwidth = -1;
                layout.setConstraints(label, c);
                mainPanel.add(label);
                int maxInner = ((OperatorChain)operator).getMaxNumberOfInnerOperators();
                label = new JLabel(maxInner == Integer.MAX_VALUE ? "Max" : String.valueOf(maxInner));
                label.setToolTipText("Maximum number of inner operators");
                c.gridwidth = 0;
                layout.setConstraints(label, c);
                mainPanel.add(label);
            }
            sep = Box.createVerticalStrut(10);
            c.gridwidth = 0;
            c.weighty = 0.0;
            layout.setConstraints(sep, c);
            mainPanel.add(sep);
            InnerOperatorCondition condition = chain.getInnerOperatorCondition();
            JEditorPane conditions = new JEditorPane("text/html", "");
            conditions.setToolTipText("Conditions which must be fulfilled by inner operators");
            conditions.setEditable(false);
            conditions.setBackground(this.getBackground());
            conditions.setForeground(Color.black);
            conditions.setText(SwingTools.text2DisplayHtml(condition.toHTML()));
            JScrollPane conditionsScrollPane = new JScrollPane(conditions);
            conditionsScrollPane.setBorder(BorderFactory.createTitledBorder("Inner operator conditions"));
            c.gridwidth = 0;
            c.weighty = 1.0;
            layout.setConstraints(conditionsScrollPane, c);
            mainPanel.add(conditionsScrollPane);
        }
        sep = Box.createVerticalStrut(10);
        c.gridwidth = 0;
        c.weighty = 0.0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        JTextArea description = new JTextArea("");
        description.setToolTipText("A short description of this operator");
        description.setEditable(false);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        description.setBackground(this.getBackground());
        description.setText(operator.getOperatorDescription().getDescription());
        JScrollPane textScrollPane = new JScrollPane(description);
        textScrollPane.setBorder(BorderFactory.createTitledBorder("Description"));
        c.weighty = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(textScrollPane, c);
        mainPanel.add(textScrollPane);
        List errorList = operator.getErrorList();
        if (errorList.size() > 0) {
            sep = Box.createVerticalStrut(10);
            c.gridwidth = 0;
            c.weighty = 0.0;
            layout.setConstraints(sep, c);
            mainPanel.add(sep);
            JEditorPane errors = new JEditorPane("text/html", "");
            errors.setToolTipText("Errors of this operator");
            errors.setEditable(false);
            errors.setBackground(this.getBackground());
            errors.setForeground(Color.red);
            String errorText = "<ul>";
            Iterator i = errorList.iterator();
            while (i.hasNext()) {
                errorText = String.valueOf(errorText) + "<li>" + (String)i.next() + "</li>";
            }
            errorText = String.valueOf(errorText) + "</ul>";
            errors.setText(SwingTools.text2DisplayHtml(errorText));
            JScrollPane errorsScrollPane = new JScrollPane(errors);
            errorsScrollPane.setBorder(BorderFactory.createTitledBorder("Errors"));
            c.gridwidth = 0;
            c.weighty = 1.0;
            layout.setConstraints(errorsScrollPane, c);
            mainPanel.add(errorsScrollPane);
        }
        sep = Box.createVerticalStrut(10);
        c.weighty = 0.0;
        c.gridwidth = 0;
        layout.setConstraints(sep, c);
        mainPanel.add(sep);
        rootPanel.add((Component)mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperatorInfoScreen.this.ok();
            }
        });
        buttonPanel.add(okButton);
        rootPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(rootPanel);
        this.setSize(600, 600);
        this.setLocationRelativeTo(owner);
    }

    private void ok() {
        this.dispose();
    }
}

