/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.dialog;

import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.tools.LogService;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class OperatorInfoPanel
extends JPanel {
    private static final long serialVersionUID = 3610550973456646750L;

    public OperatorInfoPanel(OperatorDescription description) {
        if (description == null) {
            this.add(new JLabel("No operator selected!"));
        } else {
            Operator operator = null;
            try {
                operator = description.createOperatorInstance();
            }
            catch (Exception e) {
                LogService.logMessage("Cannot create operator: " + e.getMessage(), 4);
            }
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.ipadx = 10;
            c.weightx = 1.0;
            JLabel label = null;
            Image img = description.getIcon();
            if (img != null) {
                label = new JLabel(new ImageIcon(img));
                c.gridwidth = 0;
                layout.setConstraints(label, c);
                this.add(label);
            }
            Component sep = Box.createVerticalStrut(10);
            c.gridwidth = 0;
            layout.setConstraints(sep, c);
            this.add(sep);
            String deprecationInfo = description.getDeprecationInfo();
            if (deprecationInfo != null) {
                label = new JLabel("Deprecation Info");
                label.setToolTipText("The info about the deprecation state of this operator");
                c.gridwidth = -1;
                layout.setConstraints(label, c);
                this.add(label);
                JTextArea deprecationArea = new JTextArea(deprecationInfo);
                deprecationArea.setBorder(BorderFactory.createEmptyBorder(0, 7, 10, 7));
                deprecationArea.setEditable(false);
                deprecationArea.setLineWrap(true);
                deprecationArea.setWrapStyleWord(true);
                deprecationArea.setBackground(this.getBackground());
                deprecationArea.setToolTipText("The info about the deprecation state of this operator");
                c.gridwidth = 0;
                layout.setConstraints(deprecationArea, c);
                this.add(deprecationArea);
            }
            label = new JLabel("Group");
            label.setToolTipText("The group of the operator");
            c.gridwidth = -1;
            layout.setConstraints(label, c);
            this.add(label);
            label = new JLabel(description.getGroup());
            label.setToolTipText("The group of the operator");
            c.gridwidth = 0;
            layout.setConstraints(label, c);
            this.add(label);
            label = new JLabel("Class");
            label.setToolTipText("The type of the operator");
            c.gridwidth = -1;
            layout.setConstraints(label, c);
            this.add(label);
            label = new JLabel(description.getName());
            label.setToolTipText("The type of the operator");
            c.gridwidth = 0;
            layout.setConstraints(label, c);
            this.add(label);
            sep = Box.createVerticalStrut(10);
            c.gridwidth = 0;
            layout.setConstraints(sep, c);
            this.add(sep);
            label = new JLabel("Input");
            label.setToolTipText("Expected input");
            c.gridwidth = -1;
            layout.setConstraints(label, c);
            this.add(label);
            if (operator != null) {
                label = new JLabel(SwingTools.getStringFromClassArray(operator.getInputClasses()));
                label.setToolTipText("Expected input");
                c.gridwidth = 0;
                layout.setConstraints(label, c);
                this.add(label);
                label = new JLabel("Output");
                label.setToolTipText("Delivered output");
                c.gridwidth = -1;
                layout.setConstraints(label, c);
                this.add(label);
                label = new JLabel(SwingTools.getStringFromClassArray(operator.getOutputClasses()));
                label.setToolTipText("Delivered output");
                c.gridwidth = 0;
                layout.setConstraints(label, c);
                this.add(label);
                if (operator instanceof OperatorChain) {
                    OperatorChain chain = (OperatorChain)operator;
                    sep = Box.createVerticalStrut(10);
                    c.gridwidth = 0;
                    layout.setConstraints(sep, c);
                    this.add(sep);
                    if (chain.getMinNumberOfInnerOperators() == chain.getMaxNumberOfInnerOperators()) {
                        label = new JLabel("Inner Operators");
                        label.setToolTipText("Number of inner operators");
                        c.gridwidth = -1;
                        layout.setConstraints(label, c);
                        this.add(label);
                        label = new JLabel(String.valueOf(((OperatorChain)operator).getMinNumberOfInnerOperators()));
                        label.setToolTipText("Number of inner operators");
                        c.gridwidth = 0;
                        layout.setConstraints(label, c);
                        this.add(label);
                    } else {
                        label = new JLabel("Min Inner");
                        label.setToolTipText("Minimum number of inner operators");
                        c.gridwidth = -1;
                        layout.setConstraints(label, c);
                        this.add(label);
                        label = new JLabel(String.valueOf(((OperatorChain)operator).getMinNumberOfInnerOperators()));
                        label.setToolTipText("Minimum number of inner operators");
                        c.gridwidth = 0;
                        layout.setConstraints(label, c);
                        this.add(label);
                        label = new JLabel("Max Inner");
                        label.setToolTipText("Maximum number of inner operators");
                        c.gridwidth = -1;
                        layout.setConstraints(label, c);
                        this.add(label);
                        int maxInner = ((OperatorChain)operator).getMaxNumberOfInnerOperators();
                        label = new JLabel(maxInner == Integer.MAX_VALUE ? "Max" : String.valueOf(maxInner));
                        label.setToolTipText("Maximum number of inner operators");
                        c.gridwidth = 0;
                        layout.setConstraints(label, c);
                        this.add(label);
                    }
                }
            }
            c.weighty = 1.0;
            JTextArea descriptionText = new JTextArea("");
            descriptionText.setToolTipText("A short description of this operator");
            descriptionText.setEditable(false);
            descriptionText.setLineWrap(true);
            descriptionText.setWrapStyleWord(true);
            descriptionText.setBackground(this.getBackground());
            descriptionText.setText(description.getDescription());
            JScrollPane textScrollPane = new JScrollPane(descriptionText);
            textScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
            c.gridwidth = 0;
            layout.setConstraints(textScrollPane, c);
            this.add(textScrollPane);
        }
    }
}

