/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.dialog;

import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.viewer.MetaDataViewer;
import edu.udo.cs.yale.operator.features.Individual;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IndividualSelector
extends JDialog {
    private static final long serialVersionUID = -6512675217777454316L;
    private transient Population population;
    private JList selectionList;
    private JLabel performanceLabel = new JLabel();
    private MetaDataViewer metaDataViewer = null;

    public IndividualSelector(Population population) {
        this(population, true);
    }

    public IndividualSelector(Population population, boolean modal) {
        this(YaleGUI.getMainFrame(), population, -1, -1, modal);
    }

    public IndividualSelector(Frame owner, Population population, int width, int height, boolean modal) {
        super(owner, "Result Individual Selection", modal);
        this.setDefaultCloseOperation(2);
        this.population = population;
        String[] listItems = new String[population.getNumberOfIndividuals()];
        int i = 0;
        while (i < listItems.length) {
            listItems[i] = String.valueOf(i);
            ++i;
        }
        this.selectionList = new JList<String>(listItems);
        this.selectionList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.selectionList.setSelectionMode(0);
        this.selectionList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                IndividualSelector.this.setSelectedIndividual(IndividualSelector.this.selectionList.getSelectedIndex());
            }
        });
        JScrollPane listScrollPane = new JScrollPane(this.selectionList);
        listScrollPane.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.getContentPane().add((Component)listScrollPane, "West");
        JPanel centerPanel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        centerPanel.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 0.0;
        c.weighty = 0.0;
        gridBag.setConstraints(this.performanceLabel, c);
        centerPanel.add(this.performanceLabel);
        this.metaDataViewer = new MetaDataViewer(population.get(0).getExampleSet());
        JScrollPane metaDataPane = new JScrollPane(this.metaDataViewer);
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridBag.setConstraints(metaDataPane, c);
        centerPanel.add(metaDataPane);
        this.selectionList.setSelectedIndex(0);
        this.getContentPane().add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IndividualSelector.this.ok();
            }
        });
        buttonPanel.add(okButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        if (width < 0 || height < 0) {
            this.setSize(800, 600);
        } else {
            this.setSize(width, height);
        }
        this.setLocationRelativeTo(owner);
    }

    private void ok() {
        this.dispose();
    }

    public void setSelectedIndividual(int index) {
        Individual selected = this.population.get(index);
        PerformanceVector performance = selected.getPerformance();
        StringBuffer performanceString = new StringBuffer();
        int i = 0;
        while (i < performance.getSize()) {
            if (i != 0) {
                performanceString.append(", ");
            }
            PerformanceCriterion pc = performance.getCriterion(i);
            performanceString.append(String.valueOf(pc.getName()) + " = " + Tools.formatNumber(pc.getAverage()) + " (fitness: " + Tools.formatNumber(pc.getFitness()) + ")");
            ++i;
        }
        this.performanceLabel.setText(performanceString.toString());
        this.performanceLabel.repaint();
        this.metaDataViewer.setExampleSet(selected.getExampleSet());
    }

    public Individual getSelectedIndividual() {
        int index = this.selectionList.getSelectedIndex();
        if (index >= 0 && index < this.population.getNumberOfIndividuals()) {
            return this.population.get(index);
        }
        return null;
    }
}

